/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.model;

import com.legacy.rediscovered.entity.dragon.AbstractRedDragonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class RedDragonModel<T extends AbstractRedDragonEntity>
extends EntityModel<T> {
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart jaw;
    private final ModelPart body;
    private final ModelPart leftWing;
    private final ModelPart leftWingTip;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftFrontLegTip;
    private final ModelPart leftFrontFoot;
    private final ModelPart leftRearLeg;
    private final ModelPart leftRearLegTip;
    private final ModelPart leftRearFoot;
    private final ModelPart rightWing;
    private final ModelPart rightWingTip;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightFrontLegTip;
    private final ModelPart rightFrontFoot;
    private final ModelPart rightRearLeg;
    private final ModelPart rightRearLegTip;
    private final ModelPart rightRearFoot;
    @Nullable
    private T entity;
    private float partialTicks;
    private float limbSwing;
    private float limbSwingAmount;
    public float scaleSize = -1.0f;
    public boolean scaleWings = false;
    private final List<ModelPart> scales;
    private final List<ModelPart> wings;

    public RedDragonModel(ModelPart pRoot) {
        int i;
        this.head = pRoot.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.neck = pRoot.m_171324_("neck");
        this.body = pRoot.m_171324_("body");
        this.leftWing = pRoot.m_171324_("left_wing");
        this.leftWingTip = this.leftWing.m_171324_("left_wing_tip");
        this.leftFrontLeg = pRoot.m_171324_("left_front_leg");
        this.leftFrontLegTip = this.leftFrontLeg.m_171324_("left_front_leg_tip");
        this.leftFrontFoot = this.leftFrontLegTip.m_171324_("left_front_foot");
        this.leftRearLeg = pRoot.m_171324_("left_hind_leg");
        this.leftRearLegTip = this.leftRearLeg.m_171324_("left_hind_leg_tip");
        this.leftRearFoot = this.leftRearLegTip.m_171324_("left_hind_foot");
        this.rightWing = pRoot.m_171324_("right_wing");
        this.rightWingTip = this.rightWing.m_171324_("right_wing_tip");
        this.rightFrontLeg = pRoot.m_171324_("right_front_leg");
        this.rightFrontLegTip = this.rightFrontLeg.m_171324_("right_front_leg_tip");
        this.rightFrontFoot = this.rightFrontLegTip.m_171324_("right_front_foot");
        this.rightRearLeg = pRoot.m_171324_("right_hind_leg");
        this.rightRearLegTip = this.rightRearLeg.m_171324_("right_hind_leg_tip");
        this.rightRearFoot = this.rightRearLegTip.m_171324_("right_hind_foot");
        this.scales = new ArrayList<ModelPart>();
        this.scales.add(this.neck.m_171324_("scale1"));
        for (i = 1; i <= 2; ++i) {
            this.scales.add(this.head.m_171324_("scale" + i));
        }
        for (i = 1; i <= 3; ++i) {
            this.scales.add(this.body.m_171324_("scale" + i));
        }
        this.wings = List.of(this.rightWing, this.rightWingTip, this.leftWing, this.leftWingTip);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation bodyScale, CubeDeformation scale) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171544_("upperlip", -6.0f, -1.0f, -24.0f, 12, 5, 16, scale, 176, 44).m_171544_("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16, scale, 112, 30).m_171555_(true).m_171534_("scale", -5.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).m_171544_("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4, scale, 112, 0).m_171555_(false).m_171534_("scale", 3.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).m_171544_("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4, scale, 112, 0), PartPose.f_171404_);
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171544_("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16, scale, 176, 65), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-8.0f));
        head.m_171599_("scale1", CubeListBuilder.m_171558_().m_171480_().m_171534_("scale", -1.0f, -4.0f, -3.0f, 2, 4, 6, 0, 0), PartPose.m_171419_((float)-4.0f, (float)-8.0f, (float)-1.0f));
        head.m_171599_("scale2", CubeListBuilder.m_171558_().m_171534_("scale", -1.0f, -4.0f, -3.0f, 2, 4, 6, 0, 0), PartPose.m_171419_((float)4.0f, (float)-8.0f, (float)-1.0f));
        PartDefinition neck = root.m_171599_("neck", CubeListBuilder.m_171558_().m_171544_("box", -5.0f, -5.0f, -5.0f, 10, 10, 10, scale, 192, 104).m_171534_("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6, 48, 0), PartPose.f_171404_);
        neck.m_171599_("scale1", CubeListBuilder.m_171558_().m_171534_("scale", -1.0f, -4.0f, -3.0f, 2, 4, 6, 48, 0), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171544_("body", -12.0f, 0.0f, -16.0f, 24, 24, 64, bodyScale, 0, 0).m_171534_("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12, 220, 53).m_171534_("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12, 220, 53).m_171534_("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12, 220, 53), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)8.0f));
        body.m_171599_("scale1", CubeListBuilder.m_171558_().m_171534_("scale", -1.0f, -6.0f, -6.0f, 2, 6, 12, 220, 53), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.0f));
        body.m_171599_("scale2", CubeListBuilder.m_171558_().m_171534_("scale", -1.0f, -6.0f, -6.0f, 2, 6, 12, 220, 53), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)16.0f));
        body.m_171599_("scale3", CubeListBuilder.m_171558_().m_171534_("scale", -1.0f, -6.0f, -6.0f, 2, 6, 12, 220, 53), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)36.0f));
        float wingScale = 0.01f;
        PartDefinition leftWing = root.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171480_().m_171544_("bone", 0.0f, -4.0f, -4.0f, 56, 8, 8, scale, 112, 88).m_171544_("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, new CubeDeformation(wingScale), -56, 88), PartPose.m_171419_((float)12.0f, (float)5.0f, (float)2.0f));
        leftWing.m_171599_("left_wing_tip", CubeListBuilder.m_171558_().m_171480_().m_171544_("bone", 0.0f, -2.0f, -2.0f, 56, 4, 4, scale, 112, 187).m_171544_("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, new CubeDeformation(wingScale), -56, 144), PartPose.m_171419_((float)56.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171544_("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, scale, 112, 104), PartPose.m_171419_((float)12.0f, (float)20.0f, (float)2.0f));
        PartDefinition leftFrontLegTip = leftFrontLeg.m_171599_("left_front_leg_tip", CubeListBuilder.m_171558_().m_171544_("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, scale, 226, 138), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-1.0f));
        leftFrontLegTip.m_171599_("left_front_foot", CubeListBuilder.m_171558_().m_171544_("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, scale, 144, 104), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition leftHindLeg = root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171544_("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, scale, 0, 0), PartPose.m_171419_((float)16.0f, (float)16.0f, (float)42.0f));
        PartDefinition leftHindLegTip = leftHindLeg.m_171599_("left_hind_leg_tip", CubeListBuilder.m_171558_().m_171544_("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, scale, 196, 0), PartPose.m_171419_((float)0.0f, (float)32.0f, (float)-4.0f));
        leftHindLegTip.m_171599_("left_hind_foot", CubeListBuilder.m_171558_().m_171534_("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.m_171419_((float)0.0f, (float)31.0f, (float)4.0f));
        PartDefinition rightWing = root.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171544_("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8, scale, 112, 88).m_171544_("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, new CubeDeformation(wingScale), -56, 88), PartPose.m_171419_((float)-12.0f, (float)5.0f, (float)2.0f));
        rightWing.m_171599_("right_wing_tip", CubeListBuilder.m_171558_().m_171544_("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4, scale, 112, 187).m_171544_("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, new CubeDeformation(wingScale), -56, 144), PartPose.m_171419_((float)-56.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171480_().m_171544_("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, scale, 112, 104), PartPose.m_171419_((float)-12.0f, (float)20.0f, (float)2.0f));
        PartDefinition rightFrontLegTip = rightFrontLeg.m_171599_("right_front_leg_tip", CubeListBuilder.m_171558_().m_171480_().m_171544_("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, scale, 226, 138), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-1.0f));
        rightFrontLegTip.m_171599_("right_front_foot", CubeListBuilder.m_171558_().m_171480_().m_171544_("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, scale, 144, 104), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition rightHindLeg = root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171480_().m_171544_("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, scale, 0, 0), PartPose.m_171419_((float)-16.0f, (float)16.0f, (float)42.0f));
        PartDefinition rightHindLegTip = rightHindLeg.m_171599_("right_hind_leg_tip", CubeListBuilder.m_171558_().m_171480_().m_171544_("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, scale, 196, 0), PartPose.m_171419_((float)0.0f, (float)32.0f, (float)-4.0f));
        rightHindLegTip.m_171599_("right_hind_foot", CubeListBuilder.m_171558_().m_171480_().m_171544_("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, scale, 112, 0), PartPose.m_171419_((float)0.0f, (float)31.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)256, (int)256);
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.entity = pEntity;
        this.partialTicks = pPartialTick;
        this.limbSwing = pLimbSwing;
        this.limbSwingAmount = pLimbSwingAmount;
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }

    public void m_7695_(PoseStack pose, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float pAlpha) {
        RedDragonOffspringEntity mount;
        RedDragonOffspringEntity mount2;
        float f;
        float f2;
        float f3;
        float f4;
        int i;
        float f5;
        float f6;
        float f7;
        float f8;
        float flyInv;
        float f9;
        float ageInTicks = (float)((AbstractRedDragonEntity)((Object)this.entity)).f_19797_ + this.partialTicks;
        T t = this.entity;
        if (t instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t;
            f9 = pet.flyingAnim.getValue(this.partialTicks);
        } else {
            f9 = 1.0f;
        }
        float fly = f9;
        T t2 = this.entity;
        if (t2 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t2;
            v1 = 1.0f - fly;
        } else {
            v1 = flyInv = 0.0f;
        }
        if (this.entity.m_21525_()) {
            f8 = 0.0f;
        } else {
            T t3 = this.entity;
            if (t3 instanceof RedDragonOffspringEntity) {
                RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t3;
                f8 = pet.fallingAnim.getValue(this.partialTicks) * flyInv;
            } else {
                f8 = 1.0f;
            }
        }
        float fall = f8;
        T t4 = this.entity;
        if (t4 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t4;
            f7 = pet.hoverAnim.getValue(this.partialTicks) * fly;
        } else {
            f7 = 0.0f;
        }
        float hover = f7;
        T t5 = this.entity;
        if (t5 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t5;
            f6 = pet.tiredAnim.getValue(this.partialTicks);
        } else {
            f6 = 0.0f;
        }
        float tired = f6;
        T t6 = this.entity;
        if (t6 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t6;
            f5 = pet.sufferingAnim.getValue(this.partialTicks);
        } else {
            f5 = 0.0f;
        }
        float suffering = f5;
        float limbSwingAmount = this.limbSwingAmount;
        limbSwingAmount *= 1.0f - fall;
        float bodyRot = Mth.m_14189_((float)this.partialTicks, (float)((AbstractRedDragonEntity)((Object)this.entity)).f_20884_, (float)((AbstractRedDragonEntity)((Object)this.entity)).f_20883_);
        float headRot = Mth.m_14189_((float)this.partialTicks, (float)((AbstractRedDragonEntity)((Object)this.entity)).f_20886_, (float)((AbstractRedDragonEntity)((Object)this.entity)).f_20885_);
        float extraMul = this.entity.m_20160_() ? 0.0f : flyInv;
        float headYaw = Mth.m_14177_((float)((headRot - bodyRot) * (1.0f + (this.entity.m_6162_() ? 0.2f : 0.5f) * extraMul)));
        float headPitch = Mth.m_14177_((float)(Mth.m_14179_((float)this.partialTicks, (float)((AbstractRedDragonEntity)((Object)this.entity)).f_19860_, (float)this.entity.m_146909_()) * (1.0f + 0.6f * extraMul)));
        bodyRot = Mth.m_14177_((float)bodyRot);
        for (ModelPart wing : this.wings) {
            wing.m_233569_();
        }
        boolean affect = this.scaleSize >= 0.0f;
        float amount = affect ? this.scaleSize : 1.0f;
        for (ModelPart scale : this.scales) {
            scale.f_104207_ = affect;
            scale.m_233569_();
            scale.f_233553_ = amount;
            scale.f_233554_ = amount;
            scale.f_233555_ = Math.max(1.0f, amount * 0.8f);
        }
        for (i = 1; i <= 3; ++i) {
            this.spikeGlowAnim(this.body.m_171324_("scale" + i), -i - 1, 1.0f);
        }
        for (i = 1; i <= 2; ++i) {
            this.spikeGlowAnim(this.head.m_171324_("scale" + i), i, 1.0f);
        }
        T t7 = this.entity;
        if (t7 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t7;
            f4 = boss.windBlowAnim.getValue(this.partialTicks);
        } else {
            f4 = 0.0f;
        }
        float windCharge = f4;
        T t8 = this.entity;
        if (t8 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t8;
            f3 = boss.boltChargeAnim.getValue(this.partialTicks);
        } else {
            f3 = 0.0f;
        }
        float boltCharge = f3;
        T t9 = this.entity;
        if (t9 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t9;
            f2 = boss.boltShootAnim.getValue(this.partialTicks);
        } else {
            f2 = 0.0f;
        }
        float boltShoot = f2;
        T t10 = this.entity;
        if (t10 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t10;
            f = boss.cloudPrepAnim.getValue(this.partialTicks);
        } else {
            f = 0.0f;
        }
        float cloudPrep = f;
        float neckAngle = this.entity.m_21224_() ? -3.0f : 0.0f;
        float headMul = this.entity.m_21224_() ? 3.0f : 1.5f;
        neckAngle += boltCharge * 3.0f / 4.0f;
        neckAngle -= boltCharge * 2.5f * (1.0f - boltShoot);
        neckAngle += windCharge * (2.4f + Mth.m_14089_((float)(ageInTicks * 0.2f)) * 0.4f);
        neckAngle += cloudPrep * (-0.8f + Mth.m_14089_((float)(ageInTicks * 2.0f)) * 0.1f);
        float headAngle = (neckAngle += 1.4f * hover) + Mth.m_14031_((float)(ageInTicks * 2.5f)) * (0.1f * boltShoot);
        T t11 = this.entity;
        if (t11 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t11;
            float tilt = Mth.m_14179_((float)this.partialTicks, (float)boss.getOldXRotModifier(), (float)boss.getXRotModifier()) * boltShoot;
            neckAngle += tilt;
            headAngle += tilt;
        }
        if (this.entity.m_21224_()) {
            neckAngle = -3.0f;
            headAngle = -0.6f;
        } else {
            T tilt = this.entity;
            if (tilt instanceof RedDragonOffspringEntity) {
                RedDragonOffspringEntity pet = (RedDragonOffspringEntity)tilt;
                neckAngle += -2.0f * suffering;
                headAngle += -0.4f * suffering;
            }
        }
        limbSwingAmount *= flyInv;
        pose.m_85836_();
        float f10 = Mth.m_14179_((float)this.partialTicks, (float)((AbstractRedDragonEntity)((Object)this.entity)).prevAnimTime, (float)((AbstractRedDragonEntity)((Object)this.entity)).animTime);
        this.jaw.f_104203_ = (float)(Math.sin(f10 * ((float)Math.PI * 2)) + 1.0) * 0.2f;
        this.jaw.f_104203_ *= 1.0f - boltCharge;
        this.jaw.f_104203_ += boltCharge * 0.75f;
        this.jaw.f_104203_ *= 1.0f - cloudPrep;
        this.jaw.f_104203_ += 0.8f * cloudPrep;
        this.jaw.f_104203_ *= fly;
        float groundedJawAnim = (0.3f - Mth.m_14031_((float)(ageInTicks * 0.1f)) * 0.2f) * flyInv;
        this.jaw.f_104203_ += groundedJawAnim;
        this.jaw.f_104203_ += groundedJawAnim * (0.4f * tired);
        float f1 = (float)(Math.sin(f10 * ((float)Math.PI * 2) - 1.0f) + 1.0) + 4.0f * boltCharge;
        f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
        pose.m_252880_(0.0f, (f1 - 2.0f) * fly + -1.64f * flyInv, -3.0f);
        pose.m_252880_(0.0f, f1 * 5.0f * windCharge, Mth.m_14031_((float)(ageInTicks * 0.25f)) * 0.5f * -windCharge);
        float hoverOffset = 2.3f;
        pose.m_252880_(0.0f, -0.4f * hover, 0.5f * hover);
        pose.m_252781_(Axis.f_252529_.m_252977_(hoverOffset * 2.0f * 10.0f * -hover));
        pose.m_252781_(Axis.f_252529_.m_252977_(f1 * 2.0f * fly));
        float f22 = 0.0f;
        float f32 = 20.0f;
        float f42 = -12.0f;
        double[] adouble = ((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(6, this.partialTicks);
        float f62 = Mth.m_14177_((float)((float)(((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(5, this.partialTicks)[0] - ((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(10, this.partialTicks)[0])));
        float f72 = Mth.m_14177_((float)((float)(((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(5, this.partialTicks)[0] + (double)(f62 / 2.0f))));
        float f82 = f10 * ((float)Math.PI * 2);
        T t12 = this.entity;
        float spinMul = t12 instanceof RedDragonOffspringEntity && (mount2 = (RedDragonOffspringEntity)t12).m_20160_() ? 0.3f * fly : 1.0f * fly;
        float recoilSpeed = 0.3f;
        int neckCount = 5;
        for (int i2 = 0; i2 < neckCount; ++i2) {
            float s;
            double[] adouble1 = ((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(5 - i2, this.partialTicks);
            float f92 = (float)Math.cos((float)i2 * 0.45f + f82) * 0.15f;
            this.neck.f_104204_ = Mth.m_14177_((float)((float)(adouble1[0] - adouble[0]))) * ((float)Math.PI / 180) * (1.5f * fly);
            this.neck.f_104204_ += headYaw * ((float)i2 * 0.25f) * ((float)Math.PI / 180);
            this.neck.f_104203_ = 0.1f * tired + (f92 += -Mth.m_14031_((float)((float)i2 - ageInTicks * 0.1f)) * (0.2f * flyInv)) + neckAngle * (float)i2 * ((float)Math.PI / 180) * 1.5f * 5.0f * fly;
            this.neck.f_104203_ += headPitch * ((float)i2 * 0.25f) * ((float)Math.PI / 180);
            this.neck.f_104205_ = -Mth.m_14177_((float)((float)(adouble1[0] - (double)f72))) * ((float)Math.PI / 180) * 1.5f * spinMul;
            this.neck.f_104203_ += (-0.2f + Mth.m_14031_((float)(this.limbSwing * 0.3f)) * ((float)i2 * 0.05f)) * flyInv * limbSwingAmount;
            this.neck.f_104204_ += Mth.m_14089_((float)(this.limbSwing * recoilSpeed / 2.0f)) * ((float)i2 * 0.025f) * flyInv * limbSwingAmount;
            this.neck.f_104201_ = f32;
            this.neck.f_104202_ = f42;
            this.neck.f_104200_ = f22;
            this.neck.f_233553_ = s = i2 % 2 == 0 ? 1.0f : 0.99f;
            this.neck.f_233554_ = s;
            this.neck.f_233555_ = s;
            this.spikeGlowAnim(this.neck.m_171324_("scale1"), i2, 1.0f);
            f32 += Mth.m_14031_((float)this.neck.f_104203_) * 10.0f;
            f42 -= Mth.m_14089_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
            f22 -= Mth.m_14031_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
            this.neck.m_104306_(pose, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
        }
        this.partScale(this.head, this.entity.m_6162_() ? 1.6f : 1.0f);
        this.head.f_104201_ = f32;
        this.head.f_104202_ = f42;
        this.head.f_104200_ = f22;
        double[] adouble2 = ((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(0, this.partialTicks);
        this.head.f_104204_ = Mth.m_14177_((float)((float)(adouble2[0] - adouble[0]))) * ((float)Math.PI / 180) * fly;
        this.head.f_104204_ += headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = Mth.m_14177_((float)(headAngle * (float)(neckCount + 1))) * ((float)Math.PI / 180) * headMul * (5.0f * fly);
        this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
        this.head.f_104203_ += (0.5f + Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.2f) * tired;
        this.head.f_104205_ = -Mth.m_14177_((float)((float)(adouble2[0] - (double)f72))) * ((float)Math.PI / 180) * fly;
        this.head.f_104204_ -= Mth.m_14089_((float)(this.limbSwing * recoilSpeed / 2.0f)) * 0.025f * flyInv * limbSwingAmount;
        this.head.f_104205_ += Mth.m_14031_((float)this.head.f_104204_) * hover * fly;
        this.head.m_104306_(pose, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
        pose.m_85836_();
        pose.m_252880_(0.0f, 1.0f, 0.0f);
        float spin = -f62 * 1.5f;
        T s = this.entity;
        if (s instanceof RedDragonOffspringEntity && (mount = (RedDragonOffspringEntity)s).m_20160_()) {
            spin = Mth.m_14036_((float)(spin * 0.3f), (float)-30.0f, (float)30.0f);
        }
        pose.m_252781_(Axis.f_252403_.m_252977_(spin * fly));
        pose.m_252880_(0.0f, -1.0f, 0.0f);
        this.body.f_104205_ = 0.0f;
        this.body.m_104306_(pose, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
        float f102 = f10 * ((float)Math.PI * 2);
        this.leftWing.f_104203_ = 0.125f - (float)Math.cos(f102) * (0.2f + 0.4f * windCharge);
        this.leftWing.f_104204_ = -0.25f + 0.25f * windCharge;
        this.leftWing.f_104205_ = -((float)(Math.sin(f102) + 0.125)) * (0.8f + 0.4f * windCharge);
        this.leftWingTip.f_104205_ = (float)(Math.sin(f102 + 2.0f) + 0.5) * 0.75f;
        this.rightWing.f_104203_ = this.leftWing.f_104203_;
        this.rightWing.f_104204_ = -this.leftWing.f_104204_;
        this.rightWing.f_104205_ = -this.leftWing.f_104205_;
        this.rightWingTip.f_104205_ = -this.leftWingTip.f_104205_;
        this.renderSide(false, limbSwingAmount, pose, pBuffer, pPackedLight, pPackedOverlay, f1, this.leftWing, this.leftWingTip, this.leftFrontLeg, this.leftFrontLegTip, this.leftFrontFoot, this.leftRearLeg, this.leftRearLegTip, this.leftRearFoot, red, green, blue, pAlpha);
        this.renderSide(true, limbSwingAmount, pose, pBuffer, pPackedLight, pPackedOverlay, f1, this.rightWing, this.rightWingTip, this.rightFrontLeg, this.rightFrontLegTip, this.rightFrontFoot, this.rightRearLeg, this.rightRearLegTip, this.rightRearFoot, red, green, blue, pAlpha);
        pose.m_85849_();
        float baseTailX = 0.0f;
        f82 = f10 * ((float)Math.PI * 2);
        f32 = 10.0f;
        f42 = 60.0f;
        f22 = 0.0f;
        adouble = ((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(11, this.partialTicks);
        for (int j = 0; j < 12; ++j) {
            adouble2 = ((AbstractRedDragonEntity)((Object)this.entity)).getLatencyPos(12 + j, this.partialTicks);
            baseTailX += Mth.m_14031_((float)((float)(-j) * 0.45f + f82)) * -0.05f;
            float sin = Mth.m_14031_((float)((float)j * 0.2f - ageInTicks * 0.1f));
            baseTailX += -sin * ((float)j * 0.03f * flyInv);
            if (j == 0) {
                baseTailX -= 0.3f * flyInv;
            }
            this.neck.f_104204_ = (Mth.m_14177_((float)((float)(adouble2[0] - adouble[0]))) * 1.5f + 180.0f) * ((float)Math.PI / 180) * fly + (float)Math.PI * flyInv;
            this.neck.f_104204_ += Mth.m_14089_((float)((float)j * 0.2f - ageInTicks * 0.05f)) * flyInv * ((float)(j + 1) * 0.1f);
            this.neck.f_104203_ = (baseTailX -= 0.1f * hover * fly) + ((float)(adouble2[1] - adouble[1]) * ((float)Math.PI / 180) * (1.5f * spinMul) * (5.0f * fly) - 0.2f * (float)j * boltCharge - 0.2f * (float)j * windCharge - 0.2f * (float)j * cloudPrep * fly);
            this.neck.f_104205_ = Mth.m_14177_((float)((float)(adouble2[0] - (double)f72))) * ((float)Math.PI / 180) * (1.5f * spinMul) * fly;
            this.neck.f_104201_ = f32;
            this.neck.f_104202_ = f42;
            this.neck.f_104200_ = f22;
            this.spikeGlowAnim(this.neck.m_171324_("scale1"), -j, 1.0f);
            f32 += Mth.m_14031_((float)this.neck.f_104203_) * 10.0f;
            f42 -= Mth.m_14089_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
            f22 -= Mth.m_14031_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
            this.neck.m_104306_(pose, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
        }
        pose.m_85849_();
    }

    private void renderSide(boolean right, float limbSwingAmount, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float p_173982_, ModelPart wing, ModelPart wingTip, ModelPart frontLeg, ModelPart frontLegTip, ModelPart frontFoot, ModelPart rearLeg, ModelPart rearLegTip, ModelPart rearFoot, float red, float green, float blue, float pAlpha) {
        float newShinTheta;
        float newHeelX;
        float groundDist;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float ageInTicks = (float)((AbstractRedDragonEntity)((Object)this.entity)).f_19797_ + this.partialTicks;
        rearLeg.m_233569_();
        rearLegTip.m_233569_();
        rearFoot.m_233569_();
        frontLeg.m_233569_();
        frontLegTip.m_233569_();
        frontFoot.m_233569_();
        T t = this.entity;
        if (t instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t;
            f9 = pet.flyingAnim.getValue(this.partialTicks);
        } else {
            f9 = 1.0f;
        }
        float fly = f9;
        float flyInv = 1.0f - fly;
        if (this.entity.m_21525_()) {
            f8 = 0.0f;
        } else {
            T t2 = this.entity;
            if (t2 instanceof RedDragonOffspringEntity) {
                RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t2;
                f8 = pet.fallingAnim.getValue(this.partialTicks);
            } else {
                f8 = 1.0f;
            }
        }
        float fall = f8;
        float fallInv = 1.0f - fall;
        T t3 = this.entity;
        if (t3 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t3;
            f7 = pet.hoverAnim.getValue(this.partialTicks) * fly;
        } else {
            f7 = 0.0f;
        }
        float hover = f7;
        T t4 = this.entity;
        if (t4 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t4;
            f6 = pet.tiredAnim.getValue(this.partialTicks);
        } else {
            f6 = 1.0f;
        }
        float tired = f6;
        T t5 = this.entity;
        if (t5 instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity pet = (RedDragonOffspringEntity)t5;
            f5 = 1.0f - tired;
        } else {
            f5 = 0.0f;
        }
        float tiredInv = f5;
        T t6 = this.entity;
        if (t6 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t6;
            f4 = boss.windBlowAnim.getValue(this.partialTicks);
        } else {
            f4 = 0.0f;
        }
        float windCharge = f4;
        T t7 = this.entity;
        if (t7 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t7;
            f3 = boss.boltChargeAnim.getValue(this.partialTicks);
        } else {
            f3 = 0.0f;
        }
        float boltCharge = f3;
        T t8 = this.entity;
        if (t8 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t8;
            f2 = boss.boltShootAnim.getValue(this.partialTicks);
        } else {
            f2 = 0.0f;
        }
        float boltShoot = f2;
        T t9 = this.entity;
        if (t9 instanceof RedDragonBossEntity) {
            RedDragonBossEntity boss = (RedDragonBossEntity)t9;
            f = boss.cloudPrepAnim.getValue(this.partialTicks);
        } else {
            f = 0.0f;
        }
        float cloudPrep = f;
        float f10 = Mth.m_14179_((float)this.partialTicks, (float)((AbstractRedDragonEntity)((Object)this.entity)).prevAnimTime, (float)((AbstractRedDragonEntity)((Object)this.entity)).animTime);
        float sin = -Mth.m_14031_((float)(f10 * ((float)Math.PI * 2)));
        rearLeg.f_104203_ = 1.0f + p_173982_ * 0.1f - (0.5f + sin * (0.2f * boltShoot)) * boltShoot;
        rearLegTip.f_104203_ = 0.5f + p_173982_ * 0.1f;
        rearFoot.f_104203_ = 0.75f + p_173982_ * 0.1f;
        float wingTicks = f10 * ((float)Math.PI * 2) * 1.0f;
        rearLeg.f_104203_ += Mth.m_14089_((float)wingTicks) * (cloudPrep + windCharge) * (0.3f - 0.15f * cloudPrep);
        rearLegTip.f_104203_ += Mth.m_14031_((float)wingTicks) * (cloudPrep + windCharge) * (0.3f - 0.15f * cloudPrep);
        rearLeg.f_104203_ += (Mth.m_14089_((float)wingTicks) - 3.0f) * (hover * 0.2f);
        rearLegTip.f_104203_ += (Mth.m_14031_((float)wingTicks) + 2.0f) * (hover * 0.2f);
        rearLeg.f_104203_ += 0.5f * cloudPrep;
        frontLeg.f_104203_ = 1.3f + p_173982_ * 0.1f;
        frontLegTip.f_104203_ = -0.5f - p_173982_ * 0.1f;
        frontFoot.f_104203_ = 0.75f + p_173982_ * 0.1f;
        frontLeg.f_104203_ -= (3.2f - 0.8f * (boltShoot * boltShoot) + -Mth.m_14031_((float)(f10 * ((float)Math.PI * 2) * 3.0f)) * boltShoot * 0.05f) * boltCharge * boltCharge;
        frontLegTip.f_104203_ += 1.0f * boltCharge;
        frontFoot.f_104203_ += -0.3f * boltCharge;
        frontLeg.f_104203_ -= -Mth.m_14031_((float)wingTicks) * windCharge * 0.2f + 0.7f * windCharge;
        frontFoot.f_104203_ -= 0.4f * windCharge;
        frontLeg.f_104205_ = -0.3f * windCharge;
        frontLeg.f_104204_ = -0.4f * boltCharge;
        frontLeg.f_104205_ += -0.2f * boltCharge;
        frontLeg.f_104203_ -= 2.2f * cloudPrep;
        frontLeg.f_104204_ += (-0.4f + Mth.m_14031_((float)(ageInTicks * 2.0f)) * 0.1f) * cloudPrep;
        frontLeg.f_104205_ -= (-0.2f + Mth.m_14031_((float)(ageInTicks * 2.0f)) * 0.1f) * cloudPrep;
        frontLeg.f_104203_ += (-0.9f + Mth.m_14089_((float)(1.0f - wingTicks)) * 0.1f) * hover;
        frontLeg.f_104205_ -= (0.5f + Mth.m_14031_((float)(1.0f - wingTicks)) * 0.1f) * hover;
        frontLegTip.f_104203_ -= Mth.m_14031_((float)(1.0f - wingTicks)) * 0.2f * hover;
        if (right) {
            frontLeg.f_104204_ = -frontLeg.f_104204_;
            frontLeg.f_104205_ = -frontLeg.f_104205_;
        }
        rearLeg.f_104203_ *= fly;
        rearLegTip.f_104203_ *= fly;
        rearFoot.f_104203_ *= fly;
        frontLeg.f_104203_ *= fly;
        frontLegTip.f_104203_ *= fly;
        frontFoot.f_104203_ *= fly;
        wing.f_104203_ *= fly;
        wing.f_104204_ *= fly;
        wing.f_104205_ *= fly;
        wingTip.f_104203_ *= fly;
        wingTip.f_104204_ *= fly;
        wingTip.f_104205_ *= fly;
        rearLeg.f_104202_ += 8.0f * flyInv;
        rearLeg.f_104203_ -= 1.0f * flyInv;
        rearLegTip.f_104203_ += 2.0f * flyInv;
        rearLegTip.f_104202_ += 3.0f * flyInv;
        frontLeg.f_104202_ -= 3.0f * flyInv * limbSwingAmount;
        float footHeight = 1.75f;
        float diff = -3.0f;
        rearFoot.f_104201_ -= (footHeight - diff) * flyInv;
        rearFoot.f_104202_ += (footHeight + diff) * flyInv;
        float frontLegAngle = 1.0f * flyInv;
        float frontTipAngle = 1.88f * flyInv;
        frontLeg.f_104203_ += frontLegAngle - 0.0f * limbSwingAmount;
        frontLegTip.f_104203_ -= frontTipAngle;
        float groundedWingMul = flyInv * fallInv;
        float fallingWingMul = flyInv * fall;
        frontLeg.f_104203_ -= (0.5f - Mth.m_14031_((float)(ageInTicks * 0.3f)) * 0.1f) * fallingWingMul;
        frontLegTip.f_104203_ += (0.3f - Mth.m_14089_((float)(ageInTicks * 0.3f)) * 0.1f) * fallingWingMul;
        frontFoot.f_104203_ += -0.1f * fallingWingMul;
        rearLeg.f_104203_ -= (0.2f - Mth.m_14031_((float)(((float)((AbstractRedDragonEntity)((Object)this.entity)).f_19797_ + this.partialTicks) * 0.3f)) * 0.1f) * fallingWingMul;
        rearLegTip.f_104203_ -= (0.2f - Mth.m_14089_((float)(((float)((AbstractRedDragonEntity)((Object)this.entity)).f_19797_ + this.partialTicks) * 0.3f)) * 0.1f) * fallingWingMul;
        rearFoot.f_104203_ -= 0.2f * fallingWingMul;
        if (right) {
            groundedWingMul = -groundedWingMul;
            fallingWingMul = -fallingWingMul;
        }
        frontLeg.f_104200_ += 3.0f * fallingWingMul;
        frontLeg.f_104204_ -= 0.3f * fallingWingMul;
        rearLeg.f_104204_ -= 0.5f * fallingWingMul;
        wing.f_104204_ += -0.2f * groundedWingMul;
        wing.f_104205_ += (0.5f * tired + -1.2f + Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.1f) * groundedWingMul;
        wingTip.f_104205_ += (-0.8f * tired + 2.3f + Mth.m_14031_((float)(ageInTicks * 0.1f)) * 0.1f) * groundedWingMul;
        wing.f_104205_ += Mth.m_14031_((float)(this.limbSwing * 0.3f)) * 0.1f * groundedWingMul * limbSwingAmount;
        wingTip.f_104205_ += Mth.m_14089_((float)(this.limbSwing * 0.3f)) * 0.1f * groundedWingMul * limbSwingAmount;
        wing.f_104204_ += -0.1f * fallingWingMul;
        wing.f_104205_ += (-0.7f + Mth.m_14089_((float)(ageInTicks * 0.5f)) * 0.1f) * fallingWingMul;
        wingTip.f_104205_ += (0.5f + Mth.m_14031_((float)(ageInTicks * 0.5f)) * 0.2f) * fallingWingMul;
        float legRange = 0.6f;
        float limbSpeed = 0.3f;
        rearLeg.f_104201_ -= 1.5f * limbSwingAmount;
        float thighSin = -0.2f + Mth.m_14031_((float)(this.limbSwing * limbSpeed + (!right ? (float)Math.PI : 0.0f))) * legRange * limbSwingAmount;
        float frontThighRot = -thighSin;
        rearLeg.f_104203_ += frontThighRot * limbSwingAmount;
        float tipSin = Mth.m_14089_((float)(this.limbSwing * limbSpeed + (right ? (float)Math.PI : 0.0f))) * legRange * limbSwingAmount * 0.5f;
        float frontTipRot = -tipSin;
        rearLegTip.f_104203_ += frontTipRot * limbSwingAmount;
        float thighUnit = 33.0f;
        float thighTheta = rearLeg.f_104203_ - 1.5707964f;
        float kneeX = thighUnit * Mth.m_14089_((float)thighTheta);
        float kneeY = thighUnit * Mth.m_14031_((float)thighTheta);
        float shinUnit = 30.0f;
        float shinTheta = rearLeg.f_104203_ + rearLegTip.f_104203_ - 1.5707964f;
        float heelX = shinUnit * Mth.m_14089_((float)shinTheta) + kneeX;
        float heelY = shinUnit * Mth.m_14031_((float)shinTheta) + kneeY;
        float minHeelY = -35.5f;
        boolean footOnGround = heelY < minHeelY;
        float footPressure = heelY / minHeelY - 1.0f;
        if (footOnGround && fly == 0.0f && fall == 0.0f) {
            groundDist = minHeelY - kneeY;
            newHeelX = (float)Math.sqrt(shinUnit * shinUnit - groundDist * groundDist);
            Vector3f v = new Vector3f(newHeelX, groundDist, 0.0f).rotateZ(-rearLeg.f_104203_);
            newShinTheta = (float)Math.atan2(v.y(), v.x());
            rearLegTip.f_104203_ = newShinTheta + 1.5707964f;
        }
        float rot = (0.027415568f - (rearLeg.f_104203_ + rearLegTip.f_104203_)) * flyInv;
        float footRot = Mth.m_14089_((float)((-this.limbSwing * limbSpeed + (right ? (float)Math.PI : 0.0f) + 1.6415927f) * 2.0f)) * legRange * limbSwingAmount * 0.2f + 0.3f * limbSwingAmount;
        float apexFootRotModifier = -Mth.m_14089_((float)((-this.limbSwing * limbSpeed + (right ? (float)Math.PI : 0.0f) + 1.6415927f) * 1.0f)) * legRange * limbSwingAmount * 0.7f + 0.1f * limbSwingAmount;
        footRot -= apexFootRotModifier;
        if (footOnGround) {
            footRot *= Mth.m_14036_((float)(1.0f - footPressure * 5.0f), (float)0.0f, (float)1.0f);
        }
        rearFoot.f_104203_ += Math.max(-1.5835f, rot + footRot) * flyInv;
        frontThighRot = thighSin = -Mth.m_14031_((float)(-this.limbSwing * limbSpeed + (!right ? (float)Math.PI : 0.0f))) * legRange * limbSwingAmount;
        frontLeg.f_104203_ += frontThighRot * limbSwingAmount;
        frontTipRot = tipSin = -Mth.m_14089_((float)(-this.limbSwing * limbSpeed + (right ? (float)Math.PI : 0.0f))) * legRange * limbSwingAmount;
        frontLegTip.f_104203_ += frontTipRot * limbSwingAmount;
        thighUnit = 24.0f;
        thighTheta = frontLeg.f_104203_ - 1.5707964f;
        kneeX = thighUnit * Mth.m_14089_((float)thighTheta);
        kneeY = thighUnit * Mth.m_14031_((float)thighTheta);
        shinUnit = 28.0f;
        shinTheta = frontLeg.f_104203_ + frontLegTip.f_104203_ - 1.5707964f;
        heelX = shinUnit * Mth.m_14089_((float)shinTheta) + kneeX;
        heelY = shinUnit * Mth.m_14031_((float)shinTheta) + kneeY;
        minHeelY = -31.5f;
        footOnGround = heelY < minHeelY;
        footPressure = heelY / minHeelY - 1.0f;
        if (footOnGround && fly == 0.0f && fall == 0.0f) {
            groundDist = minHeelY - kneeY;
            newHeelX = (float)(-Math.sqrt(shinUnit * shinUnit - groundDist * groundDist));
            Vector3f v = new Vector3f(newHeelX, groundDist, 0.0f).rotateZ(-frontLeg.f_104203_);
            newShinTheta = (float)Math.atan2(v.y(), v.x());
            frontLegTip.f_104203_ = newShinTheta + 1.5707964f;
        }
        frontFoot.f_104203_ -= (frontLeg.f_104203_ + frontLegTip.f_104203_) * flyInv;
        float footRot2 = Mth.m_14089_((float)((-this.limbSwing * limbSpeed + (right ? (float)Math.PI : 0.0f) + 2.7415926f) * 1.0f)) * legRange * limbSwingAmount * 0.3f;
        if (footOnGround) {
            footRot2 *= 1.0f - footPressure * 3.0f;
        }
        frontFoot.f_104203_ += footRot2;
        wing.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
        frontLeg.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
        rearLeg.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, red, green, blue, pAlpha);
    }

    public void spikeGlowAnim(ModelPart part, int offset, float mod) {
        float speed = 0.7f;
        part.f_233554_ += Mth.m_14089_((float)(((float)offset * 1.5707964f + ((float)((AbstractRedDragonEntity)((Object)this.entity)).f_19797_ + this.partialTicks)) * speed)) * 0.3f;
        part.f_233553_ += Mth.m_14031_((float)(((float)offset * 1.5707964f + ((float)((AbstractRedDragonEntity)((Object)this.entity)).f_19797_ + this.partialTicks)) * speed * 2.0f)) * 0.6f;
        part.f_233554_ = Math.max(part.f_233554_, 1.0f);
        part.f_233553_ = Math.max(part.f_233553_, 1.0f);
    }

    public void partScale(ModelPart part, float scale) {
        part.f_233554_ = part.f_233555_ = scale;
        part.f_233553_ = part.f_233555_;
    }
}

