/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RanaModel<T extends LivingEntity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart right_hat_eye;
    private final ModelPart left_hat_eye;
    private final ModelPart right_hair;
    private final ModelPart left_hair;
    private final ModelPart right_pigtail;
    private final ModelPart left_pigtail;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart left_leg;
    private final ModelPart lower_left_leg;
    private final ModelPart left_boot;
    private final ModelPart right_leg;
    private final ModelPart lower_right_leg;
    private final ModelPart right_boot;

    public RanaModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.right_hair = this.head.m_171324_("right_hair");
        this.left_hair = this.head.m_171324_("left_hair");
        this.right_pigtail = this.head.m_171324_("right_pigtail");
        this.left_pigtail = this.head.m_171324_("left_pigtail");
        this.right_hat_eye = this.hat.m_171324_("right_hat_eye");
        this.left_hat_eye = this.hat.m_171324_("left_hat_eye");
        this.body = root.m_171324_("body");
        this.right_arm = root.m_171324_("right_arm");
        this.left_arm = root.m_171324_("left_arm");
        this.left_leg = root.m_171324_("left_leg");
        this.lower_left_leg = this.left_leg.m_171324_("lower_left_leg");
        this.left_boot = this.lower_left_leg.m_171324_("left_boot");
        this.right_leg = root.m_171324_("right_leg");
        this.lower_right_leg = this.right_leg.m_171324_("lower_right_leg");
        this.right_boot = this.lower_right_leg.m_171324_("right_boot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, -20.0f, -8.5f, 20.0f, 20.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(0, 37).m_171488_(-10.0f, -20.0f, -8.5f, 20.0f, 20.0f, 17.0f, new CubeDeformation(0.5f)).m_171514_(57, 0).m_171488_(10.0f, -10.0f, -1.0f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(57, 0).m_171480_().m_171488_(-12.0f, -10.0f, -1.0f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition right_hair = head.m_171599_("right_hair", CubeListBuilder.m_171558_().m_171514_(53, 109).m_171480_().m_171488_(0.0f, -6.5f, -6.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-10.0f, (float)-5.5f, (float)-3.5f));
        PartDefinition right_pigtail = head.m_171599_("right_pigtail", CubeListBuilder.m_171558_().m_171514_(78, 106).m_171480_().m_171488_(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(72, 115).m_171480_().m_171488_(-3.0f, 3.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-6.0f, (float)7.5f));
        PartDefinition left_pigtail = head.m_171599_("left_pigtail", CubeListBuilder.m_171558_().m_171514_(78, 106).m_171488_(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(72, 115).m_171488_(-3.0f, 3.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-6.0f, (float)7.5f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 74).m_171488_(-12.0f, -5.5f, -5.5f, 24.0f, 11.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.5f, (float)-5.0f));
        PartDefinition right_hat_eye = hat.m_171599_("right_hat_eye", CubeListBuilder.m_171558_().m_171514_(0, 114).m_171480_().m_171488_(-8.0f, -8.0f, 0.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-5.5f, (float)2.0f));
        PartDefinition left_hat_eye = hat.m_171599_("left_hat_eye", CubeListBuilder.m_171558_().m_171514_(0, 114).m_171488_(0.0f, -8.0f, 0.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-5.5f, (float)2.0f));
        PartDefinition left_hair = head.m_171599_("left_hair", CubeListBuilder.m_171558_().m_171514_(53, 109).m_171488_(0.0f, -6.5f, -6.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)-5.5f, (float)-3.5f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-5.0f, -6.3333f, -2.1667f, 10.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(100, 18).m_171488_(-5.0f, -6.3333f, -2.1667f, 10.0f, 14.0f, 4.0f, new CubeDeformation(0.499f)).m_171514_(57, 10).m_171488_(-3.0f, -9.3333f, -1.6667f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(29, 115).m_171488_(-4.5f, -6.3333f, 2.3333f, 9.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.3333f, (float)0.1667f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(112, 37).m_171480_().m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(112, 57).m_171480_().m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)-1.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(112, 37).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(112, 57).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)5.0f, (float)-1.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(95, 37).m_171488_(-2.5f, -1.25f, -1.5f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)3.5f, (float)11.25f, (float)-0.5f));
        PartDefinition lower_left_leg = left_leg.m_171599_("lower_left_leg", CubeListBuilder.m_171558_().m_171514_(95, 49).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)6.75f, (float)-1.5f));
        PartDefinition left_boot = lower_left_leg.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(95, 59).m_171488_(1.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(97, 69).m_171488_(1.0f, -2.0f, -4.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)6.0f, (float)2.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(95, 37).m_171480_().m_171488_(-1.5f, -1.25f, -1.5f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171419_((float)-3.5f, (float)11.25f, (float)-0.5f));
        PartDefinition lower_right_leg = right_leg.m_171599_("lower_right_leg", CubeListBuilder.m_171558_().m_171514_(95, 49).m_171480_().m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)6.75f, (float)-1.5f));
        PartDefinition right_boot = lower_right_leg.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(97, 69).m_171480_().m_171488_(-5.0f, -2.0f, -4.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(95, 59).m_171480_().m_171488_(-5.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)6.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack rightItem;
        this.head.m_233569_();
        this.right_hair.m_233569_();
        this.left_hair.m_233569_();
        this.right_pigtail.m_233569_();
        this.left_pigtail.m_233569_();
        this.head.f_104204_ = netHeadYaw / 57.29578f;
        this.head.f_104203_ = headPitch / 57.29578f;
        this.right_hair.f_104204_ = 0.3926991f;
        this.left_hair.f_104204_ = -this.right_hair.f_104204_;
        this.right_pigtail.f_104204_ = 2.3561945f;
        this.left_pigtail.f_104204_ = -this.right_pigtail.f_104204_;
        this.left_pigtail.f_104203_ = this.right_pigtail.f_104203_ = -0.5235988f + limbSwingAmount * -0.4f;
        this.body.m_233569_();
        this.right_leg.m_233569_();
        this.left_leg.m_233569_();
        this.lower_right_leg.m_233569_();
        this.lower_left_leg.m_233569_();
        this.right_arm.m_233569_();
        this.left_arm.m_233569_();
        float bootScale = 1.25f;
        this.left_boot.f_104200_ = -3.75f;
        this.left_boot.f_104201_ = 6.5f;
        this.left_boot.f_233553_ = bootScale;
        this.left_boot.f_233554_ = bootScale;
        this.left_boot.f_233555_ = bootScale;
        this.right_boot.f_104200_ = 3.75f;
        this.right_boot.f_104201_ = 6.5f;
        this.right_boot.f_233553_ = bootScale;
        this.right_boot.f_233554_ = bootScale;
        this.right_boot.f_233555_ = bootScale;
        this.right_arm.f_104205_ += 0.1f;
        this.left_arm.f_104205_ -= 0.1f;
        AnimationUtils.m_102082_((ModelPart)this.right_arm, (ModelPart)this.left_arm, (float)ageInTicks);
        float range = 0.6662f;
        this.right_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * range)) * limbSwingAmount;
        this.left_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * range + (float)Math.PI)) * limbSwingAmount;
        float offset = 0.2f;
        this.lower_right_leg.f_104203_ += Math.max(0.0f, Mth.m_14031_((float)(offset + limbSwing * range)) * limbSwingAmount);
        this.lower_left_leg.f_104203_ += Math.max(0.0f, Mth.m_14031_((float)(offset + limbSwing * range + (float)Math.PI)) * limbSwingAmount);
        this.left_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * range)) * limbSwingAmount;
        this.right_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * range + (float)Math.PI)) * limbSwingAmount;
        float swing = limbSwingAmount / 2.0f;
        this.left_arm.f_104205_ += -swing + Mth.m_14089_((float)(limbSwing * range + (float)Math.PI)) * swing * -swing;
        this.right_arm.f_104205_ += swing + Mth.m_14089_((float)(limbSwing * range)) * swing * swing;
        this.body.f_104203_ += limbSwingAmount * 0.2f;
        this.body.f_104202_ -= limbSwingAmount * 1.5f;
        this.head.f_104202_ -= limbSwingAmount * 2.5f;
        boolean rightHanded = entity.m_5737_() == HumanoidArm.RIGHT;
        ItemStack leftItem = rightHanded ? entity.m_21206_() : entity.m_21205_();
        ItemStack itemStack = rightItem = rightHanded ? entity.m_21205_() : entity.m_21206_();
        if (!rightItem.m_41619_()) {
            this.right_arm.f_104203_ -= 0.2f;
        }
        if (!leftItem.m_41619_()) {
            this.left_arm.f_104203_ -= 0.2f;
        }
        if (((LivingEntity)entity).f_20912_ == InteractionHand.MAIN_HAND && rightHanded || ((LivingEntity)entity).f_20912_ == InteractionHand.OFF_HAND && !rightHanded) {
            this.setupAttackAnimation(entity, ageInTicks, this.right_arm);
        } else {
            this.setupAttackAnimation(entity, ageInTicks, this.left_arm);
        }
        this.right_arm.f_104202_ -= limbSwingAmount * 2.5f;
        this.left_arm.f_104202_ -= limbSwingAmount * 2.5f;
        this.right_arm.f_104201_ += limbSwingAmount * 0.5f;
        this.left_arm.f_104201_ += limbSwingAmount * 0.5f;
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pose) {
        boolean left = pSide == HumanoidArm.LEFT;
        ModelPart arm = left ? this.left_arm : this.right_arm;
        arm.m_104299_(pose);
        pose.m_252880_(0.0f, 0.1f, -0.02f);
        float itemScale = 1.2f;
        pose.m_85841_(itemScale, itemScale, itemScale);
    }

    protected void setupAttackAnimation(T pLivingEntity, float pAgeInTicks, ModelPart modelpart) {
        float f = this.f_102608_;
        this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
        if (modelpart == this.left_arm) {
            this.body.f_104204_ *= -1.0f;
        }
        this.right_arm.f_104202_ = Mth.m_14031_((float)this.body.f_104204_) * 5.0f;
        this.right_arm.f_104200_ = -Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
        this.left_arm.f_104202_ = -Mth.m_14031_((float)this.body.f_104204_) * 5.0f;
        this.left_arm.f_104200_ = Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
        this.right_arm.f_104204_ += this.body.f_104204_;
        this.left_arm.f_104204_ += this.body.f_104204_;
        this.left_arm.f_104203_ += this.body.f_104204_;
        f = 1.0f - this.f_102608_;
        f *= f;
        f *= f;
        f = 1.0f - f;
        float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
        float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        modelpart.f_104203_ -= f1 * 1.2f + f2;
        modelpart.f_104204_ += this.body.f_104204_ * 2.0f;
        modelpart.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }
}

