/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import com.legacy.rediscovered.entity.util.IPigmanDataHolder;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PigmanModel<T extends Mob>
extends HumanoidModel<T> {
    final boolean isProfessionLayer;
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;

    public PigmanModel(ModelPart root) {
        this(root, false);
    }

    public PigmanModel(ModelPart root, boolean isProfessionLayer) {
        super(root);
        this.leftSleeve = root.m_171324_("left_sleeve");
        this.rightSleeve = root.m_171324_("right_sleeve");
        this.leftPants = root.m_171324_("left_pants");
        this.rightPants = root.m_171324_("right_pants");
        this.jacket = root.m_171324_("jacket");
        this.isProfessionLayer = isProfessionLayer;
    }

    public static LayerDefinition createBodyLayer(CubeDeformation headScale) {
        MeshDefinition mesh = PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)false);
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headScale).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headScale.m_171469_(0.5f)).m_171514_(24, 0).m_171488_(-2.0f, -4.0f, -5.0f, 4.0f, 3.0f, 1.0f, headScale), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headScale.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.leftPants, (Object)this.rightPants, (Object)this.leftSleeve, (Object)this.rightSleeve, (Object)this.jacket));
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.f_102816_ = !entity.m_21120_(entity.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).m_41619_() ? HumanoidModel.ArmPose.ITEM : HumanoidModel.ArmPose.EMPTY;
        HumanoidModel.ArmPose armPose = this.f_102815_ = !entity.m_21120_(!entity.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).m_41619_() ? HumanoidModel.ArmPose.ITEM : HumanoidModel.ArmPose.EMPTY;
        if (entity instanceof GuardPigmanEntity) {
            GuardPigmanEntity guard = (GuardPigmanEntity)entity;
            HumanoidModel.ArmPose pose = null;
            if (guard.getArmPose() == GuardPigmanEntity.PigmanArmPose.BOW_AND_ARROW) {
                pose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (pose != null) {
                if (entity.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                } else {
                    this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
    }

    /*
     * Unable to fully structure code
     */
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        if (pEntity instanceof Zombie) {
            zomb = (Zombie)pEntity;
            AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)zomb.m_5912_(), (float)this.f_102608_, (float)pAgeInTicks);
        } else if (pEntity instanceof GuardPigmanEntity) {
            guard = (GuardPigmanEntity)pEntity;
            pose = guard.getArmPose();
            if (pose == GuardPigmanEntity.PigmanArmPose.CROSSBOW_HOLD) {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)(guard.m_21526_() == false));
            } else if (pose == GuardPigmanEntity.PigmanArmPose.CROSSBOW_CHARGE) {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, pEntity, (boolean)(guard.m_21526_() == false));
            }
        }
        if (this.isProfessionLayer || pEntity.m_6095_() != RediscoveredEntityTypes.ZOMBIE_PIGMAN || !(pEntity instanceof IPigmanDataHolder)) ** GOTO lbl-1000
        pigmanData = (IPigmanDataHolder)pEntity;
        if (!pigmanData.getPigmanData().getProfession().renderZombiePigmanLoincloth) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.leftPants.f_233556_ = skipPants = v0;
        this.rightPants.f_233556_ = skipPants;
        this.leftPants.m_104315_(this.f_102814_);
        this.rightPants.m_104315_(this.f_102813_);
        this.leftSleeve.m_104315_(this.f_102812_);
        this.rightSleeve.m_104315_(this.f_102811_);
        this.jacket.m_104315_(this.f_102810_);
        this.jacket.f_104207_ = true;
    }

    /*
     * Unable to fully structure code
     */
    public void setupLevelLayer(T entity) {
        if (!(entity instanceof IPigmanDataHolder)) ** GOTO lbl-1000
        pigmanData = (IPigmanDataHolder)entity;
        if (pigmanData.getPigmanData().getProfession().renderLevelOnJacket) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.f_102810_.f_233556_ = onJacket = v0;
        this.jacket.f_233556_ = onJacket == false;
    }

    public void resetLevelLayer() {
        this.f_102810_.f_233556_ = false;
        this.jacket.f_233556_ = false;
    }
}

