/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.model;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.entity.dragon.DragonPylonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class DragonPylonRenderer<T extends DragonPylonEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation PYLON_TEXTURE = RediscoveredMod.locate("textures/entity/dragon_pylon/core.png");
    private static final ResourceLocation PYLON_BEAM_TEXTURE = RediscoveredMod.locate("textures/entity/dragon_pylon/beam.png");
    public static final RenderType RENDER_TYPE = RediscoveredRenderType.sortedEntityTranslucent(PYLON_TEXTURE);
    public static final Material ENERGY_SHIELD_TEXTURE = new Material(TextureAtlas.f_118259_, RediscoveredMod.locate("entity/dragon_pylon/energy_shield"));
    private static final RenderType BEAM_RENDER_TYPE = RediscoveredRenderType.energy(PYLON_BEAM_TEXTURE);
    public static final float SIN_45 = Mth.m_14031_((float)0.7853982f);
    private final ModelPart cube;

    public DragonPylonRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        ModelPart modelpart = context.m_174023_(RediscoveredRenderRefs.DRAGON_PYLON);
        this.cube = modelpart.m_171324_("cube");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void render(T pylon, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffSource, int packedLight) {
        int overlay = ((DragonPylonEntity)((Object)pylon)).f_20916_ > 0 || pylon.m_21224_() ? 3 : OverlayTexture.f_118083_;
        float y = DragonPylonRenderer.getY(((DragonPylonEntity)((Object)pylon)).time, partialTicks);
        float yRenderOffset = y / 2.0f;
        float rot = ((float)((DragonPylonEntity)((Object)pylon)).time + partialTicks) * 3.0f;
        float scale = 4.0f;
        VertexConsumer solidBuffer = buffSource.m_6299_(RENDER_TYPE);
        pose.m_85836_();
        pose.m_252880_(0.0f, 1.5f + yRenderOffset, 0.0f);
        pose.m_85841_(scale, scale, scale);
        float cubeScale = 0.5f;
        pose.m_85841_(cubeScale, cubeScale, cubeScale);
        pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        pose.m_252781_(Axis.f_252436_.m_252977_(rot));
        pose.m_252781_(Axis.f_252529_.m_252977_(rot * 2.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(rot * 3.0f));
        this.cube.m_104301_(pose, solidBuffer, 0xF000F0, overlay);
        pose.m_85849_();
        RedDragonBossEntity dragon = ((DragonPylonEntity)((Object)pylon)).getAttachedDragon();
        if (dragon != null) {
            BlockPos top = pylon.m_20183_().m_6630_(6);
            boolean atDungeon = pylon.m_9236_().m_8055_(top).m_60713_(RediscoveredBlocks.obsidian_bulb);
            double yOff = atDungeon ? 5 : 0;
            double f3 = Mth.m_14139_((double)partialTicks, (double)dragon.f_19790_, (double)dragon.m_20185_());
            double f4 = Mth.m_14139_((double)partialTicks, (double)dragon.f_19791_, (double)dragon.m_20186_());
            double f5 = Mth.m_14139_((double)partialTicks, (double)dragon.f_19792_, (double)dragon.m_20189_());
            float f6 = (float)(f3 - pylon.m_20185_());
            float f7 = (float)(f4 - (pylon.m_20186_() + yOff));
            float f8 = (float)(f5 - pylon.m_20189_());
            pose.m_85836_();
            pose.m_85837_((double)f6, (double)f7 + yOff, (double)f8);
            DragonPylonRenderer.renderPylonBeam(-f6, -f7 + (atDungeon ? 0.0f : y), -f8, partialTicks, ((DragonPylonEntity)((Object)pylon)).time, pose, buffSource, 0xF000F0, 270.0f, 2.5f, 0.3f, 1.0f);
            pose.m_85849_();
            if (atDungeon) {
                pose.m_85836_();
                f3 = (float)top.m_123341_() + 0.5f;
                f4 = top.m_123342_();
                f5 = (float)top.m_123343_() + 0.5f;
                f6 = (float)(f3 - pylon.m_20185_());
                f7 = (float)(f4 - pylon.m_20186_());
                f8 = (float)(f5 - pylon.m_20189_());
                pose.m_252880_(f6, f7, f8);
                DragonPylonRenderer.renderPylonBeam(-f6, -f7 + yRenderOffset - 0.4f, -f8, partialTicks, ((DragonPylonEntity)((Object)pylon)).time, pose, buffSource, 0xF000F0, 90.0f);
                pose.m_85849_();
            }
        }
        VertexConsumer energyBuffer = ENERGY_SHIELD_TEXTURE.m_119194_(buffSource, RediscoveredRenderType::energy);
        pose.m_85836_();
        pose.m_252880_(0.0f, 1.5f + yRenderOffset, 0.0f);
        pose.m_85841_(scale, scale, scale);
        float glassScale = 1.0f;
        float glassScaleMul = 1.18f;
        int glassLayers = ((DragonPylonEntity)((Object)pylon)).getLayerCount();
        DragonPylonRenderer.renderPylonShields(this.cube, pose, energyBuffer, 0xF000F0, rot, glassScale, glassScaleMul, glassLayers);
        pose.m_85849_();
        super.m_7392_(pylon, entityYaw, partialTicks, pose, buffSource, packedLight);
    }

    public static void renderPylonShields(ModelPart cube, PoseStack poseStack, VertexConsumer buffer, int pPackedLight, float rotation, float scale, float scaleMul, int layers) {
        DragonPylonRenderer.renderPylonShields(cube, poseStack, buffer, pPackedLight, rotation, scale, scaleMul, layers, 1.0f);
    }

    public static void renderPylonShields(ModelPart cube, PoseStack poseStack, VertexConsumer buffer, int pPackedLight, float rotation, float scale, float scaleMul, int layers, float alpha) {
        poseStack.m_85836_();
        for (int i = 0; i < layers; ++i) {
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotation));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation * 0.4f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation * -0.1f));
            cube.m_104306_(poseStack, buffer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            scale *= scaleMul;
        }
        poseStack.m_85849_();
    }

    public static void renderPylonBeam(float x, float y, float z, float partialTick, int tickCount, PoseStack poseStack, MultiBufferSource buffSource, int packedLight, float zRotation) {
        DragonPylonRenderer.renderPylonBeam(x, y, z, partialTick, tickCount, poseStack, buffSource, packedLight, zRotation, 0.2f, 0.8f, 1.0f);
    }

    public static void renderPylonBeam(float x, float y, float z, float partialTick, int tickCount, PoseStack poseStack, MultiBufferSource buffSource, int packedLight, float zRotation, float topWidth, float bottomWidth, float endAlpha) {
        float f = Mth.m_14116_((float)(x * x + z * z));
        float f1 = Mth.m_14116_((float)(x * x + y * y + z * z));
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 2.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(z, x)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(f, y)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252403_.m_252961_(zRotation));
        VertexConsumer buffer = buffSource.m_6299_(BEAM_RENDER_TYPE);
        float speed = 0.03f;
        float motion = ((float)tickCount + partialTick) * speed;
        float f2 = 0.0f + motion;
        float f3 = Mth.m_14116_((float)(x * x + y * y + z * z)) / 32.0f + motion;
        int sides = 6;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        float startColor = 1.0f;
        float startAlpha = 1.0f;
        float endColor = 0.75f;
        for (int j = 1; j <= sides; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / (float)sides)) * 0.75f;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / (float)sides)) * 0.75f;
            float f9 = (float)j / (float)sides;
            buffer.m_252986_(matrix4f, f4 * topWidth, f5 * topWidth, 0.0f).m_85950_(endColor, endColor, endColor, endAlpha).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix4f, f4 * bottomWidth, f5 * bottomWidth, f1).m_85950_(startColor, startColor, startColor, startAlpha).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix4f, f7 * bottomWidth, f8 * bottomWidth, f1).m_85950_(startColor, startColor, startColor, startAlpha).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix4f, f7 * topWidth, f8 * topWidth, 0.0f).m_85950_(endColor, endColor, endColor, endAlpha).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }

    public static float getY(int time, float pPartialTick) {
        float f = (float)time + pPartialTick;
        float f1 = Mth.m_14031_((float)(f * 0.1f)) / 2.0f + 1.7f;
        f1 = (f1 * f1 + f1) * 0.2f;
        return f1 - 1.4f;
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return PYLON_TEXTURE;
    }

    public boolean shouldRender(T pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return super.m_5523_(pLivingEntity, pCamera, pCamX, pCamY, pCamZ) || ((DragonPylonEntity)((Object)pLivingEntity)).getAttachedDragonUUID().isPresent();
    }
}

