/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity.layer;

import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class QuiverArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final HumanoidModel<T> quiverModel;

    public QuiverArmorLayer(RenderLayerParent<T, M> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.quiverModel = new HumanoidModel(context.m_174023_(RediscoveredRenderRefs.QUIVER));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation itemID;
        ItemStack quiverStack;
        Optional<AttachedItem> attachedItem = AttachedItem.get(entity.m_6844_(EquipmentSlot.CHEST));
        if (attachedItem.isPresent() && !(quiverStack = attachedItem.get().getAttached()).m_41619_() && (itemID = (ResourceLocation)quiverStack.m_220173_().m_203543_().map(ResourceKey::m_135782_).orElse(null)) != null) {
            ((HumanoidModel)this.m_117386_()).m_102872_(this.quiverModel);
            this.quiverModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            poseStack.m_85836_();
            poseStack.m_85841_(1.05f, 1.05f, 1.05f);
            Item item = quiverStack.m_41720_();
            if (item instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
                int color = dyeable.m_41121_(quiverStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                this.renderModel(poseStack, buffSource, packedLight, r, g, b, itemID, "");
                this.renderModel(poseStack, buffSource, packedLight, 1.0f, 1.0f, 1.0f, itemID, "_overlay");
            } else {
                this.renderModel(poseStack, buffSource, packedLight, 1.0f, 1.0f, 1.0f, itemID, "");
            }
            poseStack.m_85849_();
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource buffSource, int packedLight, float r, float g, float b, ResourceLocation itemID, String suffix) {
        VertexConsumer vertexConsumer = buffSource.m_6299_(RenderType.m_110431_((ResourceLocation)new ResourceLocation(String.format("%s:textures/models/armor/%s_layer_1%s.png", itemID.m_135827_(), itemID.m_135815_(), suffix))));
        this.quiverModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }
}

