/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity.layer;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.render.model.PigmanModel;
import com.legacy.rediscovered.entity.pigman.data.PigmanData;
import com.legacy.rediscovered.entity.util.IPigmanDataHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PigmanProfessionLayer<T extends Mob, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final EnumMap<PigmanData.Profession, ResourceLocation> professionTextures;
    private final Map<Integer, ResourceLocation> levelTextures;
    private final PigmanModel<T> layerModel;

    public PigmanProfessionLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet, ModelLayerLocation layer, boolean zombie) {
        super(pRenderer);
        this.layerModel = new PigmanModel(pModelSet.m_171103_(layer), true);
        this.professionTextures = (EnumMap)Util.m_137469_(new EnumMap(PigmanData.Profession.class), map -> {
            for (PigmanData.Profession prof : PigmanData.Profession.values()) {
                if (prof == PigmanData.Profession.NONE) continue;
                map.put(prof, this.texture(zombie, "profession/" + prof.profName));
            }
        });
        this.levelTextures = ((Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), map -> {
            map.put(1, (Object)"stone");
            map.put(2, (Object)"iron");
            map.put(3, (Object)"gold");
            map.put(4, (Object)"ruby");
            map.put(5, (Object)"diamond");
        })).int2ObjectEntrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.texture(zombie, "profession_level/" + e.getValue())));
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        PigmanData pigmanData = ((IPigmanDataHolder)entity).getPigmanData();
        PigmanData.Profession prof = pigmanData.getProfession();
        if (prof != PigmanData.Profession.NONE) {
            PigmanProfessionLayer.m_117359_((EntityModel)this.m_117386_(), this.layerModel, (ResourceLocation)this.professionTextures.get((Object)prof), (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, entity, (float)pLimbSwing, (float)pLimbSwingAmount, (float)pAgeInTicks, (float)pNetHeadYaw, (float)pHeadPitch, (float)pPartialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            this.layerModel.setupLevelLayer(entity);
            PigmanProfessionLayer.m_117359_((EntityModel)this.m_117386_(), this.layerModel, (ResourceLocation)this.levelTextures.get(pigmanData.getLevel()), (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, entity, (float)pLimbSwing, (float)pLimbSwingAmount, (float)pAgeInTicks, (float)pNetHeadYaw, (float)pHeadPitch, (float)pPartialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            this.layerModel.resetLevelLayer();
        }
    }

    private ResourceLocation texture(boolean zombie, String texture) {
        return RediscoveredMod.locate("textures/entity/" + (zombie ? "zombie_pigman/" : "pigman/") + texture + ".png");
    }
}

