/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.client.render.RediscoveredRendering;
import com.legacy.rediscovered.entity.dragon.ThunderCloudEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThunderCloudRenderer<T extends ThunderCloudEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation TEXTURE = RediscoveredMod.locate("textures/entity/thunder_cloud/thunder_cloud.png");
    public static final ResourceLocation TEXTURE_MAP = RediscoveredMod.locate("textures/entity/thunder_cloud/thunder_cloud_map.png");
    private final ModelPart cloud;

    public ThunderCloudRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.cloud = pContext.m_174023_(RediscoveredRenderRefs.THUNDER_CLOUD);
    }

    public static RediscoveredRendering.Bolt createBolt(float length, boolean centered) {
        RediscoveredRendering.Bolt bolt = RediscoveredRendering.bolt().layers(2).bolts(1).startScale(centered ? 0.3f : 0.2f).endScale(centered ? 0.1f : 0.05f).centerSpacing(0.0f).length(length).turns(5, 7).rotationDegrees((FloatProvider)ConstantFloat.f_146451_, (FloatProvider)UniformFloat.m_146605_((float)0.0f, (float)360.0f), (FloatProvider)ConstantFloat.m_146458_((float)180.0f)).color((FloatProvider)UniformFloat.m_146605_((float)0.2f, (float)0.6f), (FloatProvider)UniformFloat.m_146605_((float)0.65f, (float)0.85f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)0.3f));
        if (centered) {
            bolt.limitedChaos().recenterAtTip();
        }
        return bolt;
    }

    protected int getBlockLightLevel(T pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffSource, int packedLight) {
        float boltLength = ((ThunderCloudEntity)((Object)entity)).getStrikeDistance();
        if (boltLength != 0.0f && ((ThunderCloudEntity)((Object)entity)).getStrikeTime() > 0) {
            int boltSeed = (((ThunderCloudEntity)((Object)entity)).f_19797_ + entity.m_20148_().hashCode()) / 2 * 10;
            ThunderCloudRenderer.createBolt(boltLength / 3.0f, false).render(pose, buffSource, (long)(boltSeed * 10));
            ThunderCloudRenderer.createBolt(boltLength / 2.0f, false).render(pose, buffSource, (long)(boltSeed * 30));
            ThunderCloudRenderer.createBolt(boltLength, true).render(pose, buffSource, (long)boltSeed);
        }
        float ageInTicks = (float)((ThunderCloudEntity)((Object)entity)).f_19797_ + partialTicks;
        pose.m_85836_();
        float enterScale = 0.0f + Math.min(1.0f, ageInTicks * 0.03f);
        pose.m_85841_(enterScale, enterScale, enterScale);
        for (int c = 0; c < ((ThunderCloudEntity)((Object)entity)).renderOffsets.size(); ++c) {
            Vec3 offset = ((ThunderCloudEntity)((Object)entity)).renderOffsets.get(c);
            int seed = Math.abs(offset.hashCode());
            float offsetScale = 1.0f * Math.min(1.0f, ageInTicks * 0.02f);
            pose.m_85836_();
            pose.m_85837_(offset.f_82479_ * (double)offsetScale, ((double)(entity.m_20206_() / 2.0f) + offset.f_82480_) * (double)offsetScale, offset.f_82481_ * (double)offsetScale);
            float s = 1.0f + (float)(seed % 4) * 0.3f;
            float speed = ageInTicks * (0.2f + (float)(seed % 8) * 0.02f);
            float speedSeed = seed % 10;
            float distance = 0.2f;
            pose.m_85837_(Math.sin(speed - speedSeed) * (double)distance, Math.sin(speed + speedSeed) * (double)distance, Math.cos(speed - speedSeed) * (double)distance);
            pose.m_85841_(1.0f + (float)Math.sin(speed / 2.0f - speedSeed) * distance, 1.0f + (float)Math.sin(speed / 2.0f + speedSeed) * distance, 1.0f + (float)Math.cos(speed / 2.0f - speedSeed) * distance);
            pose.m_85841_(s, s, s);
            float a = 0.5f;
            this.cloud.m_104306_(pose, buffSource.m_6299_(RediscoveredRenderType.sortedEntityTranslucentCull(TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, a);
            pose.m_85849_();
        }
        pose.m_85836_();
        float scale = 3.0f;
        float xz = Mth.m_14089_((float)(0.0f + ageInTicks * 0.2f)) * 0.1f;
        float y = Mth.m_14031_((float)(0.0f + ageInTicks * 0.2f)) * 0.1f;
        float base = 1.0f;
        pose.m_85841_(base + xz, base + y, base + xz);
        pose.m_85841_(scale, scale, scale);
        float alpha = 0.5f;
        this.cloud.m_104306_(pose, buffSource.m_6299_(RediscoveredRenderType.sortedEntityTranslucentCull(TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        pose.m_85849_();
        pose.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, pose, buffSource, packedLight);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TEXTURE;
    }
}

