/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.model.RedDragonModel;
import com.legacy.rediscovered.entity.dragon.AbstractRedDragonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.item.util.DragonArmorTrim;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RedDragonOffspringRenderer<T extends RedDragonOffspringEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = RediscoveredMod.locate("textures/entity/red_dragon/red_dragon.png");
    private static final ResourceLocation EYES = RediscoveredMod.locate("textures/entity/red_dragon/red_dragon_eyes.png");
    private static final RenderType TEXTURE_CUTOUT = RenderType.m_110458_((ResourceLocation)TEXTURE);
    private static final RenderType EMISSIVE_EYES = RenderType.m_110488_((ResourceLocation)EYES);
    private static final ResourceLocation SADDLE = RediscoveredMod.locate("entity/red_dragon/saddle");
    private static final ResourceLocation ARMOR_STRAPS = RediscoveredMod.locate("entity/red_dragon/armor/straps");
    private static final ResourceLocation DEFAULT_ARMOR_CHAIN = RediscoveredMod.locate("entity/red_dragon/armor/default_" + DragonArmorTrim.Decoration.CHAIN.m_7912_());
    private static final ResourceLocation DEFAULT_ARMOR_PLATING = RediscoveredMod.locate("entity/red_dragon/armor/default_" + DragonArmorTrim.Decoration.PLATING.m_7912_());
    private static final ResourceLocation DEFAULT_ARMOR_INLAY = RediscoveredMod.locate("entity/red_dragon/armor/default_" + DragonArmorTrim.Decoration.INLAY.m_7912_());
    private final RedDragonModel<T> model;
    private final RedDragonModel<T> armorModel;
    private final RedDragonModel<T> saddleModel;
    private final TextureAtlas armorTrimAtlas;

    public RedDragonOffspringRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RedDragonModel(context.m_174023_(RediscoveredRenderRefs.RED_DRAGON));
        this.armorModel = new RedDragonModel(context.m_174023_(RediscoveredRenderRefs.RED_DRAGON_ARMOR));
        this.saddleModel = new RedDragonModel(context.m_174023_(RediscoveredRenderRefs.RED_DRAGON_SADDLE));
        this.armorTrimAtlas = context.m_266367_().m_119428_(Sheets.f_265912_);
    }

    public boolean shouldRender(T pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (super.m_5523_(pLivingEntity, pCamera, pCamX, pCamY, pCamZ)) {
            return true;
        }
        Entity entity = pLivingEntity.m_21524_();
        return entity != null ? pCamera.m_113029_(entity.m_6921_()) : false;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffSource, int packedLight) {
        boolean shouldSit = false;
        float walkSpeed = 0.0f;
        float walkPosition = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            walkSpeed = ((RedDragonOffspringEntity)entity).f_267362_.m_267711_(partialTicks);
            walkPosition = ((RedDragonOffspringEntity)entity).f_267362_.m_267590_(partialTicks);
            if (entity.m_6162_()) {
                walkPosition *= 3.0f;
            }
            if (walkSpeed > 1.0f) {
                walkSpeed = 1.0f;
            }
        }
        float fly = ((RedDragonOffspringEntity)entity).flyingAnim.getValue(partialTicks);
        float flyInv = 1.0f - fly;
        float hover = ((RedDragonOffspringEntity)entity).hoverAnim.getValue(partialTicks) * fly;
        float hoverInv = 1.0f - hover;
        pose.m_85836_();
        float ageScale = entity.m_6162_() ? 0.4f : 1.0f;
        pose.m_85841_(ageScale, ageScale, ageScale);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85836_();
        float f = (float)Mth.m_14175_((double)((AbstractRedDragonEntity)((Object)entity)).getLatencyPos(7, partialTicks)[0]);
        float f1 = (float)(((AbstractRedDragonEntity)((Object)entity)).getLatencyPos(5, partialTicks)[1] - ((AbstractRedDragonEntity)((Object)entity)).getLatencyPos(10, partialTicks)[1]);
        float bodyRot = Mth.m_14177_((float)Mth.m_14189_((float)partialTicks, (float)((RedDragonOffspringEntity)entity).f_20884_, (float)((RedDragonOffspringEntity)entity).f_20883_));
        pose.m_252781_(Axis.f_252436_.m_252977_(-bodyRot * flyInv + -f * fly));
        pose.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14036_((float)(f1 * 10.0f * fly * hoverInv), (float)-90.0f, (float)90.0f)));
        pose.m_85837_(0.0, 0.0, 1.0);
        pose.m_85841_(-1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.0, (double)-1.501f, 0.0);
        boolean isHurt = ((RedDragonOffspringEntity)entity).f_20916_ > 0;
        this.model.prepareMobModel(entity, walkPosition, walkSpeed, partialTicks);
        this.armorModel.prepareMobModel(entity, walkPosition, walkSpeed, partialTicks);
        this.saddleModel.prepareMobModel(entity, walkPosition, walkSpeed, partialTicks);
        VertexConsumer modelBuffer = buffSource.m_6299_(TEXTURE_CUTOUT);
        this.model.m_7695_(pose, modelBuffer, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)isHurt), 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer eyeBuffer = buffSource.m_6299_(EMISSIVE_EYES);
        this.model.m_7695_(pose, eyeBuffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ItemStack armor = ((RedDragonOffspringEntity)entity).getArmor();
        if (armor.m_150930_(RediscoveredItems.dragon_armor)) {
            DragonArmorTrim trim = DragonArmorTrim.getTrim(Minecraft.m_91087_().f_91073_.m_9598_(), armor).orElse(DragonArmorTrim.EMPTY);
            this.armorModel.m_7695_(pose, this.armorTrimAtlas.m_118316_(ARMOR_STRAPS).m_118381_(buffSource.m_6299_(Sheets.m_266442_())), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.renderArmor(DragonArmorTrim.Decoration.CHAIN, trim.chain(), DEFAULT_ARMOR_CHAIN, pose, buffSource, packedLight, isHurt);
            this.renderArmor(DragonArmorTrim.Decoration.PLATING, trim.plating(), DEFAULT_ARMOR_PLATING, pose, buffSource, packedLight, isHurt);
            this.renderArmor(DragonArmorTrim.Decoration.INLAY, trim.inlay(), DEFAULT_ARMOR_INLAY, pose, buffSource, packedLight, isHurt);
        }
        if (((RedDragonOffspringEntity)entity).m_6254_()) {
            this.saddleModel.m_7695_(pose, this.armorTrimAtlas.m_118316_(SADDLE).m_118381_(buffSource.m_6299_(Sheets.m_266442_())), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        pose.m_252781_(Axis.f_252392_.m_252977_(180.0f));
        pose.m_85849_();
        pose.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, pose, buffSource, packedLight);
        Entity leashHolder = entity.m_21524_();
        if (leashHolder != null) {
            this.renderLeash(entity, partialTicks, pose, buffSource, leashHolder);
        }
    }

    private void renderArmor(DragonArmorTrim.Decoration layer, Optional<Holder<TrimMaterial>> material, ResourceLocation defaultTexture, PoseStack pose, MultiBufferSource buffSource, int packedLight, boolean flag) {
        int light = packedLight;
        if (material.isPresent()) {
            int customBlockLight;
            Optional key = material.get().m_203543_();
            int n = customBlockLight = key.isPresent() ? ClientUtil.materialLight.getOrDefault(key.get(), -1) : -1;
            if (customBlockLight > -1) {
                light = LightTexture.m_109885_((int)Math.max(customBlockLight, LightTexture.m_109883_((int)packedLight)), (int)LightTexture.m_109894_((int)packedLight));
            }
        }
        ResourceLocation texture = material.isPresent() ? RediscoveredMod.locate("entity/red_dragon/armor/" + layer.m_7912_() + "_" + ((TrimMaterial)material.get().get()).f_265854_()) : defaultTexture;
        TextureAtlasSprite sprite = this.armorTrimAtlas.m_118316_(texture);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (sprite.m_245424_().m_246162_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
            sprite = this.armorTrimAtlas.m_118316_(RediscoveredMod.locate("entity/red_dragon/armor/" + layer.m_7912_()));
            if (material.isPresent()) {
                int color = ((TrimMaterial)material.get().get()).f_266021_().m_7383_().m_131135_().m_131265_();
                r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
                g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
                b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            }
        }
        VertexConsumer buff = sprite.m_118381_(buffSource.m_6299_(Sheets.m_266442_()));
        this.armorModel.m_7695_(pose, buff, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }

    protected boolean shouldShowName(T dragon) {
        return (dragon.m_6052_() || dragon.m_8077_() && dragon == this.f_114476_.f_114359_) && !dragon.m_20197_().contains(Minecraft.m_91087_().f_91074_);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }

    private <E extends Entity> void renderLeash(T pEntityLiving, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, E pLeashHolder) {
        pPoseStack.m_85836_();
        Vec3 vec3 = pLeashHolder.m_7398_(pPartialTicks);
        double d0 = (double)(Mth.m_14179_((float)pPartialTicks, (float)((RedDragonOffspringEntity)pEntityLiving).f_20884_, (float)((RedDragonOffspringEntity)pEntityLiving).f_20883_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = pEntityLiving.m_245894_(pPartialTicks);
        double d1 = Math.cos(d0) * vec31.f_82481_ + Math.sin(d0) * vec31.f_82479_;
        double d2 = Math.sin(d0) * vec31.f_82481_ - Math.cos(d0) * vec31.f_82479_;
        double d3 = Mth.m_14139_((double)pPartialTicks, (double)((RedDragonOffspringEntity)pEntityLiving).f_19854_, (double)pEntityLiving.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)pPartialTicks, (double)((RedDragonOffspringEntity)pEntityLiving).f_19855_, (double)pEntityLiving.m_20186_()) + vec31.f_82480_;
        double d5 = Mth.m_14139_((double)pPartialTicks, (double)((RedDragonOffspringEntity)pEntityLiving).f_19856_, (double)pEntityLiving.m_20189_()) + d2;
        pPoseStack.m_85837_(d1, vec31.f_82480_, d2);
        float f = (float)(vec3.f_82479_ - d3);
        float f1 = (float)(vec3.f_82480_ - d4);
        float f2 = (float)(vec3.f_82481_ - d5);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = BlockPos.m_274446_((Position)pEntityLiving.m_20299_(pPartialTicks));
        BlockPos blockpos1 = BlockPos.m_274446_((Position)pLeashHolder.m_20299_(pPartialTicks));
        int i = this.m_6086_((Entity)pEntityLiving, blockpos);
        int j = LightTexture.m_109883_((int)this.f_114476_.m_114382_(pLeashHolder).m_114505_(pLeashHolder, pPartialTicks));
        int k = pEntityLiving.m_9236_().m_45517_(LightLayer.SKY, blockpos);
        int l = pEntityLiving.m_9236_().m_45517_(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 24; ++i1) {
            MobRenderer.m_174307_((VertexConsumer)vertexconsumer, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.025f, (float)f5, (float)f6, (int)i1, (boolean)false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            MobRenderer.m_174307_((VertexConsumer)vertexconsumer, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.0f, (float)f5, (float)f6, (int)j1, (boolean)true);
        }
        pPoseStack.m_85849_();
    }
}

