/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.client.render.RediscoveredRendering;
import com.legacy.rediscovered.client.render.entity.BoltBallRenderer;
import com.legacy.rediscovered.client.render.model.DragonPylonRenderer;
import com.legacy.rediscovered.client.render.model.RedDragonModel;
import com.legacy.rediscovered.entity.dragon.AbstractRedDragonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RedDragonBossRenderer<T extends RedDragonBossEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation DRAGON_TEXTURES = RediscoveredMod.locate("textures/entity/red_dragon/red_dragon.png");
    private static final ResourceLocation DRAGON_EXPLODING_TEXTURES = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation EYES = RediscoveredMod.locate("textures/entity/red_dragon/red_dragon_eyes.png");
    private static final ResourceLocation GLOW_1 = RediscoveredMod.locate("textures/entity/red_dragon/red_dragon_glow_1.png");
    private static final ResourceLocation GLOW_2 = RediscoveredMod.locate("textures/entity/red_dragon/red_dragon_glow_2.png");
    private static final RenderType TEXTURE_CUTOUT = RenderType.m_110458_((ResourceLocation)DRAGON_TEXTURES);
    private static final RenderType TEXTURE_DECAL = RenderType.m_110479_((ResourceLocation)DRAGON_TEXTURES);
    private static final RenderType EMISSIVE_EYES = RenderType.m_110488_((ResourceLocation)EYES);
    private static final RenderType EMISSIVE_GLOW_1 = RenderType.m_110488_((ResourceLocation)GLOW_1);
    private static final RenderType EMISSIVE_GLOW_2 = RenderType.m_110488_((ResourceLocation)GLOW_2);
    private final RedDragonModel<T> model;
    private final ModelPart shieldPart;
    private RediscoveredRendering.Bolt bolt = RedDragonBossRenderer.createPassiveBolt();
    private RediscoveredRendering.Bolt chargeBolt = BoltBallRenderer.createBolt();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public RedDragonBossRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RedDragonModel(context.m_174023_(RediscoveredRenderRefs.RED_DRAGON));
        this.shieldPart = context.m_174023_(RediscoveredRenderRefs.DRAGON_PYLON).m_171324_("cube");
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffSource, int packedLight) {
        float boltCharge = ((RedDragonBossEntity)entity).boltChargeAnim.getValue(partialTicks);
        float boltShoot = ((RedDragonBossEntity)entity).boltShootAnim.getValue(partialTicks);
        float windBlow = ((RedDragonBossEntity)entity).windBlowAnim.getValue(partialTicks);
        float cloudPrep = ((RedDragonBossEntity)entity).cloudPrepAnim.getValue(partialTicks);
        if (((RedDragonBossEntity)entity).getPylonTime() <= 0 && ((RedDragonBossEntity)entity).passiveBoltSeed > 0L) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 2.5f, 0.0f);
            this.bolt.render(pose, buffSource, ((RedDragonBossEntity)entity).passiveBoltSeed);
            pose.m_85849_();
        }
        pose.m_85836_();
        float f = (float)((AbstractRedDragonEntity)((Object)entity)).getLatencyPos(7, partialTicks)[0];
        float f1 = (float)(((AbstractRedDragonEntity)((Object)entity)).getLatencyPos(5, partialTicks)[1] - ((AbstractRedDragonEntity)((Object)entity)).getLatencyPos(10, partialTicks)[1]);
        f1 += boltCharge * 3.0f;
        f1 += windBlow * 7.0f;
        f1 += cloudPrep * 4.0f;
        if (boltCharge > 0.0f && ((RedDragonBossEntity)entity).boltChargeAnim.isPlaying()) {
            float boltScale = boltCharge - boltShoot;
            pose.m_85836_();
            pose.m_252781_(Axis.f_252436_.m_252977_(-f));
            float ua = 3.7f;
            float upward = ua * boltCharge - ua * boltShoot;
            float ba = 2.2f;
            float backward = ba * boltCharge - ba * boltShoot;
            pose.m_252880_(0.0f, 2.1f + upward, 7.7f - backward * 1.7f);
            pose.m_85841_(boltScale, boltScale, boltScale);
            this.chargeBolt.render(pose, buffSource, ((RedDragonBossEntity)entity).chargeBoltSeed);
            pose.m_85849_();
        }
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(-f));
        pose.m_252781_(Axis.f_252529_.m_252977_(f1 * 10.0f));
        pose.m_85837_(0.0, 0.0, 1.0);
        pose.m_85841_(-1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.0, (double)-1.501f, 0.0);
        boolean flag = ((RedDragonBossEntity)entity).f_20916_ > 0;
        this.model.prepareMobModel(entity, 0.0f, 0.0f, partialTicks);
        VertexConsumer ivertexbuilder3 = buffSource.m_6299_(TEXTURE_CUTOUT);
        this.model.m_7695_(pose, ivertexbuilder3, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer eyeBuffer = buffSource.m_6299_(EMISSIVE_EYES);
        this.model.m_7695_(pose, eyeBuffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        float glow1 = ((float)Math.sin((double)((float)((RedDragonBossEntity)entity).f_19797_ + partialTicks) / 1.5) + 1.0f) / 2.0f;
        float glowAlpha = Mth.m_14036_((float)(boltCharge + boltShoot + windBlow + cloudPrep), (float)0.0f, (float)1.0f);
        float ga1 = glowAlpha * glow1;
        float ga2 = glowAlpha * (1.0f - glow1);
        VertexConsumer glowBuffer = buffSource.m_6299_(EMISSIVE_GLOW_2);
        this.model.m_7695_(pose, glowBuffer, packedLight, OverlayTexture.f_118083_, ga1, ga1, ga1, ga1);
        glowBuffer = buffSource.m_6299_(EMISSIVE_GLOW_1);
        this.model.m_7695_(pose, glowBuffer, packedLight, OverlayTexture.f_118083_, ga2, ga2, ga2, ga2);
        this.model.scaleSize = 1.0f + glowAlpha;
        this.model.m_7695_(pose, glowBuffer, packedLight, OverlayTexture.f_118083_, glowAlpha *= 0.8f, glowAlpha, glowAlpha, glowAlpha);
        this.model.scaleSize = -1.0f;
        if (((RedDragonBossEntity)entity).dragonDeathTicks > 0) {
            float f5 = ((float)((RedDragonBossEntity)entity).dragonDeathTicks + partialTicks) / 200.0f;
            float f7 = 0.0f;
            if (f5 > 0.8f) {
                f7 = (f5 - 0.8f) / 0.2f;
            }
            Random random = new Random(773L);
            VertexConsumer ivertexbuilder2 = buffSource.m_6299_(RenderType.m_110502_());
            pose.m_85836_();
            pose.m_85837_(0.0, -1.0, -2.0);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                pose.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                pose.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                pose.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
                pose.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                pose.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                pose.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = pose.m_85850_().m_252922_();
                int j = (int)(255.0f * (1.0f - f7));
                RedDragonBossRenderer.defaultVertex(ivertexbuilder2, matrix4f, j);
                RedDragonBossRenderer.vertex2(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonBossRenderer.vertex3(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonBossRenderer.defaultVertex(ivertexbuilder2, matrix4f, j);
                RedDragonBossRenderer.vertex3(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonBossRenderer.vertex4(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonBossRenderer.defaultVertex(ivertexbuilder2, matrix4f, j);
                RedDragonBossRenderer.vertex4(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonBossRenderer.vertex2(ivertexbuilder2, matrix4f, f3, f4);
                ++i;
            }
            pose.m_85849_();
        }
        pose.m_85849_();
        if (((RedDragonBossEntity)entity).getPylonTime() > 0) {
            VertexConsumer pylonCons = DragonPylonRenderer.ENERGY_SHIELD_TEXTURE.m_119194_(buffSource, RediscoveredRenderType::energy);
            pose.m_85836_();
            float rot = ((float)((RedDragonBossEntity)entity).f_19797_ + partialTicks) * 4.0f;
            float glassScale = 20.0f;
            pose.m_252880_(0.0f, 2.0f, 0.0f);
            pose.m_85841_(glassScale, glassScale, glassScale);
            DragonPylonRenderer.renderPylonShields(this.shieldPart, pose, pylonCons, 0xF000F0, rot, 1.0f, 1.2f, 2);
            pose.m_85849_();
        }
        super.m_7392_(entity, entityYaw, partialTicks, pose, buffSource, packedLight);
    }

    private static void defaultVertex(VertexConsumer vertexBuilder, Matrix4f matrix, int p_229061_2_) {
        vertexBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_229061_2_).m_5752_();
        vertexBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_229061_2_).m_5752_();
    }

    private static void vertex2(VertexConsumer vertexBuilder, Matrix4f matrix, float p_229060_2_, float p_229060_3_) {
        vertexBuilder.m_252986_(matrix, -HALF_SQRT_3 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).m_6122_(0, 255, 255, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer vertexBuilder, Matrix4f matrix, float p_229062_2_, float p_229062_3_) {
        vertexBuilder.m_252986_(matrix, HALF_SQRT_3 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).m_6122_(0, 255, 255, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer vertexBuilder, Matrix4f matrix, float p_229063_2_, float p_229063_3_) {
        vertexBuilder.m_252986_(matrix, 0.0f, p_229063_2_, 1.0f * p_229063_3_).m_6122_(0, 255, 255, 0).m_5752_();
    }

    public static RediscoveredRendering.Bolt createPassiveBolt() {
        return RediscoveredRendering.bolt().layers(3).bolts(3).startScale(0.08f).endScale(0.02f).centerSpacing(2.0f).length(4.0f, 7.0f).turns(3, 5).color((FloatProvider)UniformFloat.m_146605_((float)0.2f, (float)0.6f), (FloatProvider)UniformFloat.m_146605_((float)0.65f, (float)0.85f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)0.3f));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return DRAGON_TEXTURES;
    }

    public static float easeInOutExpo(float x) {
        return (float)(x == 0.0f ? 0.0 : (x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0)));
    }
}

