/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.client.render.model.DragonPylonRenderer;
import com.legacy.rediscovered.entity.dragon.PylonBurstEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PylonBurstRenderer<T extends PylonBurstEntity>
extends EntityRenderer<T> {
    private final ModelPart shieldPart;

    public PylonBurstRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shieldPart = context.m_174023_(RediscoveredRenderRefs.DRAGON_PYLON).m_171324_("cube");
    }

    protected int getBlockLightLevel(T pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(T entity, float pEntityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffSource, int packedLight) {
        VertexConsumer pylonCons = DragonPylonRenderer.ENERGY_SHIELD_TEXTURE.m_119194_(buffSource, RediscoveredRenderType::energy);
        pose.m_85836_();
        int hash = Math.abs(entity.m_20148_().hashCode());
        float rot = ((float)((PylonBurstEntity)((Object)entity)).f_19797_ + (float)(hash % 360) + partialTicks) * 15.0f;
        float rotSpeed = 1.0f / (float)(hash % 2 + 1);
        float glassScale = 3.0f;
        pose.m_252880_(0.0f, 2.0f, 0.0f);
        pose.m_85841_(glassScale, glassScale, glassScale);
        DragonPylonRenderer.renderPylonShields(this.shieldPart, pose, pylonCons, 0xF000F0, rot * rotSpeed, 1.0f, 1.07f, 4);
        pose.m_85849_();
        super.m_7392_(entity, pEntityYaw, partialTicks, pose, buffSource, packedLight);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TextureAtlas.f_118259_;
    }
}

