/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.client.render.IMD3Render;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;

public abstract class MD3EntityRenderer<T extends LivingEntity>
extends EntityRenderer<T>
implements IMD3Render {
    public MD3EntityRenderer(EntityRendererProvider.Context renderer) {
        super(renderer);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.getMD3Texture();
    }

    public void render(T entityIn, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLightIn) {
        Vec3 vec3d = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double camX = vec3d.m_7096_();
        double camY = vec3d.m_7098_();
        double camZ = vec3d.m_7094_();
        double d0 = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entityIn).f_19790_, (double)entityIn.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entityIn).f_19791_, (double)entityIn.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entityIn).f_19792_, (double)entityIn.m_20189_());
        this.render((Entity)entityIn, yaw, partialTicks, matrix, buffer, packedLightIn, d0 - camX, d1 - camY, d2 - camZ);
    }

    @Override
    public <E extends Entity> void render(E entityIn, float rotationYawIn, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLightIn, double xIn, double yIn, double zIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity steve = (LivingEntity)entityIn;
        Minecraft mc = Minecraft.m_91087_();
        Camera renderInfo = mc.f_91063_.m_109153_();
        GL11.glPushMatrix();
        double camX = renderInfo.m_90583_().m_7096_();
        double camY = renderInfo.m_90583_().m_7098_();
        double camZ = renderInfo.m_90583_().m_7094_();
        double entityX = entityIn.m_20185_();
        double entityY = entityIn.m_20186_();
        double entityZ = entityIn.m_20189_();
        GL11.glRotated((double)renderInfo.m_90589_(), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)renderInfo.m_90590_(), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(camX - entityX), (double)(-(camY - entityY)), (double)(camZ - entityZ));
        float f5 = steve.f_20884_ + (steve.f_20883_ - steve.f_20884_) * partialTicks;
        mc.f_90987_.m_174784_(this.getMD3Texture());
        if (steve.f_20919_ > 0) {
            float f = ((float)steve.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GL11.glRotatef((float)(f * 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)(-f5), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)0.02f, (float)-0.02f, (float)0.02f);
        float rotation = (float)steve.f_19797_ + partialTicks * this.getSpeedMultiplier();
        try {
            GlStateManager._enableBlend();
            GlStateManager._enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager._depthMask((!entityIn.m_20145_() ? 1 : 0) != 0);
            int frame1 = (int)rotation % this.getMD3Renderer().getAnimFrames();
            int frame2 = (frame1 + 1) % this.getMD3Renderer().getAnimFrames();
            GlStateManager._depthMask((boolean)true);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)2977);
            if (steve.f_20916_ > 0 || steve.f_20919_ > 0) {
                GL11.glColor3d((double)1.0, (double)0.5, (double)0.5);
            }
            this.getMD3Renderer().render(frame1, frame2, rotation - (float)((int)rotation));
            GL11.glDisable((int)2977);
            GlStateManager._depthMask((boolean)true);
            GlStateManager._disableBlend();
            GlStateManager._disableDepthTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPopMatrix();
    }
}

