/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.client.render.RediscoveredRendering;
import com.legacy.rediscovered.entity.dragon.BoltBallEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoltBallRenderer<T extends BoltBallEntity>
extends EntityRenderer<T> {
    public static final Material WIND_TEXTURE = new Material(TextureAtlas.f_118259_, RediscoveredMod.locate("entity/bolt_ball/wind"));
    private final ModelPart wind;
    private final RediscoveredRendering.Bolt bolt = BoltBallRenderer.createBolt();

    public BoltBallRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.wind = pContext.m_174023_(RediscoveredRenderRefs.BOLT_BALL_WIND);
    }

    public static RediscoveredRendering.Bolt createBolt() {
        return RediscoveredRendering.bolt().layers(2).bolts(10).startScale(0.06f).endScale(0.001f).centerSpacing(0.0f).length(1.0f, 1.5f).turns(3, 5).color((FloatProvider)UniformFloat.m_146605_((float)0.2f, (float)0.6f), (FloatProvider)UniformFloat.m_146605_((float)0.65f, (float)0.85f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)0.3f));
    }

    protected int getBlockLightLevel(T pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffSource, int packedLight) {
        float t = (float)((BoltBallEntity)((Object)entity)).f_19797_ + partialTicks;
        float centerY = entity.m_20206_() / 2.0f;
        pose.m_85836_();
        pose.m_252880_(0.0f, centerY, 0.0f);
        this.bolt.render(pose, buffSource, ((BoltBallEntity)((Object)entity)).getSeed());
        pose.m_85849_();
        float windScale = 2.0f;
        float wobbleSpeed = 0.5f;
        float wobbleScale = 0.3f;
        float windSpeed = 23.0f;
        float windAlpha = 0.6f;
        pose.m_85836_();
        pose.m_252880_(0.0f, centerY, 0.0f);
        pose.m_85841_(windScale + (float)Math.sin(t * wobbleSpeed) * wobbleScale, windScale, windScale + (float)Math.cos(t * wobbleSpeed) * wobbleScale);
        VertexConsumer vertexconsumer = WIND_TEXTURE.m_119194_(buffSource, RediscoveredRenderType::sortedEntityTranslucent);
        pose.m_252781_(Axis.f_252403_.m_252977_((float)Math.sin(t) * 5.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(t * windSpeed));
        this.wind.m_104306_(pose, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, windAlpha);
        pose.m_85849_();
        windScale = 1.3f;
        float offset = 0.7f;
        pose.m_85836_();
        pose.m_252880_(0.0f, centerY + offset, 0.0f);
        pose.m_85841_(windScale + (float)Math.sin(t * wobbleSpeed) * wobbleScale, windScale, windScale + (float)Math.cos(t * wobbleSpeed) * wobbleScale);
        pose.m_252781_(Axis.f_252403_.m_252977_((float)Math.cos(t) * 5.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(t * -windSpeed * 1.3f));
        pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        this.wind.m_104306_(pose, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, windAlpha);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(0.0f, centerY - offset, 0.0f);
        pose.m_85841_(windScale + (float)Math.sin(t * wobbleSpeed) * wobbleScale, windScale, windScale + (float)Math.cos(t * wobbleSpeed) * wobbleScale);
        pose.m_252781_(Axis.f_252403_.m_252977_((float)Math.cos(t) * 5.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(t * -windSpeed * 1.2f));
        pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        this.wind.m_104306_(pose, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, windAlpha);
        pose.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, pose, buffSource, packedLight);
    }

    public static LayerDefinition createWindLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("wind", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TextureAtlas.f_118259_;
    }
}

