/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.block_entity;

import com.legacy.rediscovered.block.TableBlock;
import com.legacy.rediscovered.block_entities.TableBlockEntity;
import com.legacy.rediscovered.event.api.RenderTableItemEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix4f;

public class TableRenderer
implements BlockEntityRenderer<TableBlockEntity> {
    private static final RenderType MAP_BACKGROUND_RENDERTYPE = RenderType.m_110497_((ResourceLocation)new ResourceLocation("textures/map/map_background_checkerboard.png"));
    private final ItemRenderer itemRenderer;

    public TableRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(TableBlockEntity table, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Direction facing;
        ItemStack stack = table.getItem();
        if (!stack.m_41619_()) {
            BlockPos pos = table.m_58899_();
            facing = table.getFacing();
            float r = -facing.m_122435_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            poseStack.m_85836_();
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderTableItemEvent(table, partialTick, poseStack, buffer, packedLight, packedOverlay, stack))) {
                if (stack.m_150930_(Items.f_42573_)) {
                    boolean increasedScale = false;
                    float xOffset = 0.0f;
                    float zOffset = 0.0f;
                    if (!table.getShape().isSingle()) {
                        BlockState state = table.m_58900_();
                        float mapOffset = 0.171875f;
                        if (((Boolean)state.m_61143_((Property)TableBlock.NORTH)).booleanValue()) {
                            zOffset -= mapOffset;
                        }
                        if (((Boolean)state.m_61143_((Property)TableBlock.SOUTH)).booleanValue()) {
                            zOffset += mapOffset;
                        }
                        if (((Boolean)state.m_61143_((Property)TableBlock.WEST)).booleanValue()) {
                            xOffset -= mapOffset;
                        }
                        if (((Boolean)state.m_61143_((Property)TableBlock.EAST)).booleanValue()) {
                            xOffset += mapOffset;
                        }
                        increasedScale = table.getShape().growItem();
                    }
                    float tableScale = (increasedScale ? 13.25f : 10.5f) / 16.0f;
                    poseStack.m_252880_(0.5f + xOffset, 0.7f, 0.5f + zOffset);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(r + 180.0f));
                    poseStack.m_252880_(-0.5f * tableScale, 0.0f, -0.5f * tableScale);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    float scale = 0.0078125f * tableScale;
                    poseStack.m_85841_(scale, scale, scale);
                    VertexConsumer backgroundConsumer = buffer.m_6299_(MAP_BACKGROUND_RENDERTYPE);
                    Matrix4f projMatrix = poseStack.m_85850_().m_252922_();
                    boolean xEven = pos.m_123341_() % 2 == 0;
                    boolean zEven = pos.m_123343_() % 2 == 0;
                    float backgroundOffset = 0.5f;
                    if (xEven && zEven) {
                        backgroundOffset += 0.1f;
                    } else if (!xEven && !zEven) {
                        backgroundOffset -= 0.1f;
                    } else if (xEven && !zEven) {
                        backgroundOffset += 0.05f;
                    } else if (!xEven && zEven) {
                        backgroundOffset -= 0.05f;
                    }
                    backgroundConsumer.m_252986_(projMatrix, -7.0f, 135.0f, backgroundOffset).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
                    backgroundConsumer.m_252986_(projMatrix, 135.0f, 135.0f, backgroundOffset).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
                    backgroundConsumer.m_252986_(projMatrix, 135.0f, -7.0f, backgroundOffset).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
                    backgroundConsumer.m_252986_(projMatrix, -7.0f, -7.0f, backgroundOffset).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
                    MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)level);
                    Integer mapID = MapItem.m_151131_((ItemStack)stack);
                    if (mapData != null && mapID != null) {
                        Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(poseStack, buffer, mapID.intValue(), mapData, true, packedLight);
                    }
                } else {
                    int seed = (int)pos.m_121878_();
                    BakedModel model = this.itemRenderer.m_174264_(stack, (Level)level, null, seed);
                    if (model.m_7539_() && !stack.m_150930_(Items.f_42713_) && !stack.m_150930_(Items.f_151059_)) {
                        boolean bed = stack.m_204117_(ItemTags.f_13146_);
                        poseStack.m_252880_(0.5f, 0.81f, 0.5f);
                        if (bed) {
                            poseStack.m_252880_(0.0f, -0.06f, 0.0f);
                        }
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(r));
                        if (bed) {
                            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        }
                        float scale = 0.5f;
                        poseStack.m_85841_(scale, scale, scale);
                        this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), seed);
                    } else {
                        int maxStack = stack.m_41741_();
                        int count = Math.min(maxStack, 4 * stack.m_41613_() / maxStack + 1);
                        for (int i = 0; i < count; ++i) {
                            float xOffset = i > 0 ? (float)Math.sin(i * 23) * 0.04f : 0.0f;
                            float zOffset = i > 0 ? (float)Math.cos(i * 51) * 0.03f : 0.0f;
                            poseStack.m_85836_();
                            poseStack.m_85837_((double)(0.5f + xOffset), (double)0.7f + 0.031 * (double)i, (double)(0.5f + zOffset));
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(r + xOffset * 180.0f));
                            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                            float scale = 0.5f;
                            poseStack.m_85841_(scale, scale, scale);
                            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, table.m_58904_(), seed);
                            poseStack.m_85849_();
                        }
                    }
                }
            }
            poseStack.m_85849_();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_ && mc.f_91074_.m_7500_()) {
            poseStack.m_85836_();
            facing = table.getFacing();
            float textScale = 0.02f;
            Vec3i normal = facing.m_122436_();
            double offset = 0.3;
            poseStack.m_85837_((double)(-normal.m_123341_()) * offset + (normal.m_123341_() == 0 ? 0.7 : 0.5), 0.7, (double)(-normal.m_123343_()) * offset + (normal.m_123343_() == 0 ? 0.3 : 0.5));
            poseStack.m_85841_(textScale, textScale, textScale);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(facing.m_122435_() - 180.0f));
            String countStr = Integer.toString(stack.m_41613_());
            Font font = mc.f_91062_;
            float f = (float)mc.f_91062_.m_92895_(countStr) * -0.5f;
            Objects.requireNonNull(mc.f_91062_);
            font.m_271703_(countStr, f, 9.0f * -0.5f, RedStoneWireBlock.m_55606_((int)8), false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.m_85849_();
        }
    }
}

