/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.block_entity;

import com.legacy.rediscovered.block.RedDragonEggBlock;
import com.legacy.rediscovered.block_entities.RedDragonEggBlockEntity;
import com.legacy.rediscovered.client.render.RediscoveredRendering;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class RedDragonEggRenderer<T extends RedDragonEggBlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;

    public RedDragonEggRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(T egg, float partialTicks, PoseStack poseStack, MultiBufferSource buffSource, int packedLight, int packedOverlay) {
        BlockHitResult blockHit;
        if (egg.m_58900_().m_61138_((Property)RedDragonEggBlock.FALLING) && ((Boolean)egg.m_58900_().m_61143_((Property)RedDragonEggBlock.FALLING)).booleanValue()) {
            return;
        }
        poseStack.m_85836_();
        BakedModel model = this.blockRenderer.m_110910_(egg.m_58900_());
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (((RedDragonEggBlockEntity)((Object)egg)).canHatch() && ((RedDragonEggBlockEntity)((Object)egg)).isShaking()) {
            float hatchProgress = ((RedDragonEggBlockEntity)((Object)egg)).getHatchProgress();
            hatchProgress = hatchProgress * hatchProgress * hatchProgress * hatchProgress;
            float bounces = 1.0f;
            float bounceHeight = 0.1f * hatchProgress;
            float period = (float)Math.PI * 2 / ((float)((RedDragonEggBlockEntity)((Object)egg)).maxShakeTime() / bounces);
            float bounce = (float)Math.sin(period * ((RedDragonEggBlockEntity)((Object)egg)).clientShakeTime(partialTicks)) * bounceHeight;
            if (bounce > 0.0f) {
                float shakeAmount = 9.0f * hatchProgress;
                float turnAmount = 15.0f * hatchProgress;
                poseStack.m_252781_(Axis.f_252529_.m_252977_((float)Math.sin(period * 2.0f * ((RedDragonEggBlockEntity)((Object)egg)).clientShakeTime(partialTicks)) * shakeAmount * (float)((RedDragonEggBlockEntity)((Object)egg)).clientXShakeDir));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)Math.sin(period * 2.0f * ((RedDragonEggBlockEntity)((Object)egg)).clientShakeTime(partialTicks)) * shakeAmount * (float)((RedDragonEggBlockEntity)((Object)egg)).clientZShakeDir));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Math.sin(period * 2.0f * ((RedDragonEggBlockEntity)((Object)egg)).clientShakeTime(partialTicks)) * turnAmount * (float)((RedDragonEggBlockEntity)((Object)egg)).clientYShakeDir));
                poseStack.m_252880_(0.0f, bounce, 0.0f);
            }
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        this.blockRenderer.m_110937_().renderModel(poseStack.m_85850_(), buffSource.m_6299_(Sheets.m_110789_()), egg.m_58900_(), model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, ModelData.EMPTY, RenderType.m_110451_());
        HitResult bounces = Minecraft.m_91087_().f_91077_;
        if (bounces instanceof BlockHitResult && (blockHit = (BlockHitResult)bounces).m_82425_().equals((Object)egg.m_58899_()) && !Minecraft.m_91087_().f_91066_.f_92062_) {
            poseStack.m_85836_();
            VertexConsumer outline = buffSource.m_6299_(RenderType.m_110504_());
            RediscoveredRendering.renderHitOutline(poseStack, outline, Minecraft.m_91087_().f_91075_, 0.0, 0.0, 0.0, BlockPos.f_121853_, egg.m_58900_());
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public int m_142163_() {
        return (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 16;
    }
}

