/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.block_entity;

import com.legacy.rediscovered.block_entities.MiniDragonPylonBlockEntity;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.client.render.RediscoveredRendering;
import com.legacy.rediscovered.client.render.model.DragonPylonRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class MiniDragonPylonRenderer<T extends MiniDragonPylonBlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart cube;

    public MiniDragonPylonRenderer(BlockEntityRendererProvider.Context context) {
        this.cube = context.m_173582_(RediscoveredRenderRefs.DRAGON_PYLON).m_171324_("cube");
    }

    public void render(T pylon, float partialTicks, PoseStack poseStack, MultiBufferSource buffSource, int packedLight, int packedOverlay) {
        BlockHitResult blockHit;
        int overlay = OverlayTexture.f_118083_;
        float y = DragonPylonRenderer.getY(((MiniDragonPylonBlockEntity)((Object)pylon)).ticks, partialTicks);
        float yRenderOffset = y / 2.0f;
        float rot = ((float)((MiniDragonPylonBlockEntity)((Object)pylon)).ticks + partialTicks) * 3.0f;
        float scale = 1.5f;
        VertexConsumer vertexconsumer = buffSource.m_6299_(DragonPylonRenderer.RENDER_TYPE);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.7f + yRenderOffset, 0.5f);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, DragonPylonRenderer.SIN_45, 0.0f, DragonPylonRenderer.SIN_45));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rot * 2.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rot * 3.0f));
        this.cube.m_104301_(poseStack, vertexconsumer, 0xF000F0, overlay);
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof BlockHitResult && (blockHit = (BlockHitResult)hitResult).m_82425_().equals((Object)pylon.m_58899_()) && !Minecraft.m_91087_().f_91066_.f_92062_) {
            poseStack.m_85836_();
            float inversedScale = -1.0f / scale;
            poseStack.m_85841_(inversedScale, inversedScale, inversedScale);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            VertexConsumer outline = buffSource.m_6299_(RenderType.m_110504_());
            RediscoveredRendering.renderHitOutline(poseStack, outline, Minecraft.m_91087_().f_91075_, 0.0, 0.0, 0.0, BlockPos.f_121853_, pylon.m_58900_());
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        BlockPos beamPos = ((MiniDragonPylonBlockEntity)((Object)pylon)).getBeamPos();
        if (beamPos != null) {
            poseStack.m_85836_();
            Vec3 beamStart = beamPos.m_252807_().m_82546_(pylon.m_58899_().m_252807_()).m_82520_(0.5, 0.5, 0.5);
            poseStack.m_85837_(beamStart.f_82479_, beamStart.f_82480_, beamStart.f_82481_);
            DragonPylonRenderer.renderPylonBeam((float)(-beamStart.f_82479_) + 0.5f, (float)(-beamStart.f_82480_) + yRenderOffset - 1.5f, (float)(-beamStart.f_82481_) + 0.5f, partialTicks, ((MiniDragonPylonBlockEntity)((Object)pylon)).ticks, poseStack, buffSource, packedLight, ((float)((MiniDragonPylonBlockEntity)((Object)pylon)).ticks + partialTicks) * 0.11f, 0.7f, 0.8f, 0.5f);
            poseStack.m_85849_();
            if (((MiniDragonPylonBlockEntity)((Object)pylon)).isRespawnMaster()) {
                poseStack.m_85836_();
                float progress = Mth.m_14036_((float)(((MiniDragonPylonBlockEntity)((Object)pylon)).getRespawnProgress(partialTicks) * 3.0f), (float)0.0f, (float)1.0f);
                float beamLength = (float)((MiniDragonPylonBlockEntity)((Object)pylon)).getRespawnHeight() * progress;
                poseStack.m_85837_(beamStart.f_82479_, (double)(beamLength + 2.0f), beamStart.f_82481_);
                DragonPylonRenderer.renderPylonBeam(0.0f, -beamLength + 1.0f, 0.0f, partialTicks, ((MiniDragonPylonBlockEntity)((Object)pylon)).ticks, poseStack, buffSource, packedLight, ((float)((MiniDragonPylonBlockEntity)((Object)pylon)).ticks + partialTicks) * 0.11f);
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_85837_(beamStart.f_82479_, (double)((float)((MiniDragonPylonBlockEntity)((Object)pylon)).getRespawnHeight() + 4.0f), beamStart.f_82481_);
                float shieldScale = ((MiniDragonPylonBlockEntity)((Object)pylon)).getRespawnProgress(partialTicks) * 5.0f;
                poseStack.m_85841_(shieldScale, shieldScale, shieldScale);
                VertexConsumer pylonCons = DragonPylonRenderer.ENERGY_SHIELD_TEXTURE.m_119194_(buffSource, RediscoveredRenderType::energy);
                float shieldRot = ((float)((MiniDragonPylonBlockEntity)((Object)pylon)).ticks + partialTicks) * 4.0f;
                DragonPylonRenderer.renderPylonShields(this.cube, poseStack, pylonCons, packedLight, shieldRot, 1.2f, 1.0f, 4);
                poseStack.m_85849_();
            }
        }
    }

    public boolean shouldRenderOffScreen(T pylon) {
        return ((MiniDragonPylonBlockEntity)((Object)pylon)).getBeamPos() != null;
    }

    public int m_142163_() {
        return super.m_142163_() * 3;
    }
}

