/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.block_entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.block.GearBlock;
import com.legacy.rediscovered.block_entities.GearBlockEntity;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.model.GearModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.RedStoneWireBlock;

public class GearRenderer
implements BlockEntityRenderer<GearBlockEntity> {
    private final GearModel model;
    private static final ResourceLocation TEXTURE = RediscoveredMod.locate("textures/block/gear.png");

    public GearRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new GearModel(context.m_173582_(RediscoveredRenderRefs.GEAR));
    }

    public void render(GearBlockEntity gear, float partialTicks, PoseStack poseStack, MultiBufferSource buffSource, int packedLight, int overlay) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        VertexConsumer gearBuffer = buffSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float gearScale = 1.1f;
        poseStack.m_85841_(gearScale, gearScale, gearScale);
        for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
            poseStack.m_85836_();
            this.rotateToFace(poseStack, face.direction);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(gear.getAngle(face.direction, partialTicks)));
            BlockPos pos = gear.m_58899_();
            boolean checkerboard = pos.m_123341_() % 2 == 0 ^ pos.m_123343_() % 2 == 0;
            if (pos.m_123342_() % 2 == 0 ? checkerboard : !checkerboard) {
                poseStack.m_85837_(0.0, 0.001, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
            }
            if (face.direction.m_122434_().m_122479_()) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
            }
            if (((GearBlock.GearState)((Object)gear.m_58900_().m_61143_(face.stateProperty))).exists()) {
                this.model.m_7695_(poseStack, gearBuffer, packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        if (mc.f_91066_.f_92063_ && mc.f_91074_.m_7500_()) {
            for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
                if (!((GearBlock.GearState)((Object)gear.m_58900_().m_61143_(face.stateProperty))).exists()) continue;
                poseStack.m_85836_();
                float textScale = 0.02f;
                Vec3i normal = face.direction.m_122436_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                double offset = 0.4;
                poseStack.m_85837_((double)normal.m_123341_() * offset, (double)normal.m_123342_() * offset, (double)normal.m_123343_() * offset);
                poseStack.m_85841_(textScale, textScale, textScale);
                this.rotateToFace(poseStack, face.direction);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                int power = gear.getPower(face).getPower();
                String powerStr = Integer.toString(power);
                Font font = mc.f_91062_;
                float f = (float)mc.f_91062_.m_92895_(powerStr) * -0.5f;
                Objects.requireNonNull(mc.f_91062_);
                font.m_271703_(powerStr, f, 9.0f * -0.5f, RedStoneWireBlock.m_55606_((int)Math.abs(power)), false, poseStack.m_85850_().m_252922_(), buffSource, Font.DisplayMode.NORMAL, 0, packedLight);
                poseStack.m_85849_();
            }
        }
    }

    private void rotateToFace(PoseStack poseStack, Direction direction) {
        switch (direction) {
            case NORTH: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                break;
            }
        }
    }
}

