/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render;

import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class RediscoveredRendering {
    public static Bolt bolt() {
        return new Bolt();
    }

    public static void makeTube(PoseStack poseStack, VertexConsumer buffer, Vec3 start, Vec3 end, float width, float r, float g, float b, float a) {
        RediscoveredRendering.makeTube(poseStack, buffer, start, end, width, width, r, g, b, a);
    }

    public static void makeTube(PoseStack poseStack, VertexConsumer buffer, Vec3 start, Vec3 end, float startWidth, float endWidth, float r, float g, float b, float a) {
        RediscoveredRendering.makeTube(poseStack, buffer, (float)start.m_7096_(), (float)start.m_7098_(), (float)start.m_7094_(), (float)end.m_7096_(), (float)end.m_7098_(), (float)end.m_7094_(), startWidth, endWidth, r, g, b, a);
    }

    public static void makeTube(PoseStack poseStack, VertexConsumer buffer, float nX, float nY, float nZ, float xX, float xY, float xZ, float startWidth, float endWidth, float r, float g, float b, float a) {
        float sw = startWidth * 0.5f;
        float ew = endWidth * 0.5f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix, nX - sw, nY, nZ - sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX - sw, nY, nZ + sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX - ew, xY, xZ + ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX - ew, xY, xZ - ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX - sw, nY, nZ + sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX + sw, nY, nZ + sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX + ew, xY, xZ + ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX - ew, xY, xZ + ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX + sw, nY, nZ + sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX + sw, nY, nZ - sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX + ew, xY, xZ - ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX + ew, xY, xZ + ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX + sw, nY, nZ - sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, nX - sw, nY, nZ - sw).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX - ew, xY, xZ - ew).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, xX + ew, xY, xZ - ew).m_85950_(r, g, b, a).m_5752_();
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer buffer, float mnX, float mnY, float mnZ, float mxX, float mxY, float mxZ, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix, mnX, mnY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mnY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mnY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mnY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mnY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mnY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mnY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mnY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mnY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mnY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mnY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mnY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mnX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, mxX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
    }

    public static void renderHitOutline(PoseStack poseStack, VertexConsumer vertexConsumer, Entity camerEntity, double camX, double camY, double camZ, BlockPos blockPos, BlockState state) {
        RediscoveredRendering.renderShape(poseStack, vertexConsumer, state.m_60651_((BlockGetter)Minecraft.m_91087_().f_91073_, blockPos, CollisionContext.m_82750_((Entity)camerEntity)), (double)blockPos.m_123341_() - camX, (double)blockPos.m_123342_() - camY, (double)blockPos.m_123343_() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void renderShape(PoseStack poseStack, VertexConsumer pConsumer, VoxelShape pShape, double pX, double pY, double pZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        pShape.m_83224_((p_234280_, p_234281_, p_234282_, p_234283_, p_234284_, p_234285_) -> {
            float f = (float)(p_234283_ - p_234280_);
            float f1 = (float)(p_234284_ - p_234281_);
            float f2 = (float)(p_234285_ - p_234282_);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            pConsumer.m_252986_(posestack$pose.m_252922_(), (float)(p_234280_ + pX), (float)(p_234281_ + pY), (float)(p_234282_ + pZ)).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(posestack$pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            pConsumer.m_252986_(posestack$pose.m_252922_(), (float)(p_234283_ + pX), (float)(p_234284_ + pY), (float)(p_234285_ + pZ)).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(posestack$pose.m_252943_(), f, f1, f2).m_5752_();
        });
    }

    public static class Bolt {
        IntProvider boltsRange = UniformInt.m_146622_((int)9, (int)11);
        FloatProvider centerSpacingRange = ConstantFloat.f_146451_;
        FloatProvider lengthRange = UniformFloat.m_146605_((float)1.0f, (float)2.0f);
        IntProvider turnsRange = UniformInt.m_146622_((int)3, (int)4);
        int layers = 3;
        FloatProvider startScaleRange = UniformFloat.m_146605_((float)0.15f, (float)0.25f);
        FloatProvider endScaleRange = UniformFloat.m_146605_((float)0.4f, (float)0.6f);
        FloatProvider yRot;
        FloatProvider xRot = UniformFloat.m_146605_((float)0.0f, (float)360.0f);
        FloatProvider zRot;
        FloatProvider r;
        FloatProvider g;
        FloatProvider b;
        FloatProvider a;
        boolean limitedChaos = false;
        boolean recenterAtTip = false;
        public static final ParticleRenderType PARTICLE_RENDER_TYPE = new ParticleRenderType(){

            public void m_6505_(BufferBuilder buffer, TextureManager textureManager) {
                RenderType type = RediscoveredRenderType.bolt();
                type.m_110185_();
                buffer.m_166779_(type.m_173186_(), type.m_110508_());
            }

            public void m_6294_(Tesselator tesselator) {
                tesselator.m_85914_();
                RediscoveredRenderType.bolt().m_110188_();
            }
        };

        private Bolt() {
            this.yRot = UniformFloat.m_146605_((float)0.0f, (float)360.0f);
            this.zRot = UniformFloat.m_146605_((float)0.0f, (float)360.0f);
            this.r = ConstantFloat.m_146458_((float)1.0f);
            this.g = ConstantFloat.m_146458_((float)1.0f);
            this.b = ConstantFloat.m_146458_((float)1.0f);
            this.a = ConstantFloat.m_146458_((float)0.25f);
        }

        public Bolt bolts(int min, int max) {
            this.boltsRange = min == max ? ConstantInt.m_146483_((int)min) : UniformInt.m_146622_((int)min, (int)max);
            return this;
        }

        public Bolt bolts(int val) {
            this.boltsRange = ConstantInt.m_146483_((int)val);
            return this;
        }

        public Bolt centerSpacing(float min, float max) {
            this.centerSpacingRange = min == max ? ConstantFloat.m_146458_((float)min) : UniformFloat.m_146605_((float)min, (float)max);
            return this;
        }

        public Bolt centerSpacing(float val) {
            this.centerSpacingRange = ConstantFloat.m_146458_((float)val);
            return this;
        }

        public Bolt length(float min, float max) {
            this.lengthRange = min == max ? ConstantFloat.m_146458_((float)min) : UniformFloat.m_146605_((float)min, (float)max);
            return this;
        }

        public Bolt length(float val) {
            this.lengthRange = ConstantFloat.m_146458_((float)val);
            return this;
        }

        public Bolt turns(int min, int max) {
            this.turnsRange = min == max ? ConstantInt.m_146483_((int)min) : UniformInt.m_146622_((int)min, (int)max);
            return this;
        }

        public Bolt turns(int val) {
            this.turnsRange = ConstantInt.m_146483_((int)val);
            return this;
        }

        public Bolt layers(int layers) {
            this.layers = layers;
            return this;
        }

        public Bolt startScale(float min, float max) {
            this.startScaleRange = min == max ? ConstantFloat.m_146458_((float)min) : UniformFloat.m_146605_((float)min, (float)max);
            return this;
        }

        public Bolt startScale(float val) {
            this.startScaleRange = ConstantFloat.m_146458_((float)val);
            return this;
        }

        public Bolt endScale(float min, float max) {
            this.endScaleRange = min == max ? ConstantFloat.m_146458_((float)min) : UniformFloat.m_146605_((float)min, (float)max);
            return this;
        }

        public Bolt endScale(float val) {
            this.endScaleRange = ConstantFloat.m_146458_((float)val);
            return this;
        }

        public Bolt rotationDegrees(FloatProvider x, FloatProvider y, FloatProvider z) {
            this.xRot = x;
            this.yRot = y;
            this.zRot = z;
            return this;
        }

        public Bolt color(FloatProvider r, FloatProvider g, FloatProvider b, FloatProvider a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Bolt limitedChaos() {
            this.limitedChaos = true;
            return this;
        }

        public Bolt recenterAtTip() {
            this.recenterAtTip = true;
            return this;
        }

        public void render(PoseStack poseStack, MultiBufferSource buffSource, long seed) {
            this.render(poseStack, buffSource.m_6299_(RediscoveredRenderType.bolt()), seed);
        }

        public void render(PoseStack poseStack, VertexConsumer buff, long seed) {
            poseStack.m_85836_();
            RandomSource rand = RandomSource.m_216335_((long)seed);
            int bolts = this.boltsRange.m_214085_(rand);
            for (int l = 1; l <= this.layers; ++l) {
                for (int i = 0; i < bolts; ++i) {
                    poseStack.m_85836_();
                    RandomSource boltRand = RandomSource.m_216335_((long)(seed + (long)i));
                    int turns = this.turnsRange.m_214085_(boltRand);
                    float length = this.lengthRange.m_214084_(boltRand);
                    float scale = this.startScaleRange.m_214084_(boltRand);
                    float endScale = this.endScaleRange.m_214084_(boltRand);
                    float centerSpacing = this.centerSpacingRange.m_214084_(boltRand);
                    float r = this.r.m_214084_(boltRand);
                    float g = this.g.m_214084_(boltRand);
                    float b = this.b.m_214084_(boltRand);
                    float a = this.a.m_214084_(boltRand);
                    float chaos = length / (float)turns;
                    Vec3[] points = new Vec3[turns + 1];
                    Vec3 lastEnd = Vec3.f_82478_.m_82520_(0.0, (double)centerSpacing, 0.0);
                    float destY = (float)lastEnd.f_82480_ + length;
                    points[0] = lastEnd;
                    for (int t = 1; t <= turns; ++t) {
                        Vec3 end;
                        boolean tip = t == turns;
                        float c = this.limitedChaos ? chaos * (1.0f - (float)t / (float)turns) : chaos;
                        points[t] = end = new Vec3(tip && this.recenterAtTip ? 0.0 : lastEnd.m_7096_() + (double)((boltRand.m_188501_() - 0.5f) * c), tip ? (double)destY : lastEnd.f_82480_ + (double)(boltRand.m_188501_() * chaos) * 1.75, tip && this.recenterAtTip ? 0.0 : lastEnd.m_7094_() + (double)((boltRand.m_188501_() - 0.5f) * c));
                        lastEnd = end;
                    }
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(this.yRot.m_214084_(boltRand)));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(this.zRot.m_214084_(boltRand)));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(this.xRot.m_214084_(boltRand)));
                    float scaling = scale;
                    for (int t = 0; t < turns; ++t) {
                        float eScale = Mth.m_14179_((float)((float)t / (float)turns), (float)scaling, (float)endScale);
                        Vec3 start = points[t];
                        Vec3 end = points[t + 1];
                        RediscoveredRendering.makeTube(poseStack, buff, start, end, scaling * (float)l, eScale * (float)l, r, g, b, a);
                        scaling = eScale;
                    }
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85849_();
        }
    }
}

