/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render;

import com.legacy.rediscovered.RediscoveredMod;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public abstract class RediscoveredRenderType
extends RenderType {
    private static ShaderInstance rendertypeFluffyCloudsShader;
    private static final BiFunction<ResourceLocation, Boolean, RenderType> SORTED_ENTITY_TRANSLUCENT;
    private static final BiFunction<ResourceLocation, Boolean, RenderType> SORTED_ENTITY_TRANSLUCENT_CULL;
    private static final BiFunction<ResourceLocation, Boolean, RenderType> ENERGY;
    private static final RenderType BOLT;

    public RediscoveredRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
    }

    public static void init(IEventBus modBus) {
        modBus.addListener(RediscoveredRenderType::registerShaders);
    }

    protected static void registerShaders(RegisterShadersEvent event) {
        try {
            ResourceProvider prov = event.getResourceProvider();
            event.registerShader(new ShaderInstance(prov, RediscoveredMod.locate("fluffy_clouds"), DefaultVertexFormat.f_85822_), shader -> {
                rendertypeFluffyCloudsShader = shader;
            });
        }
        catch (IOException e) {
            RediscoveredMod.LOGGER.error("Failed to register shaders", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static RenderType sortedEntityTranslucent(ResourceLocation texture) {
        return SORTED_ENTITY_TRANSLUCENT.apply(texture, false);
    }

    public static RenderType sortedEntityTranslucentCull(ResourceLocation texture) {
        return SORTED_ENTITY_TRANSLUCENT_CULL.apply(texture, false);
    }

    public static RenderType energy(ResourceLocation texture) {
        return ENERGY.apply(texture, false);
    }

    public static RenderType bolt() {
        return BOLT;
    }

    public static ShaderInstance getFluffyCloudsShader() {
        return rendertypeFluffyCloudsShader;
    }

    private static String name(String name) {
        return "rediscovered_" + name;
    }

    static {
        SORTED_ENTITY_TRANSLUCENT = Util.m_143821_((texture, affectsOutline) -> {
            RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(affectsOutline.booleanValue());
            return RediscoveredRenderType.m_173215_((String)RediscoveredRenderType.name("sorted_entity_translucent"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$compositestate);
        });
        SORTED_ENTITY_TRANSLUCENT_CULL = Util.m_143821_((texture, affectsOutline) -> {
            RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(affectsOutline.booleanValue());
            return RediscoveredRenderType.m_173215_((String)RediscoveredRenderType.name("sorted_entity_translucent_cull"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$compositestate);
        });
        ENERGY = Util.m_143821_((texture, affectsOutline) -> {
            RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110136_).m_110661_(f_110110_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(affectsOutline.booleanValue());
            return RediscoveredRenderType.m_173215_((String)RediscoveredRenderType.name("energy"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$compositestate);
        });
        BOLT = RediscoveredRenderType.m_173215_((String)RediscoveredRenderType.name("bolt"), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173091_).m_110687_(f_110114_).m_110685_(f_110136_).m_110675_(f_110127_).m_110691_(false));
    }
}

