/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.client.particles.RotatedTextureSheetParticle;
import com.legacy.rediscovered.client.particles.WindData;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WindParticle
extends RotatedTextureSheetParticle {
    final SpriteSet spriteSet;
    final float initialRotation;
    final float deltaRotation;
    final float baseAlpha;
    final int pulses;
    final float initialScale;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);
    boolean f_107205_ = false;

    private WindParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, SpriteSet spriteSet, int pulses, float initialScale) {
        super(level, x, y, z);
        this.spriteSet = spriteSet;
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107663_ = 2.0f * (this.f_107223_.m_188501_() * 0.2f + 0.5f) * initialScale;
        this.initialScale = initialScale;
        float f = this.f_107223_.m_188501_() + 0.8f;
        this.f_107227_ *= Mth.m_14036_((float)f, (float)0.8f, (float)1.0f);
        this.f_107228_ *= Mth.m_14036_((float)f, (float)0.9f, (float)1.0f);
        this.f_107229_ *= Mth.m_14036_((float)f, (float)0.9f, (float)1.0f);
        this.f_107230_ = this.baseAlpha = this.initialScale > 1.0f ? 0.8f : 0.4f + this.f_107223_.m_188501_() * 0.3f;
        this.f_107225_ = (int)(this.f_107223_.m_188501_() * 5.0f) + 10 + (int)(0.5f * (this.initialScale - 1.0f));
        this.f_107219_ = this.initialScale == 1.0f;
        this.f_107231_ = this.initialRotation = this.f_107223_.m_188501_() * 360.0f * ((float)Math.PI / 180);
        this.deltaRotation = (this.f_107223_.m_188501_() - 0.5f) * 200.0f * ((float)Math.PI / 180);
        float scale = 0.01f;
        this.m_107250_(scale, scale);
        this.m_108339_(spriteSet);
        this.pulses = pulses;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public float m_5902_(float partialTicks) {
        float light = (float)this.f_107208_.m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)this.m_107277_().m_82399_())) / (float)this.f_107208_.m_7469_();
        float a = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        return (this.f_107663_ + a * 2.0f) * light;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            if (this.pulses > 0 && this.f_107224_ == this.f_107225_ / 3) {
                this.f_107208_.m_7106_((ParticleOptions)new WindData(this.pulses - 1, this.initialScale), this.f_107212_ - this.f_107215_, this.f_107213_ - this.f_107216_, this.f_107214_ - this.f_107217_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
            float a = (float)this.f_107224_ / (float)this.f_107225_;
            this.f_107230_ = this.baseAlpha * (1.0f - a);
            this.f_107231_ = a * this.deltaRotation + this.initialRotation;
            this.m_108339_(this.spriteSet);
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    public void m_6257_(double pX, double pY, double pZ) {
        if (!this.f_107205_) {
            double d0 = pX;
            double d1 = pY;
            double d2 = pZ;
            if (this.f_107219_ && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
                Vec3 vec3 = Entity.m_198894_((Entity)null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
                pX = vec3.f_82479_;
                pY = vec3.f_82480_;
                pZ = vec3.f_82481_;
                if (pX != d0 || pY != d1 || pZ != d2) {
                    this.m_107274_();
                }
            }
            if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
                this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
                this.m_107275_();
            }
            if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
                this.f_107205_ = true;
            }
            boolean bl = this.f_107218_ = d1 != pY && d1 < 0.0;
            if (d0 != pX) {
                this.f_107215_ = 0.0;
            }
            if (d2 != pZ) {
                this.f_107217_ = 0.0;
            }
        }
    }

    protected int m_6355_(float partialTick) {
        int l = super.m_6355_(partialTick);
        int min = 12;
        return LightTexture.m_109885_((int)LightTexture.m_109883_((int)l), (int)Math.max(min, LightTexture.m_109894_((int)l)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<WindData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(WindData data, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new WindParticle(level, x, y, z, dx, dy, dz, this.spriteSet, data.pulses(), data.scale());
        }
    }
}

