/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.RediscoveredUtil;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;

public record WindData(int pulses, float scale) implements ParticleOptions
{
    public static final Codec<WindData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("pulses").forGetter(WindData::pulses), (App)RediscoveredUtil.NON_NEGATIVE_FLOAT.fieldOf("scale").forGetter(WindData::scale)).apply((Applicative)instance, WindData::new));
    public static final ParticleOptions.Deserializer<WindData> DESERIALIZER = new ParticleOptions.Deserializer<WindData>(){

        public WindData fromCommand(ParticleType<WindData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int pulses = reader.readInt();
            reader.expect(' ');
            float scale = reader.readFloat();
            return new WindData(pulses, scale);
        }

        public WindData fromNetwork(ParticleType<WindData> type, FriendlyByteBuf buff) {
            return new WindData(buff.readInt(), buff.readFloat());
        }
    };

    public void m_7711_(FriendlyByteBuf buff) {
        buff.writeInt(this.pulses);
        buff.writeFloat(this.scale);
    }

    public ParticleType<?> m_6012_() {
        return RediscoveredParticles.WIND;
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.pulses, Float.valueOf(this.scale));
    }
}

