/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.client.particles.ShockwaveData;
import com.legacy.rediscovered.client.render.RediscoveredRendering;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShockwaveParticle
extends Particle {
    boolean pulsed = false;
    int bolts;

    public ShockwaveParticle(ClientLevel level, double x, double y, double z, int lifetime, int bolts) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107225_ = lifetime;
        this.bolts = bolts;
    }

    public static RediscoveredRendering.Bolt createBolt(int bolts, float time) {
        float minLength = 0.25f;
        return RediscoveredRendering.bolt().layers(2).bolts(bolts).startScale(0.04f).endScale(0.001f).centerSpacing(time * 2.5f).length(minLength, Math.max(minLength, (1.0f - time) * 2.0f)).turns(2, 4).rotationDegrees((FloatProvider)UniformFloat.m_146605_((float)0.0f, (float)360.0f), (FloatProvider)UniformFloat.m_146605_((float)0.0f, (float)0.1f), (FloatProvider)UniformFloat.m_146605_((float)85.0f, (float)95.0f)).color((FloatProvider)UniformFloat.m_146605_((float)0.2f, (float)0.6f), (FloatProvider)UniformFloat.m_146605_((float)0.65f, (float)0.85f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)0.3f));
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        float t = Mth.m_14036_((float)((float)this.f_107224_ + partialTicks), (float)0.0f, (float)this.f_107225_) / (float)this.f_107225_;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        poseStack.m_252880_(x, y, z);
        ShockwaveParticle.createBolt(this.bolts, t).render(poseStack, buffer, (long)((int)((double)this.f_107224_ + this.f_107212_ + this.f_107214_) / 2 * 10));
        poseStack.m_85849_();
    }

    public int m_6355_(float pPartialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType m_7556_() {
        return RediscoveredRendering.Bolt.PARTICLE_RENDER_TYPE;
    }

    public boolean shouldCull() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ShockwaveData> {
        public ShockwaveParticle createParticle(ShockwaveData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ShockwaveParticle(level, x, y, z, type.lifetime(), type.bolts());
        }
    }
}

