/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;

public record ShockwaveData(int lifetime, int bolts) implements ParticleOptions
{
    public static final Codec<ShockwaveData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("lifetime").forGetter(ShockwaveData::lifetime), (App)ExtraCodecs.f_144628_.fieldOf("bolts").forGetter(ShockwaveData::bolts)).apply((Applicative)instance, ShockwaveData::new));
    public static final ParticleOptions.Deserializer<ShockwaveData> DESERIALIZER = new ParticleOptions.Deserializer<ShockwaveData>(){

        public ShockwaveData fromCommand(ParticleType<ShockwaveData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            int bolts = reader.readInt();
            return new ShockwaveData(lifetime, bolts);
        }

        public ShockwaveData fromNetwork(ParticleType<ShockwaveData> type, FriendlyByteBuf buff) {
            return new ShockwaveData(buff.readInt(), buff.readInt());
        }
    };

    public ShockwaveData() {
        this(10, 20);
    }

    public void m_7711_(FriendlyByteBuf buff) {
        buff.writeInt(this.lifetime);
        buff.writeInt(this.bolts);
    }

    public ParticleType<?> m_6012_() {
        return RediscoveredParticles.SHOCKWAVE;
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.lifetime, this.bolts);
    }
}

