/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.particles.PylonShieldBlastData;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.legacy.rediscovered.client.render.model.DragonPylonRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PylonShieldBlastParticle
extends Particle {
    private final ModelPart model = Minecraft.m_91087_().m_167973_().m_171103_(RediscoveredRenderRefs.DRAGON_PYLON).m_171324_("cube");
    private final float initialRotation;
    final float startSize;
    final float endSize;
    final float startAlpha;
    final float endAlpha;

    public PylonShieldBlastParticle(ClientLevel level, double x, double y, double z, int lifetime, float startSize, float endSize, float startAlpha, float endAlpha) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.initialRotation = level.f_46441_.m_188501_() * 360.0f;
        this.f_107225_ = lifetime;
        this.startSize = startSize;
        this.endSize = endSize;
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        float age = (float)this.f_107224_ + partialTicks;
        float endPercent = Mth.m_14036_((float)(age / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        float startPercent = 1.0f - endPercent;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        poseStack.m_252880_(x, y, z);
        float scale = this.startSize * startPercent + this.endSize * endPercent;
        float alpha = this.startAlpha * startPercent + this.endAlpha * endPercent;
        float rotation = this.initialRotation + age * 20.0f;
        MultiBufferSource.BufferSource buffSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer energyBuffer = DragonPylonRenderer.ENERGY_SHIELD_TEXTURE.m_119194_((MultiBufferSource)buffSource, RediscoveredRenderType::energy);
        DragonPylonRenderer.renderPylonShields(this.model, poseStack, energyBuffer, this.m_6355_(partialTicks), rotation, scale, 1.18f, 1, alpha);
        buffSource.m_109911_();
        poseStack.m_85849_();
    }

    public void m_5989_() {
        super.m_5989_();
    }

    public int m_6355_(float pPartialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public boolean shouldCull() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<PylonShieldBlastData> {
        public PylonShieldBlastParticle createParticle(PylonShieldBlastData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PylonShieldBlastParticle(level, x, y, z, type.lifetime(), type.startSize(), type.endSize(), type.startAlpha(), type.endAlpha());
        }
    }
}

