/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.particles.NetherReactorPulseData;
import com.legacy.rediscovered.client.render.model.NetherReactorPulseModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NetherReactorPulseParticle
extends Particle {
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)RediscoveredMod.locate("textures/particle/nether_reactor_pulse_0.png"));
    private final Model model = new NetherReactorPulseModel(Minecraft.m_91087_().m_167973_().m_171103_(RediscoveredRenderRefs.NETHER_REACTOR_PULSE));
    private float alpha = 1.0f;
    private float alphaO = 1.0f;
    private final float initialRotation;
    private int pulses = 0;
    boolean pulsed = false;
    final float maxSize;

    public NetherReactorPulseParticle(ClientLevel level, double x, double y, double z, int pulses, int lifetime, float maxSize) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.initialRotation = level.f_46441_.m_188501_() * 360.0f;
        this.f_107225_ = lifetime;
        this.pulses = pulses;
        this.maxSize = maxSize;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        float age = (float)this.f_107224_ + partialTicks;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        poseStack.m_252880_(f, f1, f2);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(age * 2.0f + this.initialRotation));
        float scale = age / (float)this.f_107225_ * this.maxSize;
        poseStack.m_85841_(scale, scale, scale);
        MultiBufferSource.BufferSource buffSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer particleBuff = buffSource.m_6299_(RENDER_TYPE);
        this.model.m_7695_(poseStack, particleBuff, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, Mth.m_14179_((float)partialTicks, (float)this.alphaO, (float)this.alpha));
        buffSource.m_109911_();
        poseStack.m_85849_();
    }

    public int m_6355_(float pPartialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.pulsed && this.pulses > 0 && (float)this.f_107224_ / (float)this.f_107225_ > 0.5f) {
            this.f_107208_.m_7106_((ParticleOptions)new NetherReactorPulseData(this.pulses - 1, this.f_107225_, this.maxSize), this.f_107212_, this.f_107213_ + 0.001, this.f_107214_, 0.0, 0.0, 0.0);
            this.pulsed = true;
        }
        this.alphaO = this.alpha;
        this.alpha = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
    }

    public boolean shouldCull() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<NetherReactorPulseData> {
        public NetherReactorPulseParticle createParticle(NetherReactorPulseData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new NetherReactorPulseParticle(level, x, y, z, type.pulses(), type.lifetime(), type.maxSize());
        }
    }
}

