/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;

public record NetherReactorPulseData(int pulses, int lifetime, float maxSize) implements ParticleOptions
{
    public static final Codec<NetherReactorPulseData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("pulses").forGetter(NetherReactorPulseData::pulses), (App)ExtraCodecs.f_144628_.fieldOf("lifetime").forGetter(NetherReactorPulseData::lifetime), (App)ExtraCodecs.f_184349_.fieldOf("max_size").forGetter(NetherReactorPulseData::maxSize)).apply((Applicative)instance, NetherReactorPulseData::new));
    public static final ParticleOptions.Deserializer<NetherReactorPulseData> DESERIALIZER = new ParticleOptions.Deserializer<NetherReactorPulseData>(){

        public NetherReactorPulseData fromCommand(ParticleType<NetherReactorPulseData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int pulses = reader.readInt();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float maxSize = reader.readFloat();
            return new NetherReactorPulseData(pulses, lifetime, maxSize);
        }

        public NetherReactorPulseData fromNetwork(ParticleType<NetherReactorPulseData> type, FriendlyByteBuf buff) {
            return new NetherReactorPulseData(buff.readInt(), buff.readInt(), buff.readFloat());
        }
    };

    public NetherReactorPulseData(int pulses) {
        this(pulses, 20, 5.0f);
    }

    public void m_7711_(FriendlyByteBuf buff) {
        buff.writeInt(this.pulses);
        buff.writeInt(this.lifetime);
        buff.writeFloat(this.maxSize);
    }

    public ParticleType<?> m_6012_() {
        return RediscoveredParticles.NETHER_REACTOR_PULSE;
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.pulses, this.lifetime, Float.valueOf(this.maxSize));
    }
}

