/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.particles;

import com.legacy.rediscovered.RediscoveredUtil;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;

public record LightningBoltData(float length) implements ParticleOptions
{
    public static final Codec<LightningBoltData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RediscoveredUtil.NON_NEGATIVE_FLOAT.fieldOf("length").forGetter(LightningBoltData::length)).apply((Applicative)instance, LightningBoltData::new));
    public static final ParticleOptions.Deserializer<LightningBoltData> DESERIALIZER = new ParticleOptions.Deserializer<LightningBoltData>(){

        public LightningBoltData fromCommand(ParticleType<LightningBoltData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float length = reader.readFloat();
            return new LightningBoltData(length);
        }

        public LightningBoltData fromNetwork(ParticleType<LightningBoltData> type, FriendlyByteBuf buff) {
            return new LightningBoltData(buff.readFloat());
        }
    };

    public LightningBoltData(RandomSource rand) {
        this(15 + rand.m_188503_(40));
    }

    public void m_7711_(FriendlyByteBuf buff) {
        buff.writeFloat(this.length);
    }

    public ParticleType<?> m_6012_() {
        return RediscoveredParticles.LIGHTNINGBOLT;
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.length));
    }
}

