/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.joml.Matrix4f;

public class StoreScreen
extends Screen {
    public static final float OPEN_CHANCE = 0.025f;
    static final int DEFAULT_WIDTH = 427;
    static final int DEFAULT_HEIGHT = 240;
    private static final ResourceLocation GUI = RediscoveredMod.locate("textures/gui/store/minecraft_store.png");
    private static final ResourceLocation GUI_OVERLAY = RediscoveredMod.locate("textures/gui/store/minecraft_store_overlay.png");
    public static final ResourceLocation STEVE_VILLAGER = RediscoveredMod.locate("textures/entity/store/steve_villager.png");
    public static final ResourceLocation HORSE_SADDLE = RediscoveredMod.locate("textures/entity/store/horse_saddle.png");
    final int imageWidth;
    final int imageHeight;
    int leftPos = 0;
    int topPos = 0;
    int balance = 0;
    int totalCost = 0;
    int tick = 0;
    Entity cart;
    List<StoreButton> products = new ArrayList<StoreButton>();
    CheckoutButton checkoutButton;
    public static boolean dyedPlanks = false;
    public static boolean steveVillager = false;
    public static boolean horseSaddle = false;
    public static boolean showFireflies = false;
    public static boolean showLock = false;
    public static boolean rtxOn = false;

    public static void configRefresh(ModConfigEvent.Reloading event) {
        Boolean enabled;
        ModConfig config = event.getConfig();
        if (config.getModId().equals("rediscovered") && config.getType().equals((Object)ModConfig.Type.CLIENT) && (enabled = (Boolean)config.getConfigData().get(RediscoveredConfig.CLIENT.allowAprilFools.getPath())) != null && !enabled.booleanValue()) {
            dyedPlanks = false;
            steveVillager = false;
            horseSaddle = false;
            showFireflies = false;
            showLock = false;
            rtxOn = false;
        }
    }

    public StoreScreen() {
        super((Component)Component.m_237113_((String)"Minecraft Store"));
        this.imageWidth = 142;
        this.imageHeight = 218;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.f_91074_.m_6915_();
        super.m_7379_();
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        int oldBal = this.balance;
        super.m_6574_(pMinecraft, pWidth, pHeight);
        this.balance = oldBal;
    }

    public void m_86600_() {
        this.checkoutButton.f_93623_ = this.totalCost <= this.balance && this.products.stream().anyMatch(s -> s.isSelected);
        ++this.tick;
        this.cart.m_8119_();
        if (this.tick / 20 > 120 && this.f_96541_.f_91073_.f_46441_.m_188501_() < 0.02f) {
            ((Minecart)this.cart).m_6025_(0, 0, 0, true);
        }
        super.m_86600_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.products.clear();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.cart = new Minecart(EntityType.f_20469_, (Level)this.f_96541_.f_91073_);
        this.balance = 100 + this.f_96541_.f_91073_.f_46441_.m_188503_(301);
        int x = 0;
        int y = 0;
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "key", "Lock and Key DLC", 3, () -> {
            if (showLock && this.f_96541_.f_91073_.f_46441_.m_188501_() < 0.25f) {
                this.sendChat("Looks like this key fits!");
                showLock = false;
            } else {
                this.sendChat("Keys are now " + this.f_96541_.f_91073_.f_46441_.m_188503_(100) + "% longer!");
            }
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "key_dlc", "Lock and Key DLC+", 12, () -> {
            if (showLock && this.f_96541_.f_91073_.f_46441_.m_188501_() < 0.75f) {
                this.sendChat("One of these was bound to work!");
                showLock = false;
            } else {
                this.sendChat("Keys fit in locks " + this.f_96541_.f_91073_.f_46441_.m_188503_(100) + "% easier!");
            }
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "miners_helmet", "Miner's Helmet", 23, () -> {
            String url = "https://www.curseforge.com/minecraft/mc-mods/miners-helmet";
            this.sendChat(ModList.get().isLoaded("mining_helmet") ? Component.m_237113_((String)"But... mining helmets already exist? Ok then.") : Component.m_237113_((String)"You can download Miner's Helmet here! (some Minecraft version restrictions may apply)").m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)url))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url))));
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "dyed_planks", "Dyed Planks", 120, () -> {
            dyedPlanks = !dyedPlanks;
            this.sendChat(dyedPlanks ? "A limited selection of planks have been dyed!" : "The planks are scrubbed clean!");
        })));
        x = 0;
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, ++y, "horse_saddle", "Horse Saddles", 161, () -> {
            horseSaddle = !horseSaddle;
            this.sendChat(horseSaddle ? "All saddle, no horse!" : "Horses are so back!");
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "steve_villager", "Steve Villagers", 389, () -> {
            steveVillager = !steveVillager;
            this.sendChat(steveVillager ? "\"I... am Steve\" - Some villager" : "Villagers have returned to their bald form!");
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "mod_suggestion", "Suggest Mod!", RediscoveredItems.ruby, RediscoveredBlocks.ruby_block.m_5456_(), 1337, () -> this.sendChat("Nice try")).inactive()));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "fireflies", "Firefly Jar", 32, () -> {
            showFireflies = !showFireflies;
            this.sendChat(showFireflies ? "Oh no! Some of the fireflies escaped!" : "You manage to catch the fireflies!");
        })));
        x = 0;
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, ++y, "crab", "Vote: Crab", 41, () -> {
            String url = "https://www.youtube.com/watch?v=LDU_Txk06tM";
            this.sendChat(Component.m_237113_((String)"Your vote could not be processed at this time. But we found some cool crabs that want to hang out!").m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)url))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url))));
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "copper_golem", "Vote: Copper Golem", 35, () -> this.sendChat("Is iron not good enough for you?"))));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "mob_d", "Vote: Mob D", 39, () -> this.sendChat("You're... really late to the party on this one. Maybe check Minecraft Dungeons?"))));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "rtx_on", "RTX ON", 299, () -> {
            rtxOn = !rtxOn;
            this.sendChat(rtxOn ? "Now with enhanced graphics!" : "Back to boring old visuals");
        })));
        x = 0;
        String soon = "Coming Soon!";
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, ++y, "locked", soon, 26, () -> {}).inactive()));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "locked", soon, 89, () -> {}).inactive()));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "locked", "Regular Padlock", 12, () -> {
            this.sendChat(showLock ? "Despite your best efforts, another padlock will not fit on the crosshair." : "Your crosshair is securely locked in place!");
            showLock = true;
        })));
        this.products.add((StoreButton)this.m_142416_((GuiEventListener)new StoreButton(x++, y, "locked", soon, 1499, () -> {}).inactive()));
        this.checkoutButton = (CheckoutButton)this.m_142416_((GuiEventListener)new CheckoutButton(this.leftPos + 87, this.topPos + 38, 54, 11, b -> this.checkout()));
    }

    void sendChat(MutableComponent message) {
        this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"[Minecraft Store] ").m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN)).m_7220_((Component)message.m_130938_(s -> s.m_131140_(ChatFormatting.GREEN))), false);
    }

    void sendChat(String message) {
        this.sendChat(Component.m_237113_((String)message));
    }

    void checkout() {
        this.f_96541_.f_91073_.m_247517_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS);
        for (StoreButton p : this.products) {
            p.checkout();
        }
    }

    static ItemStack getCurrency() {
        return !rtxOn ? Items.f_42616_.m_7968_() : Items.f_42110_.m_7968_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        float scale = this.calculateScale();
        float translateScale = (scale - 1.0f) * 0.5f;
        pose.m_252880_((float)(-this.f_96543_) * translateScale, (float)(-this.f_96544_) * translateScale, 0.0f);
        pose.m_85841_(scale, scale, scale);
        Pair<Integer, Integer> scaleMouse = this.scaleMouse(mouseX, mouseY);
        mouseX = (Integer)scaleMouse.getFirst();
        mouseY = (Integer)scaleMouse.getSecond();
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        if (this.cart != null) {
            this.renderEntity(graphics, this.cart, partialTick, 30.0f, new Vec3((double)(this.leftPos + 30), (double)(this.topPos + 45), 0.0), new Vec3(-20.5, -45.0, -22.5));
        }
        pose.m_85836_();
        pose.m_252880_((float)(this.f_96543_ / 2), (float)(this.topPos + 4), 100.0f);
        float textScale = 0.85f;
        pose.m_85841_(textScale, textScale, textScale);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"Welcome to the Minecraft Store!"), 0, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_((float)(this.leftPos + 68), (float)(this.topPos + 25), 100.0f);
        textScale = 0.45f;
        pose.m_85841_(textScale, textScale, textScale);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"Your Cart!"), 0, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        pose.m_85849_();
        Vec3 staticCurrencyRot = this.f_96541_.m_91291_().m_174264_(StoreScreen.getCurrency(), (Level)this.f_96541_.f_91073_, null, 0).m_7539_() ? new Vec3(20.0, 20.0, -8.0) : new Vec3(0.0, 0.0, 0.0);
        this.renderCurrency(graphics, StoreScreen.getCurrency(), 2.6f, new Vec3((double)(this.leftPos + 74), (double)(this.topPos + 48), 0.0), staticCurrencyRot);
        pose.m_85836_();
        pose.m_252880_((float)(this.leftPos + 71), (float)(this.topPos + 46), 100.0f);
        textScale = 0.75f;
        pose.m_85841_(textScale, textScale, textScale);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)String.valueOf(this.totalCost)), 0, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        pose.m_85849_();
        this.renderCurrency(graphics, StoreScreen.getCurrency(), 1.6f, new Vec3((double)(this.leftPos + 128), (double)(this.topPos + 26), 0.0), staticCurrencyRot);
        pose.m_85836_();
        pose.m_252880_((float)(this.leftPos + 90), (float)(this.topPos + 25), 100.0f);
        textScale = 0.4f;
        pose.m_85841_(textScale, textScale, textScale);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"Your Balance!"), 10, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)String.valueOf(this.balance)), 96, 7, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        pose.m_85849_();
        pose.m_85849_();
    }

    float calculateScale() {
        return Math.max((float)this.f_96543_ / 427.0f, (float)this.f_96544_ / 240.0f);
    }

    Pair<Double, Double> scaleMouse(double mouseX, double mouseY) {
        float scale = this.calculateScale();
        mouseX = (mouseX - (double)((float)this.f_96543_ / 2.0f)) / (double)scale + (double)((float)this.f_96543_ / 2.0f);
        mouseY = (mouseY - (double)((float)this.f_96544_ / 2.0f)) / (double)scale + (double)((float)this.f_96544_ / 2.0f);
        return Pair.of((Object)mouseX, (Object)mouseY);
    }

    Pair<Integer, Integer> scaleMouse(int mouseX, int mouseY) {
        Pair<Double, Double> scaled = this.scaleMouse((double)mouseX, (double)mouseY);
        return scaled.mapFirst(Double::intValue).mapSecond(Double::intValue);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(graphics);
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        int imageWidth = 256;
        graphics.m_280163_(GUI, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, imageWidth, imageWidth);
        if (dyedPlanks) {
            int colorSpeed = 25;
            int tickDiv = this.tick / colorSpeed;
            int dyeLength = DyeColor.values().length;
            int color = tickDiv % dyeLength;
            int nextColor = (tickDiv + 1) % dyeLength;
            float f3 = ((float)(this.tick % colorSpeed) + partialTick) / (float)colorSpeed;
            float[] colorVals = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)color));
            float[] nextColorVals = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)nextColor));
            float r = colorVals[0] * (1.0f - f3) + nextColorVals[0] * f3;
            float g = colorVals[1] * (1.0f - f3) + nextColorVals[1] * f3;
            float b = colorVals[2] * (1.0f - f3) + nextColorVals[2] * f3;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            graphics.m_280163_(GUI_OVERLAY, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, imageWidth, imageWidth);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Pair<Double, Double> scaleMouse = this.scaleMouse(mouseX, mouseY);
        mouseX = (Double)scaleMouse.getFirst();
        mouseY = (Double)scaleMouse.getSecond();
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        Pair<Double, Double> scaleMouse = this.scaleMouse(mouseX, mouseY);
        mouseX = (Double)scaleMouse.getFirst();
        mouseY = (Double)scaleMouse.getSecond();
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    public void renderEntity(GuiGraphics graphics, Entity entity, float partialTick, float scale, Vec3 translate, Vec3 rotation) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_85837_(translate.f_82479_, translate.f_82480_, translate.f_82481_ + 50.0);
        pose.m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        pose.m_252781_(Axis.f_252436_.m_252977_((float)rotation.f_82480_));
        pose.m_252781_(Axis.f_252403_.m_252977_((float)rotation.f_82481_ + 180.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_((float)rotation.f_82479_));
        Lighting.m_166384_();
        this.f_96541_.m_91290_().m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, pose, (MultiBufferSource)graphics.m_280091_(), LightTexture.m_109885_((int)15, (int)15));
        graphics.m_280262_();
        Lighting.m_84931_();
        pose.m_85849_();
    }

    public void renderCurrency(GuiGraphics graphics, ItemStack stack, float scale, Vec3 translate, Vec3 rotation) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_85837_(translate.f_82479_, translate.f_82480_, translate.f_82481_ + 50.0);
        pose.m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        pose.m_85841_(16.0f, 16.0f, 16.0f);
        BakedModel model = this.f_96541_.m_91291_().m_174264_(stack, (Level)this.f_96541_.f_91073_, null, 0);
        pose.m_252781_(Axis.f_252436_.m_252977_((float)rotation.f_82480_ - 180.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_((float)rotation.f_82481_ - 180.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_((float)rotation.f_82479_));
        Lighting.m_166384_();
        this.f_96541_.m_91291_().m_115143_(stack, ItemDisplayContext.GROUND, false, pose, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
        graphics.m_280262_();
        Lighting.m_84931_();
        pose.m_85849_();
    }

    public static void blitSprite(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height) {
        texture = texture.m_246208_("textures/gui/").m_266382_(".png");
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    class CheckoutButton
    extends Button {
        public CheckoutButton(int pX, int pY, int pWidth, int pHeight, Button.OnPress pOnPress) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237113_((String)"Proceed to Checkout"), pOnPress, f_252438_);
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            boolean canPurchase = this.parent().totalCost <= this.parent().balance;
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)(this.m_252754_() + 4), (float)(this.m_252907_() + this.f_93619_ / 2), 100.0f);
            float textScale = 0.4f;
            pose.m_85841_(textScale, textScale, textScale);
            MutableComponent text = Component.m_237113_((String)"Proceed To Checkout! >");
            if (!canPurchase) {
                text = text.m_130940_(ChatFormatting.STRIKETHROUGH);
            } else if (this.m_274382_() && this.m_142518_()) {
                text = text.m_130940_(ChatFormatting.UNDERLINE);
            }
            graphics.m_280430_(this.parent().f_96547_, (Component)text, 0, 0, canPurchase ? FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0));
            pose.m_85849_();
        }

        StoreScreen parent() {
            return StoreScreen.this;
        }
    }

    class StoreButton
    extends Button {
        final ResourceLocation sprite;
        final WidgetSprites overlaySprites;
        final int price;
        final ItemStack currency;
        final ItemStack rtxCurrency;
        final int tickOffset;
        final String product;
        boolean isSelected;
        final Runnable onCheckout;

        public StoreButton(int x, int y, String sprite, String product, int price, Runnable onCheckout) {
            this(x, y, sprite, product, Items.f_42616_, Items.f_42110_, price, onCheckout);
        }

        public StoreButton(int x, int y, String sprite, String product, Item currency, Item rtxCurrency, int price, Runnable onCheckout) {
            super(StoreScreen.this.leftPos + 8 + (x > 1 ? 1 : 0) + x * 33, StoreScreen.this.topPos + 82 + y * 32, 26, 26, CommonComponents.f_237098_, b -> {}, f_252438_);
            this.isSelected = false;
            this.sprite = RediscoveredMod.locate("store/" + sprite);
            ResourceLocation base = RediscoveredMod.locate("store/store_button");
            ResourceLocation highlight = base.m_266382_("_highlighted");
            this.overlaySprites = new WidgetSprites(base, highlight);
            this.product = product;
            this.price = price;
            this.currency = currency.m_7968_();
            this.rtxCurrency = rtxCurrency.m_7968_();
            this.tickOffset = ((StoreScreen)StoreScreen.this).f_96541_.f_91073_.f_46441_.m_188503_(360);
            this.onCheckout = onCheckout;
        }

        StoreButton inactive() {
            this.f_93623_ = false;
            return this;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            PoseStack pose = graphics.m_280168_();
            RenderSystem.enableBlend();
            StoreScreen.blitSprite(graphics, this.sprite, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
            ResourceLocation overlay = this.overlaySprites.get(this.m_274382_() || this.isSelected);
            StoreScreen.blitSprite(graphics, overlay, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
            RenderSystem.disableBlend();
            double tick = (float)(this.parent().tick + this.tickOffset) + partialTick;
            this.parent().renderCurrency(graphics, rtxOn ? this.rtxCurrency : this.currency, 2.0f, new Vec3((double)(this.m_252754_() + 24), (double)(this.m_252907_() + 24) + Math.sin(tick * 0.15), 0.0), new Vec3(Math.sin(tick * 0.1) * 2.0, tick * 3.0, Math.sin(tick * 0.05) * 3.0));
            pose.m_85836_();
            pose.m_85837_((double)this.m_252754_() + 24.5, (double)(this.m_252907_() + 18) + Math.sin(tick * 0.15), 100.0);
            float priceTextScale = 0.75f;
            pose.m_85841_(priceTextScale, priceTextScale, priceTextScale);
            graphics.m_280653_(this.parent().f_96547_, (Component)Component.m_237113_((String)String.valueOf(this.price)), 0, 0, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            pose.m_85849_();
            pose.m_85836_();
            List lines = this.parent().f_96547_.m_92923_((FormattedText)Component.m_237113_((String)this.product).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))), 90);
            float productTextScale = lines.size() > 1 ? 0.28f : 0.37f;
            pose.m_85837_((double)(this.m_252754_() + 13), (double)this.m_252907_() + (lines.size() > 1 ? 26.5 : 27.5), 100.0);
            pose.m_85841_(productTextScale, productTextScale, productTextScale);
            for (int i = 0; i < lines.size(); ++i) {
                graphics.m_280364_(this.parent().f_96547_, (FormattedCharSequence)lines.get(i), 0, i * 10, this.isSelected ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)255, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            }
            pose.m_85849_();
        }

        public void m_5691_() {
            boolean bl = this.isSelected = !this.isSelected;
            this.parent().totalCost = this.isSelected ? (this.parent().totalCost += this.price) : (this.parent().totalCost -= this.price);
            super.m_5691_();
        }

        void checkout() {
            if (this.isSelected && this.m_142518_()) {
                this.onCheckout.run();
                this.parent().totalCost -= this.price;
                this.parent().balance -= this.price;
                this.isSelected = false;
            }
        }

        StoreScreen parent() {
            return StoreScreen.this;
        }
    }

    public record WidgetSprites(ResourceLocation enabled, ResourceLocation focused) {
        public ResourceLocation get(boolean focused) {
            return focused ? this.focused : this.enabled;
        }
    }

    public static class StoreOverlay {
        static final ResourceLocation FIREFLY = RediscoveredMod.locate("store/firefly");
        static final ResourceLocation FIREFLY_DARK = RediscoveredMod.locate("store/firefly_dark");
        static final ResourceLocation PADLOCK = RediscoveredMod.locate("store/locked");
        static final ResourceLocation RTX_ON = RediscoveredMod.locate("store/rtx_on_overlay");
        static Firefly[] fireflies;
        static long lastTime;

        public static void renderFirefly(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
            if (showFireflies) {
                RandomSource rand = gui.getMinecraft().f_91073_.f_46441_;
                if (fireflies == null) {
                    int count = 32;
                    fireflies = new Firefly[count];
                    for (int i = 0; i < count; ++i) {
                        StoreOverlay.fireflies[i] = new Firefly(screenWidth, screenHeight, rand);
                    }
                    lastTime = System.currentTimeMillis();
                }
                long time = System.currentTimeMillis();
                float deltaSecond = (float)(time - lastTime) / 1000.0f;
                for (Firefly f : fireflies) {
                    f.render(graphics, rand, time, deltaSecond, screenWidth, screenHeight);
                }
                lastTime = time;
            } else if (fireflies != null) {
                fireflies = null;
            }
        }

        public static void renderLock(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
            if (showLock) {
                int scale = 2;
                int padlockSize = 26 * scale;
                PoseStack pose = graphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_((float)(screenWidth / 2 - padlockSize / 2), (float)(screenHeight / 2 - padlockSize / 2 - 10), 0.0f);
                StoreScreen.blitSprite(graphics, PADLOCK, 0, 0, padlockSize, padlockSize);
                pose.m_85849_();
            }
        }

        public static void renderRtx(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
            if (rtxOn) {
                int scale = 1;
                int rtxWidth = 118 * scale;
                int rtxHeight = 40 * scale;
                PoseStack pose = graphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_(10.0f, 10.0f, 0.0f);
                StoreScreen.blitSprite(graphics, RTX_ON, 0, 0, rtxWidth, rtxHeight);
                pose.m_85849_();
            }
        }

        static {
            lastTime = 0L;
        }

        static final class Firefly {
            float x;
            float y;
            float vx;
            float vy;
            long lastCalc;
            long nextCalc;
            int scale;
            int seed;

            Firefly(int screenWidth, int screenHeight, RandomSource rand) {
                this.scale = 5 + rand.m_188503_(6);
                this.x = screenWidth / 2;
                this.y = screenHeight / 2;
                this.seed = rand.m_188503_(360);
                this.generateNewVelocity(rand);
            }

            void generateNewVelocity(RandomSource rand) {
                float maxSpeed = 30.0f;
                this.vx = (rand.m_188501_() - 0.5f) * 2.0f * maxSpeed;
                this.vy = (rand.m_188501_() - 0.5f) * 2.0f * maxSpeed;
                this.lastCalc = System.currentTimeMillis();
                this.nextCalc = this.lastCalc + (long)rand.m_188503_(2000);
            }

            void render(GuiGraphics graphics, RandomSource rand, long time, float deltaSecond, int screenWidth, int screenHeight) {
                int width = 2 * this.scale;
                int height = 1 * this.scale;
                this.x = Mth.m_14036_((float)(this.x + (float)screenWidth * this.vx / 427.0f * deltaSecond), (float)0.0f, (float)(screenWidth - width));
                this.y = Mth.m_14036_((float)(this.y + (float)screenHeight * this.vy / 240.0f * deltaSecond), (float)0.0f, (float)(screenHeight - height));
                PoseStack pose = graphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_(this.x, this.y, 0.0f);
                StoreScreen.blitSprite(graphics, FIREFLY_DARK, 0, 0, width, height);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Mth.m_14008_((double)(Math.sin((double)time * 0.001 + (double)this.seed) + 0.5), (double)0.0, (double)1.0)));
                StoreScreen.blitSprite(graphics, FIREFLY, 0, 0, width, height);
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                pose.m_85849_();
                if (time >= this.nextCalc) {
                    this.generateNewVelocity(rand);
                }
            }
        }
    }
}

