/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class RedDragonOverlay {
    private static final ResourceLocation DRAGON_STAMINA_BAR_TEXTURES = RediscoveredMod.locate("textures/gui/dragon_stamina_bars.png");
    private static float lastStamina = 1.0f;
    private static boolean isDecreasing = true;

    public static void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        RedDragonOffspringEntity dragon;
        Entity entity;
        if (!gui.getMinecraft().f_91066_.f_92062_ && (entity = gui.getMinecraft().f_91074_.m_20202_()) instanceof RedDragonOffspringEntity && (dragon = (RedDragonOffspringEntity)entity).m_269323_() == gui.getMinecraft().f_91074_) {
            if (RediscoveredConfig.WORLD.redDragonStamina()) {
                gui.setupOverlayRenderState(true, false);
                float stamina = dragon.lerpedStamina(partialTicks);
                int width = (int)(stamina * 182.0f);
                int y = screenHeight - 32 + 3;
                int x = screenWidth / 2 - 91;
                int barOffset = 0;
                graphics.m_280218_(DRAGON_STAMINA_BAR_TEXTURES, x, y, 0, barOffset, 182, 5);
                if (width > 0) {
                    if (stamina > lastStamina) {
                        isDecreasing = false;
                    } else if (stamina < lastStamina) {
                        isDecreasing = true;
                    }
                    int bar = isDecreasing ? (stamina < 0.1f ? 15 : (stamina < 0.2f ? 10 : 5)) : (dragon.isTired() ? 15 : 5);
                    graphics.m_280218_(DRAGON_STAMINA_BAR_TEXTURES, x, y, 0, barOffset + bar, width, 5);
                }
                if (lastStamina != stamina) {
                    lastStamina = stamina;
                }
            }
        } else {
            lastStamina = 1.0f;
        }
    }
}

