/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.gui.ClientQuiverTooltip;
import com.legacy.rediscovered.item.util.QuiverData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class QuiverOverlay {
    private static final ResourceLocation TEXTURE = RediscoveredMod.locate("textures/gui/quiver_overlay.png");
    private static long openTime = 0L;
    private static long closeTime = 0L;
    private static boolean wasHoldingBow = false;
    private static long currentProjectileStart = 0L;
    private static long currentProjectileEnd = 0L;

    public static void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Pair<InteractionHand, ItemStack> heldBow;
        Optional<QuiverData> quiverData;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && !mc.f_91066_.f_92062_ && (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen) && (quiverData = QuiverData.getFromChestplate(mc.f_91074_.m_6844_(EquipmentSlot.CHEST))).isPresent() && !QuiverData.isHoldingAmmo((LivingEntity)mc.f_91074_, (ItemStack)(heldBow = QuiverData.getHeldBow((LivingEntity)mc.f_91074_)).getSecond())) {
            boolean isHoldingBow;
            long currentTime = System.currentTimeMillis();
            boolean bl = isHoldingBow = !((ItemStack)heldBow.getSecond()).m_41619_();
            if (isHoldingBow && !wasHoldingBow) {
                if (currentTime >= currentProjectileEnd) {
                    currentProjectileStart = currentTime;
                }
                currentProjectileEnd = currentTime + 1500L;
            }
            if (!isHoldingBow && wasHoldingBow) {
                currentProjectileEnd = currentTime;
                closeTime = currentTime;
            }
            long projectileTime = currentTime - currentProjectileStart;
            int maxProjectileDuration = (int)(currentProjectileEnd - currentProjectileStart);
            if (projectileTime > 100L && projectileTime <= (long)maxProjectileDuration) {
                int fadeOutStart;
                ItemStack selectedArrow = quiverData.get().getSelectedAmmo((ItemStack)heldBow.getSecond());
                int x = screenWidth / 2 + 10;
                int y = screenHeight / 2 + 10;
                RenderSystem.enableBlend();
                float alpha = 1.0f;
                int fadeInDuration = 75;
                if (projectileTime <= (long)fadeInDuration) {
                    alpha = (float)projectileTime / (float)fadeInDuration;
                }
                if (projectileTime >= (long)(fadeOutStart = maxProjectileDuration - 500)) {
                    alpha = 1.0f - (float)(projectileTime - (long)fadeOutStart) / ((float)maxProjectileDuration - (float)fadeOutStart);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.75f));
                graphics.m_280480_(selectedArrow, x, y);
                graphics.m_280370_(gui.m_93082_(), selectedArrow, x, y);
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            wasHoldingBow = isHoldingBow;
            long time = currentTime - openTime;
            int maxDuration = (int)(closeTime - openTime);
            if (time <= (long)maxDuration) {
                int n;
                ItemStack quiver;
                Item item;
                int fadeOutStart;
                int x = screenWidth / 2 - 46;
                int y = screenHeight / 2 + 40;
                float alpha = 1.0f;
                int fadeInDuration = 75;
                if (time <= (long)fadeInDuration) {
                    alpha = (float)time / (float)fadeInDuration;
                }
                if (time >= (long)(fadeOutStart = maxDuration - 500)) {
                    alpha = 1.0f - (float)(time - (long)fadeOutStart) / ((float)maxDuration - (float)fadeOutStart);
                }
                if ((item = (quiver = quiverData.get().getQuiver()).m_41720_()) instanceof DyeableLeatherItem) {
                    DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
                    n = dyeable.m_41121_(quiver);
                } else {
                    n = 14444608;
                }
                int color = n;
                ClientQuiverTooltip.render(gui.m_93082_(), x, y, graphics, TEXTURE, quiverData.get(), color, alpha);
            }
        }
    }

    public static void setAccessed() {
        long time = System.currentTimeMillis();
        if (time >= closeTime) {
            openTime = time;
        }
        closeTime = time + 1500L;
        if (time >= currentProjectileEnd) {
            currentProjectileStart = time;
        }
        currentProjectileEnd = time + 1500L;
    }
}

