/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.registry.RediscoveredMenuType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class QuiverMenu
extends AbstractContainerMenu {
    private final QuiverContainer quiverContainer;

    public QuiverMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ItemStack.f_41583_, new QuiverData().setQuiver(ItemStack.f_41583_));
    }

    public QuiverMenu(int id, Inventory playerInventory, ItemStack ownerStack, QuiverData quiverData) {
        super((MenuType)RediscoveredMenuType.QUIVER.get(), id);
        this.quiverContainer = new QuiverContainer(ownerStack, quiverData);
        QuiverMenu.m_38869_((Container)this.quiverContainer, (int)5);
        this.quiverContainer.m_5856_(playerInventory.f_35978_);
        for (int j = 0; j < 5; ++j) {
            this.m_38897_(new ArrowSlot((Container)this.quiverContainer, j, 44 + j * 18, 20));
        }
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)playerInventory, k + l * 9 + 9, 8 + k * 18, l * 18 + 51));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 109));
        }
    }

    public boolean m_6875_(Player player) {
        return this.quiverContainer.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.quiverContainer.m_6643_() ? !this.m_38903_(itemstack1, this.quiverContainer.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.quiverContainer.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.quiverContainer.m_5785_(player);
    }

    private static class QuiverContainer
    extends SimpleContainer {
        private final ItemStack ownerStack;
        private final QuiverData data;

        public QuiverContainer(ItemStack ownerStack, QuiverData data) {
            super((ItemStack[])data.getAmmo().toArray(ItemStack[]::new));
            this.ownerStack = ownerStack;
            this.data = data;
        }

        public void m_5785_(Player player) {
            this.save();
        }

        public void save() {
            this.data.injectData((NonNullList<ItemStack>)this.f_19147_);
        }

        public boolean m_6542_(Player player) {
            return !this.ownerStack.m_41619_() && player.m_150109_().m_36063_(this.ownerStack);
        }
    }

    private class ArrowSlot
    extends Slot {
        public ArrowSlot(Container container, int slotID, int x, int y) {
            super(container, slotID, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(RediscoveredTags.Items.QUIVER_AMMO);
        }

        public void m_6654_() {
            super.m_6654_();
            QuiverMenu.this.quiverContainer.save();
        }
    }

    public static class Provider
    implements MenuProvider {
        private final ItemStack stack;
        private final QuiverData quiverData;
        private final Component displayName;

        public Provider(ItemStack stack, QuiverData quiverData) {
            this.stack = stack;
            this.quiverData = quiverData;
            this.displayName = AttachedItem.get(stack).map(a -> a.getAttached().m_41786_()).orElseGet(() -> stack.m_41786_());
        }

        public AbstractContainerMenu m_7208_(int containerID, Inventory playerInventory, Player player) {
            return new QuiverMenu(containerID, playerInventory, this.stack, this.quiverData);
        }

        public Component m_5446_() {
            return this.displayName;
        }
    }
}

