/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.gui.GuardPigmanInventoryMenu;
import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import com.legacy.rediscovered.entity.util.IPigman;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuardPigmanInventoryScreen
extends AbstractContainerScreen<GuardPigmanInventoryMenu> {
    public static final String START_GUARD_KEY = GuardPigmanInventoryScreen.key("start_guarding");
    public static final String STOP_GUARD_KEY = GuardPigmanInventoryScreen.key("stop_guarding");
    public static final String GUARDING_STATUS_KEY = GuardPigmanInventoryScreen.key("guarding_status");
    public static final String SEARCHING_STATUS_KEY = GuardPigmanInventoryScreen.key("searching_status");
    public static final String IDLE_STATUS_KEY = GuardPigmanInventoryScreen.key("idle_status");
    private static final ResourceLocation GUARD_PIGMAN_TEXTURE = RediscoveredMod.locate("textures/gui/guard_pigman.png");
    private static final List<ResourceLocation> EMPTY_SLOTS_MELEE = List.of(new ResourceLocation("item/empty_slot_sword"), new ResourceLocation("item/empty_slot_axe"));
    private static final List<ResourceLocation> EMPTY_SLOTS_MELEE_OFFHAND = List.of(InventoryMenu.f_39697_);
    private static final List<ResourceLocation> EMPTY_SLOTS_RANGED = List.of(RediscoveredMod.locate("item/empty_slot_bow"), RediscoveredMod.locate("item/empty_slot_crossbow"));
    private static final List<ResourceLocation> EMPTY_SLOTS_RANGED_OFFHAND = List.of(RediscoveredMod.locate("item/empty_slot_arrow"));
    private final GuardPigmanEntity pigman;
    private Button startGuardingButton;
    private Button stopGuardingButton;
    private float mousePosX;
    private float mousePosY;
    private final CyclingSlotBackground mainHandIcon = new CyclingSlotBackground(36);
    private final CyclingSlotBackground offHandIcon = new CyclingSlotBackground(37);

    public GuardPigmanInventoryScreen(GuardPigmanInventoryMenu container, Inventory playerInv, Component text) {
        super((AbstractContainerMenu)container, playerInv, container.pigman.m_5446_());
        this.pigman = container.pigman;
        this.f_97727_ += 20;
        this.f_97731_ += 20;
    }

    protected void m_181908_() {
        super.m_181908_();
        IPigman.Type type = this.pigman.getPigmanType();
        this.mainHandIcon.m_266287_(type == IPigman.Type.MELEE ? EMPTY_SLOTS_MELEE : (type == IPigman.Type.RANGED ? EMPTY_SLOTS_RANGED : List.of()));
        this.offHandIcon.m_266287_(type == IPigman.Type.MELEE ? EMPTY_SLOTS_MELEE_OFFHAND : (type == IPigman.Type.RANGED ? EMPTY_SLOTS_RANGED_OFFHAND : List.of()));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.startGuardingButton = new ImageButton(this.f_97735_ + ((GuardPigmanInventoryMenu)this.f_97732_).rubySlot.f_40220_ + 21, this.f_97736_ + ((GuardPigmanInventoryMenu)this.f_97732_).rubySlot.f_40221_ - 2, 20, 19, 178, 0, GUARD_PIGMAN_TEXTURE, b -> {
            this.sendButtonClick((byte)0);
            this.toggleActionButtons(true);
        });
        this.startGuardingButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)START_GUARD_KEY)));
        this.m_142416_((GuiEventListener)this.startGuardingButton);
        this.stopGuardingButton = new ImageButton(this.startGuardingButton.m_252754_(), this.startGuardingButton.m_252907_(), this.startGuardingButton.m_5711_(), this.startGuardingButton.m_93694_(), 198, 0, GUARD_PIGMAN_TEXTURE, b -> {
            this.sendButtonClick((byte)1);
            this.toggleActionButtons(false);
        });
        this.stopGuardingButton.f_93623_ = this.pigman.getGuardedUUID().isPresent() && this.pigman.getGuardedUUID().get().equals(this.f_96541_.f_91074_.m_20148_());
        this.stopGuardingButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)STOP_GUARD_KEY)));
        this.m_142416_((GuiEventListener)this.stopGuardingButton);
        this.toggleActionButtons(false);
    }

    private void toggleActionButtons(boolean setGuarding) {
        this.stopGuardingButton.f_93624_ = setGuarding;
        this.startGuardingButton.f_93624_ = !setGuarding;
        this.stopGuardingButton.f_93623_ = this.pigman.getGuardedUUID().isPresent() && this.pigman.getGuardedUUID().get().equals(this.f_96541_.f_91074_.m_20148_());
    }

    private void sendButtonClick(byte data) {
        this.f_96541_.f_91072_.m_105208_(((GuardPigmanInventoryMenu)this.f_97732_).f_38840_, (int)data);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(GUARD_PIGMAN_TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.renderHealth(graphics, x, y, partialTicks);
        this.mainHandIcon.m_266270_(this.f_97732_, graphics, partialTicks, this.f_97735_, this.f_97736_);
        this.offHandIcon.m_266270_(this.f_97732_, graphics, partialTicks, this.f_97735_, this.f_97736_);
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(i + 51), (int)(j + 84), (int)30, (float)((float)(i + 51) - this.mousePosX), (float)((float)(j + 75 - 50) - this.mousePosY), (LivingEntity)this.pigman);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.startGuardingButton.f_93623_ = ((GuardPigmanInventoryMenu)this.f_97732_).rubySlot.m_6657_();
        this.toggleActionButtons(this.pigman.getGuardedUUID().isPresent());
        this.m_280273_(graphics);
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int l = this.f_97735_;
        int t = this.f_97736_;
        int statusLabelX = l + ((GuardPigmanInventoryMenu)this.f_97732_).rubySlot.f_40220_ + 20;
        int statusLabelY = t + ((GuardPigmanInventoryMenu)this.f_97732_).rubySlot.f_40221_ + 26;
        int color = this.pigman.getGuardedUUID().isPresent() ? ChatFormatting.GREEN.m_126665_() : (this.pigman.isDismissedUnsafely() ? ChatFormatting.GOLD.m_126665_() : ChatFormatting.AQUA.m_126665_());
        MutableComponent statusText = Component.m_237115_((String)(this.pigman.getGuardedUUID().isPresent() ? GUARDING_STATUS_KEY : (this.pigman.isDismissedUnsafely() ? SEARCHING_STATUS_KEY : IDLE_STATUS_KEY)));
        int statusOffset = 32;
        this.renderScrolling(graphics, (Component)statusText, statusLabelX - statusOffset, statusLabelY, statusLabelX - statusOffset + 54 + 10, statusLabelY + 10, color);
        if (this.pigman.getGuardedUUID().isPresent()) {
            MutableComponent timeText = Component.m_237113_((String)GuardPigmanInventoryScreen.millisToDate((this.pigman.timeToBodyguard() + 1L) * 1000L - (this.pigman.m_9236_().m_46467_() - this.pigman.getTimePaid()) * 50L));
            graphics.m_280614_(this.f_96547_, (Component)timeText, statusLabelX - this.f_96547_.m_92895_(timeText.getString()) / 2, statusLabelY + 12, 0xE0E0E0, false);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderScrolling(GuiGraphics pGuiGraphics, Component pText, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor) {
        int i = this.f_96547_.m_92852_((FormattedText)pText);
        int j = (pMinY + pMaxY - 9) / 2 + 1;
        int k = pMaxX - pMinX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.m_137550_() / 400.0;
            double d1 = Math.max((double)l * 0.5, 2.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            pGuiGraphics.m_280588_(pMinX, pMinY, pMaxX, pMaxY);
            pGuiGraphics.m_280430_(this.f_96547_, pText, pMinX - (int)d3, j, pColor);
            pGuiGraphics.m_280618_();
        } else {
            pGuiGraphics.m_280653_(this.f_96547_, pText, (pMinX + pMaxX) / 2, j, pColor);
        }
    }

    private void renderHealth(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float health = this.pigman.m_21223_() / this.pigman.m_21233_();
        int width = (int)(health * 81.0f);
        int y = this.f_97736_ + 23;
        int x = this.f_97735_ + 79 + 10;
        graphics.m_280218_(GUARD_PIGMAN_TEXTURE, x - 10, y - 2, 0, 198, 9, 9);
        graphics.m_280218_(GUARD_PIGMAN_TEXTURE, x, y, 0, 187, 81, 5);
        if (width > 0) {
            graphics.m_280218_(GUARD_PIGMAN_TEXTURE, x, y, 0, 192, width, 5);
        }
    }

    public static String millisToDate(long milliseconds) {
        Date date = new Date(milliseconds);
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        return sdf.format(date);
    }

    private static String key(String key) {
        return "gui.rediscovered.guard_pigman." + key;
    }
}

