/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import com.legacy.rediscovered.registry.RediscoveredMenuType;
import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class GuardPigmanInventoryMenu
extends AbstractContainerMenu {
    public static final int TOP_MARGIN = 10;
    public static final int BOTTOM_MARGIN = 10;
    public static final int TOTAL_MARGIN = 20;
    public static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = new ResourceLocation("item/empty_armor_slot_shield");
    public static final ResourceLocation EMPTY_SLOT_RUBY = RediscoveredMod.locate("item/empty_slot_ruby");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    private final Inventory playerInventory;
    private final Container pigmanInventory;
    private final Container rubyInventory;
    public final Slot rubySlot;
    public final GuardPigmanEntity pigman;

    public GuardPigmanInventoryMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, (GuardPigmanEntity)playerInventory.f_35978_.m_9236_().m_6815_(buffer.readInt()));
    }

    public GuardPigmanInventoryMenu(int id, Inventory playerInventory, final GuardPigmanEntity pigman) {
        super((MenuType)RediscoveredMenuType.GUARD_PIGMAN_INVENTORY.get(), id);
        this.pigman = pigman;
        this.pigmanInventory = pigman.m_35311_();
        this.playerInventory = playerInventory;
        this.rubyInventory = new SimpleContainer(1);
        this.playerInventory.m_5856_(playerInventory.f_35978_);
        this.pigmanInventory.m_5856_(playerInventory.f_35978_);
        this.rubyInventory.m_5856_(playerInventory.f_35978_);
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 162));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + (y + 1) * 9, 8 + x * 18, 20 + (84 + y * 18)));
            }
        }
        this.m_38897_(new Slot(this.pigmanInventory, 0, 77, 54){

            public boolean m_5857_(ItemStack stack) {
                return pigman.isValidHandEquip(stack);
            }
        });
        this.m_38897_(new Slot(this.pigmanInventory, 1, 77, 72){

            public boolean m_5857_(ItemStack stack) {
                return pigman.isValidOffHandEquip(stack);
            }
        });
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.m_38897_(new Slot(this.pigmanInventory, 2 + k, 8, 10 + (8 + k * -18) + 54){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(equipmentslot, (Entity)pigman);
                }

                public boolean m_8010_(Player player) {
                    ItemStack itemstack = this.m_7993_();
                    return !itemstack.m_41619_() && !player.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack) ? false : super.m_8010_(player);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                }
            });
        }
        this.rubySlot = this.m_38897_(new Slot(this.rubyInventory, 0, 116, 36){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(RediscoveredTags.Items.GEMS_RUBY) && !pigman.m_6162_();
            }

            public int m_6641_() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_SLOT_RUBY);
            }
        });
    }

    public boolean m_6875_(Player playerIn) {
        return this.pigmanInventory.m_6542_(playerIn) && this.pigman.m_6084_() && this.pigman.m_20270_((Entity)playerIn) < 8.0f && this.pigman.isPlayerCured();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if ((index < 36 || index > 42) && this.m_38903_(slotStack, 36, 43, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 0 && index <= 8 ? !this.m_38903_(slotStack, 9, 36, false) : (index >= 9 && index <= 35 ? !this.m_38903_(slotStack, 0, 9, false) : index >= 36 && index <= 42 && !this.m_38903_(slotStack, 0, 36, true))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == clickedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return clickedStack;
    }

    public boolean m_6366_(Player player, int id) {
        switch (id) {
            case 0: {
                if (this.rubySlot.m_6657_()) {
                    this.rubySlot.m_6201_(1);
                    this.pigman.hireAsBodyguard(player.m_20148_());
                    return true;
                }
                return false;
            }
            case 1: {
                if (this.pigman.getGuardedUUID().isPresent() && this.pigman.getGuardedUUID().get().equals(this.playerInventory.f_35978_.m_20148_())) {
                    this.pigman.dismissBodyguard();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.pigmanInventory.m_5785_(player);
        this.playerInventory.m_5785_(player);
        this.rubyInventory.m_5785_(player);
        if (!player.m_9236_().m_5776_()) {
            this.m_150411_(player, this.rubyInventory);
        }
    }
}

