/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.item.DragonArmorItem;
import com.legacy.rediscovered.registry.RediscoveredMenuType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DragonInventoryMenu
extends AbstractContainerMenu {
    private final Container dragonInventory;
    private final Container playerInventory;
    public final RedDragonOffspringEntity mount;

    public DragonInventoryMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, (RedDragonOffspringEntity)playerInventory.f_35978_.m_9236_().m_6815_(buffer.readInt()));
    }

    public DragonInventoryMenu(int id, final Inventory playerInventory, final RedDragonOffspringEntity mount) {
        super((MenuType)RediscoveredMenuType.DRAGON_INVENTORY.get(), id);
        this.mount = mount;
        this.dragonInventory = mount.getDragonInventory();
        this.playerInventory = playerInventory;
        this.playerInventory.m_5856_(playerInventory.f_35978_);
        this.dragonInventory.m_5856_(playerInventory.f_35978_);
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + (y + 1) * 9, 8 + x * 18, 84 + y * 18));
            }
        }
        this.m_38897_(new Slot(this.dragonInventory, 0, 8, 18){

            public boolean m_5857_(ItemStack stack) {
                return !mount.m_6162_() && stack.m_150930_(Items.f_42450_) && !this.m_6657_() && playerInventory.f_35978_ == mount.m_269323_();
            }

            public boolean m_8010_(Player pPlayer) {
                return pPlayer == mount.m_269323_();
            }

            @OnlyIn(value=Dist.CLIENT)
            public boolean m_6659_() {
                return mount.m_21824_() && mount.m_6741_();
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.dragonInventory, 1, 8, 36){

            public boolean m_5857_(ItemStack armor) {
                return !mount.m_6162_() && armor.m_41720_() instanceof DragonArmorItem && armor != this.m_7993_() && playerInventory.f_35978_ == mount.m_269323_();
            }

            public boolean m_8010_(Player pPlayer) {
                return pPlayer == mount.m_269323_();
            }

            public boolean m_6659_() {
                return mount.m_21824_() && mount.m_6741_();
            }

            public int m_6641_() {
                return 1;
            }
        });
    }

    public boolean m_6875_(Player playerIn) {
        return this.dragonInventory.m_6542_(playerIn) && this.mount.m_6084_() && this.mount.m_20270_((Entity)playerIn) < 8.0f;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (this.m_38903_(slotStack, 36, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 0 && index <= 8 ? !this.m_38903_(slotStack, 9, 36, false) : (index >= 9 && index <= 35 ? !this.m_38903_(slotStack, 0, 9, false) : (index == 36 || index == 37) && !this.m_38903_(slotStack, 0, 36, true))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == clickedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return clickedStack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.dragonInventory.m_5785_(playerIn);
        this.playerInventory.m_5785_(playerIn);
    }
}

