/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.gui;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.item.util.QuiverTooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ClientQuiverTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation TEXTURE = RediscoveredMod.locate("textures/gui/quiver_tooltip.png");
    private static final int DARK_OVERLAY_COLOR = FastColor.ARGB32.m_13660_((int)120, (int)0, (int)0, (int)0);
    private final QuiverData data;
    private final int color;

    public ClientQuiverTooltip(QuiverTooltip tooltip) {
        this.data = tooltip.data();
        this.color = tooltip.color();
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        ClientQuiverTooltip.render(font, x, y, graphics, TEXTURE, this.data, this.color, 1.0f);
    }

    public static void render(Font font, int x, int y, GuiGraphics graphics, ResourceLocation texture, QuiverData data, int selectedSlotColor, float alpha) {
        ClientQuiverTooltip.setupTransparency(alpha);
        graphics.m_280398_(texture, x, y, 0, 0.0f, 0.0f, 92, 20, 128, 128);
        ClientQuiverTooltip.resetTransparency();
        byte selectedSlot = data.getSelectedSlot();
        int fillX = x + 2 + 18 * selectedSlot;
        int fillY = y + 2;
        ClientQuiverTooltip.setupTransparency(alpha);
        graphics.m_280509_(fillX, fillY, fillX + 16, fillY + 16, FastColor.ARGB32.m_13660_((int)128, (int)FastColor.ARGB32.m_13665_((int)selectedSlotColor), (int)FastColor.ARGB32.m_13667_((int)selectedSlotColor), (int)FastColor.ARGB32.m_13669_((int)selectedSlotColor)));
        ClientQuiverTooltip.resetTransparency();
        NonNullList<ItemStack> allAmmo = data.getAmmo();
        for (int i = 0; i < 5; ++i) {
            ItemStack ammo = (ItemStack)allAmmo.get(i);
            boolean isAmmo = ammo.m_41619_() || QuiverData.isAmmo(ammo, (ItemStack)QuiverData.getHeldBow((LivingEntity)Minecraft.m_91087_().f_91074_).getSecond());
            ClientQuiverTooltip.setupTransparency(alpha);
            int itemX = x + 2 + 18 * i;
            int itemY = y + 2;
            if (!isAmmo) {
                graphics.m_285944_(RenderType.m_286086_(), itemX, itemY, itemX + 16, itemY + 16, DARK_OVERLAY_COLOR);
            }
            graphics.m_280480_(ammo, itemX, itemY);
            graphics.m_280370_(font, ammo, itemX, itemY);
            if (!isAmmo) {
                graphics.m_285944_(RenderType.m_285811_(), itemX, itemY, itemX + 16, itemY + 16, DARK_OVERLAY_COLOR);
            }
            ClientQuiverTooltip.resetTransparency();
        }
    }

    private static void setupTransparency(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    private static void resetTransparency() {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int m_142103_() {
        return 26;
    }

    public int m_142069_(Font font) {
        return 92;
    }
}

