/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client;

import com.legacy.rediscovered.client.RediscoveredRenderRefs;
import com.legacy.rediscovered.client.render.block_entity.GearRenderer;
import com.legacy.rediscovered.client.render.block_entity.MiniDragonPylonRenderer;
import com.legacy.rediscovered.client.render.block_entity.RedDragonEggRenderer;
import com.legacy.rediscovered.client.render.block_entity.TableRenderer;
import com.legacy.rediscovered.client.render.entity.BeastBoyRenderer;
import com.legacy.rediscovered.client.render.entity.BlackSteveRenderer;
import com.legacy.rediscovered.client.render.entity.BoltBallRenderer;
import com.legacy.rediscovered.client.render.entity.FishRenderer;
import com.legacy.rediscovered.client.render.entity.MeleePigmanRenderer;
import com.legacy.rediscovered.client.render.entity.PigmanRenderer;
import com.legacy.rediscovered.client.render.entity.PurpleArrowRenderer;
import com.legacy.rediscovered.client.render.entity.PylonBurstRenderer;
import com.legacy.rediscovered.client.render.entity.RanaRenderer;
import com.legacy.rediscovered.client.render.entity.RangedPigmanRenderer;
import com.legacy.rediscovered.client.render.entity.RedDragonBossRenderer;
import com.legacy.rediscovered.client.render.entity.RedDragonOffspringRenderer;
import com.legacy.rediscovered.client.render.entity.ScarecrowRenderer;
import com.legacy.rediscovered.client.render.entity.SteveRenderer;
import com.legacy.rediscovered.client.render.entity.ThunderCloudRenderer;
import com.legacy.rediscovered.client.render.entity.ZombiePigmanRenderer;
import com.legacy.rediscovered.client.render.entity.layer.QuiverArmorLayer;
import com.legacy.rediscovered.client.render.model.DragonPylonRenderer;
import com.legacy.rediscovered.client.render.model.FishModel;
import com.legacy.rediscovered.client.render.model.GearModel;
import com.legacy.rediscovered.client.render.model.NetherReactorPulseModel;
import com.legacy.rediscovered.client.render.model.PigmanModel;
import com.legacy.rediscovered.client.render.model.RanaModel;
import com.legacy.rediscovered.client.render.model.RedDragonModel;
import com.legacy.rediscovered.client.render.model.ScarecrowModel;
import com.legacy.rediscovered.client.render.model.SteveModel;
import com.legacy.rediscovered.client.render.model.ThunderCloudModel;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rediscovered", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RediscoveredEntityRendering {
    @SubscribeEvent
    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CubeDeformation fullDeform = new CubeDeformation(1.0f);
        CubeDeformation halfDeform = new CubeDeformation(0.5f);
        LayerDefinition pigmanBodyLayer = PigmanModel.createBodyLayer(CubeDeformation.f_171458_);
        LayerDefinition zombieProfessionLayer = PigmanModel.createBodyLayer(halfDeform);
        LayerDefinition outerArmor = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)fullDeform), (int)64, (int)32);
        LayerDefinition innerArmor = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)halfDeform), (int)64, (int)32);
        event.registerLayerDefinition(RediscoveredRenderRefs.QUIVER, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(1.1f)), (int)64, (int)32));
        event.registerLayerDefinition(RediscoveredRenderRefs.PIGMAN, () -> pigmanBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.PIGMAN_INNER_ARMOR, () -> innerArmor);
        event.registerLayerDefinition(RediscoveredRenderRefs.PIGMAN_OUTER_ARMOR, () -> outerArmor);
        event.registerLayerDefinition(RediscoveredRenderRefs.ZOMBIE_PIGMAN, () -> pigmanBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.ZOMBIE_PIGMAN_PROFESSION, () -> zombieProfessionLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.FISH, FishModel::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.SCARECROW, ScarecrowModel::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.GEAR, GearModel::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.STEVE, SteveModel::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.RANA, RanaModel::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.RED_DRAGON, () -> RedDragonModel.createBodyLayer(CubeDeformation.f_171458_, CubeDeformation.f_171458_));
        event.registerLayerDefinition(RediscoveredRenderRefs.RED_DRAGON_ARMOR, () -> RedDragonModel.createBodyLayer(new CubeDeformation(0.3f), new CubeDeformation(0.6f)));
        event.registerLayerDefinition(RediscoveredRenderRefs.RED_DRAGON_SADDLE, () -> RedDragonModel.createBodyLayer(new CubeDeformation(0.75f), new CubeDeformation(0.9f)));
        event.registerLayerDefinition(RediscoveredRenderRefs.DRAGON_PYLON, DragonPylonRenderer::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.BOLT_BALL_WIND, BoltBallRenderer::createWindLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.THUNDER_CLOUD, ThunderCloudModel::createBodyLayer);
        event.registerLayerDefinition(RediscoveredRenderRefs.NETHER_REACTOR_PULSE, NetherReactorPulseModel::createRingLayer);
    }

    @SubscribeEvent
    public static void initRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(RediscoveredEntityTypes.FISH, FishRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.PIGMAN, PigmanRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.MELEE_PIGMAN, MeleePigmanRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.RANGED_PIGMAN, RangedPigmanRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.ZOMBIE_PIGMAN, ZombiePigmanRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.STEVE, SteveRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.BLACK_STEVE, BlackSteveRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.BEAST_BOY, BeastBoyRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.RANA, RanaRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.RED_DRAGON_BOSS, RedDragonBossRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.RED_DRAGON_OFFSPRING, RedDragonOffspringRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.BOLT_BALL, BoltBallRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.THUNDER_CLOUD, ThunderCloudRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.DRAGON_PYLON, DragonPylonRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.PYLON_BURST, PylonBurstRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.SCARECROW, ScarecrowRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.PURPLE_ARROW, PurpleArrowRenderer::new);
        event.registerEntityRenderer(RediscoveredEntityTypes.MOUNTABLE_BLOCK, NoopRenderer::new);
        event.registerBlockEntityRenderer(RediscoveredBlockEntityTypes.GEAR, GearRenderer::new);
        event.registerBlockEntityRenderer(RediscoveredBlockEntityTypes.TABLE, TableRenderer::new);
        event.registerBlockEntityRenderer(RediscoveredBlockEntityTypes.MIN_DRAGON_PYLON, MiniDragonPylonRenderer::new);
        event.registerBlockEntityRenderer(RediscoveredBlockEntityTypes.RED_DRAGON_EGG, RedDragonEggRenderer::new);
    }

    @SubscribeEvent
    public static <T extends LivingEntity, M extends HumanoidModel<T>> void initRenders(EntityRenderersEvent.AddLayers event) {
        for (EntityRenderer renderer : Minecraft.m_91087_().m_91290_().f_114362_.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            RediscoveredEntityRendering.addQuiverLayer((EntityRenderer<? extends LivingEntity>)((LivingEntityRenderer)renderer), event.getContext());
        }
        RediscoveredEntityRendering.addQuiverLayer((EntityRenderer<? extends LivingEntity>)((EntityRenderer)Minecraft.m_91087_().m_91290_().getSkinMap().get("default")), event.getContext());
        RediscoveredEntityRendering.addQuiverLayer((EntityRenderer<? extends LivingEntity>)((EntityRenderer)Minecraft.m_91087_().m_91290_().getSkinMap().get("slim")), event.getContext());
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addQuiverLayer(EntityRenderer<? extends LivingEntity> entityRenderer, EntityRendererProvider.Context context) {
        LivingEntityRenderer living;
        if (entityRenderer instanceof LivingEntityRenderer && (living = (LivingEntityRenderer)entityRenderer).m_7200_() instanceof HumanoidModel) {
            living.m_115326_(new QuiverArmorLayer(living, context));
        }
    }
}

