/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.gui.ClientQuiverTooltip;
import com.legacy.rediscovered.client.gui.DragonInventoryScreen;
import com.legacy.rediscovered.client.gui.GuardPigmanInventoryScreen;
import com.legacy.rediscovered.client.gui.QuiverOverlay;
import com.legacy.rediscovered.client.gui.QuiverScreen;
import com.legacy.rediscovered.client.gui.RedDragonOverlay;
import com.legacy.rediscovered.client.gui.StoreScreen;
import com.legacy.rediscovered.client.item.RubyEyeClient;
import com.legacy.rediscovered.client.item.RubyFluteClient;
import com.legacy.rediscovered.client.render.world.SkylandsCloudRenderer;
import com.legacy.rediscovered.client.render.world.SkylandsSkyRenderer;
import com.legacy.rediscovered.entity.dragon.AbstractRedDragonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.item.util.QuiverTooltip;
import com.legacy.rediscovered.network.PacketHandler;
import com.legacy.rediscovered.network.c_to_s.CycleQuiverPacket;
import com.legacy.rediscovered.registry.RediscoveredArmorTrims;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.registry.RediscoveredMenuType;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.legacy.structure_gel.api.events.RegisterArmorTrimTexturesEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Matrix4f;

public class RediscoveredClientEvents {
    public static final CubeMap PANORAMA_RESOURCES = new CubeMap(RediscoveredMod.locate("textures/gui/panorama/panorama"));
    public static final ResourceLocation PANORAMA_OVERLAY = RediscoveredMod.locate("textures/gui/panorama_overlay.png");
    public static final ResourceLocation STEVE_MD3 = RediscoveredMod.locate("models/entity/steve.md3");
    public static final ResourceLocation RANA_MD3 = RediscoveredMod.locate("models/entity/mcexport01.md3");
    private static final DimensionSpecialEffects SKY_RENDER_INFO = new SkyRenderInfo();
    public static final Map<ResourceLocation, ResourceLocation> QUIVER_ITEM_MODEL_IDS = new HashMap<ResourceLocation, ResourceLocation>();
    public static final Set<UUID> ACTIVE_DRAGON_FIGHTS = new HashSet<UUID>();
    public static float dragonThunderTime;
    public static float shakeStrength;
    public static double shakeX;
    public static double shakeY;
    public static double shakeZ;
    public static Vec3 shakeVec;
    public static Vec3 shakeVecOld;

    public static boolean isAprilFools() {
        return RediscoveredClientEvents.isAprilFoolsDay() && RediscoveredConfig.CLIENT.allowAprilFools();
    }

    public static boolean isAprilFoolsDay() {
        return RediscoveredClientEvents.isDay(3, 1);
    }

    static boolean isDay(int month, int day) {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == month && calendar.get(5) == day;
    }

    static {
        shakeVec = Vec3.f_82478_;
        shakeVecOld = Vec3.f_82478_;
    }

    public static class SkyRenderInfo
    extends DimensionSpecialEffects {
        public SkyRenderInfo() {
            super(0.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        }

        public Vec3 m_5927_(Vec3 fogColor, float fogBrightness) {
            return SkylandsSkyRenderer.modifyFogColor(fogColor, fogBrightness);
        }

        public boolean m_5781_(int posX, int posZ) {
            return false;
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            SkylandsSkyRenderer.INSTANCE.render(ticks, partialTick, poseStack, level, camera, projectionMatrix, setupFog);
            return true;
        }

        public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
            if (RediscoveredConfig.CLIENT.customSkylandsClouds()) {
                SkylandsCloudRenderer.renderLayers(level, ticks, partialTick, poseStack, camX, camY, camZ, projectionMatrix);
                return true;
            }
            return super.renderClouds(level, ticks, partialTick, poseStack, camX, camY, camZ, projectionMatrix);
        }
    }

    public static class ForgeEvents {
        @SubscribeEvent
        public static void gatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
            ItemStack attached;
            Optional tooltipImage;
            ItemStack stack = event.getItemStack();
            Optional<AttachedItem> attachedItem = AttachedItem.get(stack);
            if (attachedItem.isPresent() && (tooltipImage = (attached = attachedItem.get().getAttached()).m_150921_()).isPresent()) {
                List elements = event.getTooltipElements();
                int targetIndex = 0;
                for (int i = 0; i < elements.size(); ++i) {
                    TranslatableContents translate;
                    MutableComponent mutableComponent;
                    Object object;
                    Either either = (Either)elements.get(i);
                    if (!either.left().isPresent() || !((object = either.left().get()) instanceof MutableComponent) || !((object = (mutableComponent = (MutableComponent)object).m_214077_()) instanceof TranslatableContents) || !(translate = (TranslatableContents)object).m_237508_().contains("item.modifiers.")) continue;
                    targetIndex = i;
                    break;
                }
                event.getTooltipElements().add(targetIndex, Either.right((Object)((TooltipComponent)tooltipImage.get())));
            }
        }

        @SubscribeEvent
        public static void onTooltip(ItemTooltipEvent event) {
            Potion potion = PotionUtils.m_43579_((ItemStack)event.getItemStack());
            if (potion != null) {
                List tooltips = event.getToolTip();
                int insertLine = -1;
                for (int i = tooltips.size() - 1; i > -1 && insertLine == -1; --i) {
                    if (!ForgeEvents.matchesTranslationKey((Component)tooltips.get(i), "potion.whenDrank")) continue;
                    insertLine = i + 1;
                }
                if (insertLine != -1) {
                    for (MobEffectInstance instance : potion.m_43488_()) {
                        if (instance.m_19544_() == RediscoveredEffects.GOLDEN_AURA.get()) {
                            tooltips.add(insertLine, Component.m_237115_((String)"potion.rediscovered.golden_aura_effect").m_130940_(ChatFormatting.BLUE));
                        }
                        if (instance.m_19544_() != RediscoveredEffects.CRIMSON_VEIL.get()) continue;
                        tooltips.add(insertLine, Component.m_237115_((String)"potion.rediscovered.crimson_veil_effect").m_130940_(ChatFormatting.BLUE));
                    }
                }
            }
        }

        private static boolean matchesTranslationKey(Component component, String key) {
            TranslatableContents trans;
            ComponentContents componentContents = component.m_214077_();
            return componentContents instanceof TranslatableContents && (trans = (TranslatableContents)componentContents).m_237508_().equals(key);
        }

        @SubscribeEvent
        public static void mouseClick(InputEvent.MouseButton.Post event) {
            Pair<InteractionHand, ItemStack> heldBow;
            int action;
            Minecraft mc = ForgeEvents.mc();
            if (!(mc.f_91074_ == null || (action = event.getAction()) != 1 && action != 2 || mc.f_91080_ != null || mc.f_91066_.f_92096_.getKey().m_84873_() != event.getButton() || ((ItemStack)(heldBow = QuiverData.getHeldBow((LivingEntity)mc.f_91074_)).getSecond()).m_41619_() || QuiverData.isHoldingAmmo((LivingEntity)mc.f_91074_, (ItemStack)heldBow.getSecond()) || !QuiverData.getFromChestplate(mc.f_91074_.m_6844_(EquipmentSlot.CHEST)).isPresent() || heldBow.getFirst() != InteractionHand.MAIN_HAND && !mc.f_91074_.m_6117_())) {
                QuiverOverlay.setAccessed();
                PacketHandler.sendToServer(new CycleQuiverPacket());
            }
        }

        @SubscribeEvent
        public static void onDrawHighlight(RenderHighlightEvent.Block event) {
            BlockState state = ForgeEvents.mc().f_91073_.m_8055_(event.getTarget().m_82425_());
            if (state.m_60713_(RediscoveredBlocks.mini_dragon_pylon) || state.m_60713_(RediscoveredBlocks.red_dragon_egg)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onAngleCompute(ViewportEvent.ComputeCameraAngles event) {
            Entity entity;
            CameraType camType = ForgeEvents.mc().f_91066_.m_92176_();
            Camera camera = event.getCamera();
            double pt = event.getPartialTick();
            if (shakeVec != null) {
                camera.m_90568_(camera.m_90566_(Mth.m_14139_((double)pt, (double)shakeVecOld.m_7096_(), (double)shakeVec.m_7096_())), Mth.m_14139_((double)pt, (double)shakeVecOld.m_7098_(), (double)shakeVec.m_7098_()), Mth.m_14139_((double)pt, (double)shakeVecOld.m_7094_(), (double)shakeVec.m_7094_()));
            }
            if ((entity = ForgeEvents.mc().f_91074_.m_20202_()) instanceof AbstractRedDragonEntity) {
                AbstractRedDragonEntity dragon = (AbstractRedDragonEntity)entity;
                if (camType != CameraType.FIRST_PERSON) {
                    camera.m_90568_(-camera.m_90566_(5.0), 0.0, 0.0);
                }
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.LevelTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
                ACTIVE_DRAGON_FIGHTS.removeIf(uuid -> !ForgeEvents.mc().f_91065_.m_93090_().f_93699_.keySet().contains(uuid));
                dragonThunderTime = ACTIVE_DRAGON_FIGHTS.isEmpty() ? (dragonThunderTime -= 0.02f) : (dragonThunderTime += 0.02f);
                dragonThunderTime = Mth.m_14036_((float)dragonThunderTime, (float)0.0f, (float)1.0f);
                shakeStrength = Mth.m_14036_((float)shakeStrength, (float)0.0f, (float)1.0f);
                RandomSource rand = event.level.m_213780_();
                shakeVecOld = shakeVec;
                shakeVec = new Vec3(rand.m_188583_(), rand.m_188583_(), rand.m_188583_()).m_82490_((double)shakeStrength).m_82490_((double)((float)RediscoveredConfig.CLIENT.screenShakeIntensity() * 0.01f));
                shakeStrength *= 0.7f;
            }
        }

        @SubscribeEvent
        public static void joinlevel(EntityJoinLevelEvent event) {
            if (event.getEntity() == ForgeEvents.mc().f_91074_) {
                ACTIVE_DRAGON_FIGHTS.clear();
                dragonThunderTime = 0.0f;
                shakeStrength = 0.0f;
            }
        }

        @SubscribeEvent
        public static void renderOverlayPre(RenderGuiOverlayEvent.Pre event) {
            RedDragonOffspringEntity dragon;
            Entity entity;
            ResourceLocation id = event.getOverlay().id();
            if (RediscoveredConfig.WORLD.redDragonStamina() && id.equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) && (entity = ForgeEvents.mc().f_91074_.m_20202_()) instanceof RedDragonOffspringEntity && (dragon = (RedDragonOffspringEntity)entity) != null && dragon.m_269323_() == ForgeEvents.mc().f_91074_) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void openScreen(ScreenEvent.Opening event) {
            ContainerScreen containerScreen;
            Screen screen;
            if (RediscoveredClientEvents.isAprilFools() && (screen = event.getNewScreen()) instanceof ContainerScreen && ((ChestMenu)(containerScreen = (ContainerScreen)screen).m_6262_()).m_6772_().equals(MenuType.f_39959_) && Minecraft.m_91087_().f_91073_.f_46441_.m_188501_() < 0.025f) {
                event.setNewScreen((Screen)new StoreScreen());
            }
        }

        private static final Minecraft mc() {
            return Minecraft.m_91087_();
        }
    }

    public static class ModEvents {
        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            event.register(RediscoveredItems.quiver.m_204114_().m_205785_().m_135782_().m_246208_("item/").m_266382_("_chestplate"));
        }

        @SubscribeEvent
        public static void registerTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(QuiverTooltip.class, ClientQuiverTooltip::new);
        }

        @SubscribeEvent
        public static void initDimensionRenderInfo(RegisterDimensionSpecialEffectsEvent event) {
            event.register(RediscoveredDimensions.SKYLANDS_ID, SKY_RENDER_INFO);
        }

        @SubscribeEvent
        protected static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.ITEM_NAME.id(), "quiver_overlay", QuiverOverlay::render);
            event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "red_dragon_stamina_display", RedDragonOverlay::render);
            if (RediscoveredClientEvents.isAprilFoolsDay()) {
                event.registerBelow(VanillaGuiOverlay.FROSTBITE.id(), "firefly_overlay", StoreScreen.StoreOverlay::renderFirefly);
                event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "lock_overlay", StoreScreen.StoreOverlay::renderLock);
                event.registerAbove(VanillaGuiOverlay.ITEM_NAME.id(), "rtx_on", StoreScreen.StoreOverlay::renderRtx);
            }
        }

        @SubscribeEvent
        public static void clientInit(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)RediscoveredMenuType.QUIVER.get()), QuiverScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)RediscoveredMenuType.DRAGON_INVENTORY.get()), DragonInventoryScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)RediscoveredMenuType.GUARD_PIGMAN_INVENTORY.get()), GuardPigmanInventoryScreen::new);
                ItemProperties.register((Item)RediscoveredBlocks.ruby_eye.m_5456_(), (ResourceLocation)RediscoveredMod.locate("eye_glow"), (ItemPropertyFunction)new RubyEyeClient.PropertyFunction());
                ItemProperties.register((Item)RediscoveredItems.ruby_flute.m_5456_(), (ResourceLocation)RediscoveredMod.locate("playing"), (ItemPropertyFunction)new RubyFluteClient.PropertyFunction());
            });
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            RediscoveredParticles.Factories.init(event);
        }

        @SubscribeEvent
        public static void registerArmorTrims(RegisterArmorTrimTexturesEvent event) {
            RediscoveredArmorTrims.Pattterns.patterns().forEach(pattern -> event.registerPatternSprite(pattern));
            RediscoveredArmorTrims.Materials.materials().forEach(material -> event.registerMaterialSprite(RediscoveredArmorTrims.Materials.assetID((ResourceKey<TrimMaterial>)material), material.m_135782_(), false));
            event.registerSprite(RediscoveredMod.locate("entity/red_dragon/armor/chain"));
            event.registerSprite(RediscoveredMod.locate("entity/red_dragon/armor/plating"));
            event.registerSprite(RediscoveredMod.locate("entity/red_dragon/armor/inlay"));
        }

        @SubscribeEvent
        public static void onConfigChange(ModConfigEvent.Reloading event) {
            StoreScreen.configRefresh(event);
        }
    }
}

