/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.capability.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.capability.entity.IRainCapability;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class RainCapability
implements IRainCapability {
    private long rainTime = 0L;
    public static final ResourceLocation RAIN_ID = RediscoveredMod.locate("rain");
    public static final Capability<IRainCapability> RAIN_INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IRainCapability>(){});

    @Override
    public long getRainTime() {
        return this.rainTime;
    }

    @Override
    public void setRainTime(long time) {
        this.rainTime = time;
    }

    @Nullable
    public static <E extends Entity> IRainCapability get(E entity) {
        LazyOptional cap;
        if (entity != null && (cap = entity.getCapability(RAIN_INSTANCE)).isPresent()) {
            return cap.resolve().orElseGet(() -> null);
        }
        return null;
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IRainCapability> action) {
        IRainCapability cap = RainCapability.get(entity);
        if (cap != null) {
            action.accept(cap);
        }
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IRainCapability> action, Runnable elseAction) {
        IRainCapability cap = RainCapability.get(entity);
        if (cap != null) {
            action.accept(cap);
        } else {
            elseAction.run();
        }
    }

    @Nullable
    public static <E extends Entity, R> R getIfPresent(E entity, Function<IRainCapability, R> action, Supplier<R> elseAction) {
        IRainCapability cap = RainCapability.get(entity);
        if (cap != null) {
            return action.apply(cap);
        }
        return elseAction.get();
    }
}

