/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.capability.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.capability.entity.IDragonTPCapability;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class DragonTPCapability
implements IDragonTPCapability {
    private Optional<UUID> dragonUUID = Optional.empty();
    public static final ResourceLocation DRAGON_TP_ID = RediscoveredMod.locate("dragon_tip");
    public static final Capability<IDragonTPCapability> DRAGON_TP_INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDragonTPCapability>(){});

    @Override
    @Nullable
    public UUID getDragonUUID() {
        return this.dragonUUID.orElse(null);
    }

    @Override
    public void setDragonUUID(@Nullable UUID uuid) {
        this.dragonUUID = Optional.ofNullable(uuid);
    }

    @Nullable
    public static <E extends Entity> IDragonTPCapability get(E entity) {
        LazyOptional cap;
        if (entity != null && (cap = entity.getCapability(DRAGON_TP_INSTANCE)).isPresent()) {
            return cap.resolve().orElseGet(() -> null);
        }
        return null;
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IDragonTPCapability> action) {
        IDragonTPCapability cap = DragonTPCapability.get(entity);
        if (cap != null) {
            action.accept(cap);
        }
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IDragonTPCapability> action, Runnable elseAction) {
        IDragonTPCapability cap = DragonTPCapability.get(entity);
        if (cap != null) {
            action.accept(cap);
        } else {
            elseAction.run();
        }
    }

    @Nullable
    public static <E extends Entity, R> R getIfPresent(E entity, Function<IDragonTPCapability, R> action, Supplier<R> elseAction) {
        IDragonTPCapability cap = DragonTPCapability.get(entity);
        if (cap != null) {
            return action.apply(cap);
        }
        return elseAction.get();
    }
}

