/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block_entities;

import com.legacy.rediscovered.block.TableBlock;
import com.legacy.rediscovered.block_entities.ModBlockEntity;
import com.legacy.rediscovered.block_entities.MultiBlockPattern;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredStats;
import com.legacy.structure_gel.api.block_entity.IRotatable;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;

public class TableBlockEntity
extends ModBlockEntity
implements Container,
IRotatable {
    private ItemStack item = ItemStack.f_41583_;
    private Direction facing = Direction.NORTH;
    private TableShape shape = TableShape.ONE_BY_ONE;
    private int oldCount = this.item.m_41613_();
    private static final String ITEM_KEY = "item";
    private static final String FACING_KEY = "facing";
    private static final String TABLE_SHAPE_KEY = "table_shape";

    public TableBlockEntity(BlockPos pos, BlockState state) {
        super(RediscoveredBlockEntityTypes.TABLE, pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEM_KEY, (Tag)this.item.m_41739_(new CompoundTag()));
        tag.m_128359_(FACING_KEY, this.facing.m_7912_());
        tag.m_128359_(TABLE_SHAPE_KEY, this.shape.m_7912_());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.item = ItemStack.m_41712_((CompoundTag)tag.m_128469_(ITEM_KEY));
        this.facing = Direction.m_122402_((String)tag.m_128461_(FACING_KEY));
        this.shape = TableShape.byName(tag.m_128461_(TABLE_SHAPE_KEY));
    }

    public void mirror(Mirror mirror) {
        this.facing = mirror.m_54848_(this.facing);
    }

    public void rotate(Rotation rotation) {
        this.facing = rotation.m_55954_(this.facing);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TableBlockEntity table) {
        ItemStack mapStack;
        if (level.m_46467_() % 20L == 0L && (mapStack = table.getItem()).m_150930_(Items.f_42573_)) {
            Integer id = MapItem.m_151131_((ItemStack)mapStack);
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)mapStack, (Level)table.f_58857_);
            if (mapData != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                    ItemFrame itemFrame = new ItemFrame((Level)serverLevel, pos, Direction.NORTH);
                    mapStack.m_41636_((Entity)itemFrame);
                    mapData.m_77918_((Player)serverPlayer, mapStack);
                    mapData.m_77947_(pos, itemFrame.m_19879_());
                    Packet packet = mapData.m_164796_(id.intValue(), (Player)serverPlayer);
                    if (packet != null) {
                        serverPlayer.f_8906_.m_9829_(packet);
                    }
                    mapStack.m_41636_(null);
                }
            }
        }
        if (table.oldCount != table.item.m_41613_()) {
            table.onChangeItem(null, null);
            table.oldCount = table.item.m_41613_();
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public TableShape getShape() {
        return this.shape;
    }

    public boolean setShape(TableShape shape) {
        if (this.shape == shape) {
            return false;
        }
        this.shape = shape;
        this.markUpdated();
        return true;
    }

    public boolean interact(Player player, InteractionHand hand, ItemStack heldItem, Direction facing) {
        if (heldItem.m_41619_()) {
            if (this.item.m_41619_()) {
                return false;
            }
            int amount = player.m_6144_() ? this.item.m_41613_() : 1;
            ItemStack grabbed = this.item.m_41620_(amount);
            this.onChangeItem(player, RediscoveredSounds.BLOCK_TABLE_REMOVE_ITEM);
            player.m_21008_(hand, grabbed);
            return true;
        }
        if (this.item.m_41619_() || this.item.m_41753_() && this.item.m_41613_() < this.item.m_41741_() && ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)this.item)) {
            int amount = 1;
            ItemStack placed = heldItem.m_41620_(amount);
            if (this.item.m_41619_()) {
                this.item = placed;
                this.facing = facing;
            } else {
                this.item.m_41769_(amount);
            }
            this.onChangeItem(player, RediscoveredSounds.BLOCK_TABLE_ADD_ITEM);
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)this.item)) {
            ItemStack oldCopy = this.item.m_41777_();
            this.item = heldItem.m_41777_();
            player.m_21008_(hand, oldCopy);
            this.onChangeItem(player, RediscoveredSounds.BLOCK_TABLE_ADD_ITEM);
            return true;
        }
        return false;
    }

    public void onChangeItem(@Nullable Player player, @Nullable SoundEvent sound) {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)player, (BlockState)this.m_58900_()));
            if (sound != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (player != null) {
                player.m_36220_(RediscoveredStats.INTERACT_WITH_TABLE);
            }
            this.oldCount = this.item.m_41613_();
            this.markUpdated();
        }
    }

    public void m_6211_() {
        this.item = ItemStack.f_41583_;
        this.onChangeItem(null, null);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.item.m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.item;
    }

    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack = !this.item.m_41619_() && amount > 0 ? this.item.m_41620_(amount) : ItemStack.f_41583_;
        this.onChangeItem(null, null);
        return stack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.item.m_41777_();
        this.item = ItemStack.f_41583_;
        this.onChangeItem(null, null);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.item = stack;
        this.onChangeItem(null, null);
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 1, 1));
    }

    public static enum TableShape implements StringRepresentable
    {
        ONE_BY_ONE(1, 1, MultiBlockPattern.builder().pattern().validator('a', TableShape.tableTest(List.of(), List.of(TableBlock.NORTH, TableBlock.SOUTH, TableBlock.EAST, TableBlock.WEST))).state(0, 0, 0, 'a').build()),
        ONE_BY_TWO(1, 2, MultiBlockPattern.builder().pattern().validator('a', TableShape.tableTest(List.of(TableBlock.SOUTH), List.of(TableBlock.NORTH, TableBlock.EAST, TableBlock.WEST))).validator('b', TableShape.tableTest(List.of(TableBlock.NORTH), List.of(TableBlock.SOUTH, TableBlock.EAST, TableBlock.WEST))).state(0, 0, 0, 'a').state(0, 0, 1, 'b').build()),
        TWO_BY_ONE(2, 1, MultiBlockPattern.builder().pattern().validator('a', TableShape.tableTest(List.of(TableBlock.EAST), List.of(TableBlock.NORTH, TableBlock.SOUTH, TableBlock.WEST))).validator('b', TableShape.tableTest(List.of(TableBlock.WEST), List.of(TableBlock.NORTH, TableBlock.SOUTH, TableBlock.EAST))).state(0, 0, 0, 'a').state(1, 0, 0, 'b').build()),
        TWO_BY_TWO(2, 2, MultiBlockPattern.builder().pattern().validator('a', TableShape.tableTest(List.of(TableBlock.SOUTH, TableBlock.EAST), List.of(TableBlock.NORTH, TableBlock.WEST))).validator('b', TableShape.tableTest(List.of(TableBlock.SOUTH, TableBlock.WEST), List.of(TableBlock.NORTH, TableBlock.EAST))).validator('c', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.EAST), List.of(TableBlock.SOUTH, TableBlock.WEST))).validator('d', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.WEST), List.of(TableBlock.SOUTH, TableBlock.EAST))).state(0, 0, 0, 'a').state(1, 0, 0, 'b').state(0, 0, 1, 'c').state(1, 0, 1, 'd').build()),
        THREE_BY_THREE(3, 3, MultiBlockPattern.builder().pattern().validator('a', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.SOUTH, TableBlock.EAST, TableBlock.WEST), List.of())).validator('b', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.SOUTH, TableBlock.WEST), List.of(TableBlock.EAST))).validator('c', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.SOUTH, TableBlock.EAST), List.of(TableBlock.WEST))).validator('d', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.WEST, TableBlock.EAST), List.of(TableBlock.SOUTH))).validator('e', TableShape.tableTest(List.of(TableBlock.SOUTH, TableBlock.WEST, TableBlock.EAST), List.of(TableBlock.NORTH))).validator('f', TableShape.tableTest(List.of(TableBlock.SOUTH, TableBlock.EAST), List.of(TableBlock.NORTH, TableBlock.WEST))).validator('g', TableShape.tableTest(List.of(TableBlock.SOUTH, TableBlock.WEST), List.of(TableBlock.NORTH, TableBlock.EAST))).validator('h', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.EAST), List.of(TableBlock.SOUTH, TableBlock.WEST))).validator('i', TableShape.tableTest(List.of(TableBlock.NORTH, TableBlock.WEST), List.of(TableBlock.SOUTH, TableBlock.EAST))).state(0, 0, 0, 'a').state(1, 0, 0, 'b').state(-1, 0, 0, 'c').state(0, 0, 1, 'd').state(0, 0, -1, 'e').state(-1, 0, -1, 'f').state(1, 0, -1, 'g').state(-1, 0, 1, 'h').state(1, 0, 1, 'i').build());

        final int width;
        final int length;
        final String name;
        final MultiBlockPattern pattern;

        private TableShape(int width, int length, MultiBlockPattern pattern) {
            this.width = width;
            this.length = length;
            this.name = width + "x" + length;
            this.pattern = pattern;
        }

        public static BiPredicate<BlockState, BlockState> tableTest(List<BooleanProperty> trueValues, List<BooleanProperty> falseValues) {
            return (self, state) -> {
                if (state.m_60713_(self.m_60734_())) {
                    for (BooleanProperty prop : trueValues) {
                        if (((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
                        return false;
                    }
                    for (BooleanProperty prop : falseValues) {
                        if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            };
        }

        public boolean growItem() {
            return this == THREE_BY_THREE;
        }

        public boolean isSingle() {
            return this == ONE_BY_ONE;
        }

        public static TableShape compute(Level level, BlockPos pos, BlockState state) {
            if (((Boolean)state.m_61143_((Property)TableBlock.SINGLE)).booleanValue()) {
                return ONE_BY_ONE;
            }
            for (TableShape shape : TableShape.values()) {
                int xDist = shape.width / 2;
                int zDist = shape.length / 2;
                for (int x = -xDist; x <= xDist; ++x) {
                    for (int z = -zDist; z <= zDist; ++z) {
                        BlockPos offsetPos = pos.m_7918_(x, 0, z);
                        if (!shape.pattern.isValid((LevelReader)level, offsetPos, state)) continue;
                        return shape;
                    }
                }
            }
            return ONE_BY_ONE;
        }

        public static TableShape byName(String name) {
            for (TableShape shape : TableShape.values()) {
                if (!shape.name.equals(name)) continue;
                return shape;
            }
            return ONE_BY_ONE;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

