/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block_entities;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.block_entities.ModBlockEntity;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RedDragonEggBlockEntity
extends ModBlockEntity
implements Nameable {
    private Optional<UUID> owner = Optional.empty();
    private Optional<Component> name = Optional.empty();
    private boolean canHatch = false;
    private int age = 0;
    private boolean startShaking = false;
    private int clientShakeTime = 0;
    public int clientXShakeDir = 1;
    public int clientZShakeDir = 1;
    public int clientYShakeDir = 1;
    public static final String OWNER_KEY = "owner";
    public static final String NAME_KEY = "name";
    public static final String AGE_KEY = "age";
    public static final String CAN_HATCH_KEY = "can_hatch";
    public static final String START_SHAKE_KEY = "start_shake";

    public RedDragonEggBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(RediscoveredBlockEntityTypes.RED_DRAGON_EGG, pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner.isPresent()) {
            tag.m_128362_(OWNER_KEY, this.owner.get());
        }
        if (this.name.isPresent()) {
            tag.m_128359_(NAME_KEY, Component.Serializer.m_130703_((Component)this.name.get()));
        }
        if (this.age != 0) {
            tag.m_128405_(AGE_KEY, this.age);
        }
        if (this.canHatch) {
            tag.m_128379_(CAN_HATCH_KEY, this.canHatch);
        }
        tag.m_128379_(START_SHAKE_KEY, this.startShaking);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner = tag.m_128403_(OWNER_KEY) ? Optional.of(tag.m_128342_(OWNER_KEY)) : Optional.empty();
        this.name = tag.m_128425_(NAME_KEY, 8) ? Optional.of(Component.Serializer.m_130701_((String)tag.m_128461_(NAME_KEY))) : Optional.empty();
        this.age = tag.m_128451_(AGE_KEY);
        this.canHatch = tag.m_128471_(CAN_HATCH_KEY);
        this.startShaking = tag.m_128471_(START_SHAKE_KEY);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RedDragonEggBlockEntity egg) {
        if (egg.canHatch()) {
            ++egg.age;
            if (egg.age >= egg.getMaxAge() && egg.hatchDragon(level, state, pos, false)) {
                return;
            }
            float hatchProgress = egg.getHatchProgress();
            if (egg.startShaking) {
                egg.startShaking = false;
            } else if (level.f_46441_.m_188501_() < 0.1f * (hatchProgress * hatchProgress * hatchProgress) || egg.age >= egg.getMaxAge() - egg.maxShakeTime()) {
                egg.startShaking = true;
            }
            egg.markUpdated();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, RedDragonEggBlockEntity egg) {
        if (egg.clientShakeTime < egg.maxShakeTime()) {
            if (egg.clientShakeTime == egg.maxShakeTime() - 4) {
                float hatchProgress = egg.getHatchProgress();
                for (Player player : level.m_6907_()) {
                    level.m_5594_(player, pos, RediscoveredSounds.BLOCK_RED_DRAGON_EGG_SHAKE, SoundSource.BLOCKS, 0.08f * hatchProgress, level.f_46441_.m_188501_() * 0.2f + 0.9f);
                }
            }
            ++egg.clientShakeTime;
        }
        if (egg.startShaking && egg.clientShakeTime >= egg.maxShakeTime()) {
            egg.clientShakeTime = 0;
            egg.clientXShakeDir = level.f_46441_.m_188499_() ? 1 : -1;
            egg.clientZShakeDir = level.f_46441_.m_188499_() ? 1 : -1;
            egg.clientYShakeDir = level.f_46441_.m_188499_() ? 1 : -1;
        }
    }

    public boolean startHatching(Player owner) {
        if (this.canHatch) {
            if (this.owner.isEmpty()) {
                this.owner = Optional.of(owner.m_20148_());
                this.markUpdated();
                return true;
            }
            return false;
        }
        this.canHatch = true;
        if (this.owner.isEmpty()) {
            this.owner = Optional.of(owner.m_20148_());
        }
        this.markUpdated();
        return true;
    }

    public boolean hatchDragon(Level level, BlockState state, BlockPos pos, boolean forceHatch) {
        Player owner;
        UUID ownerUUID = this.getOwner();
        Player player = owner = ownerUUID == null ? null : this.f_58857_.m_46003_(ownerUUID);
        if (!(forceHatch || this.canHatch() && owner != null)) {
            return false;
        }
        RedDragonOffspringEntity dragon = (RedDragonOffspringEntity)RediscoveredEntityTypes.RED_DRAGON_OFFSPRING.m_20615_(level);
        dragon.m_6034_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
        dragon.m_146762_(-24000);
        if (this.name.isPresent()) {
            dragon.m_6593_(this.name.get());
        }
        if (!forceHatch && owner != null) {
            dragon.m_21828_(owner);
            if (owner instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)owner;
                CriteriaTriggers.f_10580_.m_68256_(p, (Entity)dragon);
            }
        } else if (forceHatch && ownerUUID != null) {
            dragon.m_7105_(true);
            dragon.m_21816_(ownerUUID);
        } else {
            RediscoveredMod.LOGGER.info("Did not hatch Red Dragon at " + pos + " because the owner was not set.");
            return false;
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        level.m_5594_(null, pos, RediscoveredSounds.BLOCK_RED_DRAGON_EGG_HATCH, SoundSource.BLOCKS, 1.0f, 0.8f);
        level.m_7967_((Entity)dragon);
        return true;
    }

    public void setPlacedBy(ItemStack stack, LivingEntity placer) {
        if (stack.m_41788_()) {
            this.setCustomName(stack.m_41786_());
        }
        if (!RediscoveredConfig.WORLD.hatchableRedDragon() && placer instanceof Player) {
            Player p = (Player)placer;
            p.m_5661_((Component)Component.m_237115_((String)"rediscovered.message.dragon_hatch_disabled"), true);
        }
    }

    @Nullable
    public UUID getOwner() {
        return this.owner.isPresent() ? this.owner.get() : null;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = Optional.ofNullable(owner);
    }

    public Component m_7755_() {
        return this.name.orElseGet(() -> this.m_58900_().m_60734_().m_49954_());
    }

    public boolean m_8077_() {
        return this.name.isPresent();
    }

    public void setCustomName(@Nullable Component name) {
        this.name = Optional.ofNullable(name);
    }

    @Nullable
    public Component m_7770_() {
        return this.name.orElse(null);
    }

    public int age() {
        return this.age;
    }

    public int getMaxAge() {
        return 72000;
    }

    public float getHatchProgress() {
        return Mth.m_14036_((float)((float)this.age / (float)this.getMaxAge()), (float)0.0f, (float)1.0f);
    }

    public boolean canHatch() {
        return this.canHatch && RediscoveredConfig.WORLD.hatchableRedDragon();
    }

    public void setHatchable(boolean canHatch) {
        this.canHatch = canHatch;
        this.markUpdated();
    }

    public boolean isShaking() {
        return this.clientShakeTime < this.maxShakeTime();
    }

    public float clientShakeTime(float partialTicks) {
        return (float)this.clientShakeTime + partialTicks;
    }

    public int maxShakeTime() {
        return 10;
    }
}

