/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block_entities;

import com.legacy.rediscovered.api.INetherReactorGrowable;
import com.legacy.rediscovered.block.NetherReactorBlock;
import com.legacy.rediscovered.block_entities.ModBlockEntity;
import com.legacy.rediscovered.block_entities.MultiBlockPattern;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.particles.NetherReactorPulseData;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NetherReactorBlockEntity
extends ModBlockEntity {
    private static final MultiBlockPattern PATTERN = MultiBlockPattern.builder().pattern().validator('P', RediscoveredTags.Blocks.NETHER_REACTOR_POWER_BLOCK).validator('B', RediscoveredTags.Blocks.NETHER_REACTOR_BASE_BLOCK).state(1, -1, 1, 'P').state(1, -1, -1, 'P').state(-1, -1, 1, 'P').state(-1, -1, -1, 'P').state(0, -1, 0, 'B').state(1, -1, 0, 'B').state(-1, -1, 0, 'B').state(0, -1, 1, 'B').state(0, -1, -1, 'B').state(1, 0, 1, 'B').state(1, 0, -1, 'B').state(-1, 0, 1, 'B').state(-1, 0, -1, 'B').state(0, 1, 0, 'B').state(1, 1, 0, 'B').state(-1, 1, 0, 'B').state(0, 1, 1, 'B').state(0, 1, -1, 'B').end().build();
    private static final MultiBlockPattern STRONG_POWER_PATTERN = MultiBlockPattern.builder().pattern().validator('P', RediscoveredTags.Blocks.NETHER_REACTOR_STRONG_POWER_BLOCK).state(1, -1, 1, 'P').state(1, -1, -1, 'P').state(-1, -1, 1, 'P').state(-1, -1, -1, 'P').build();
    public static final byte TICK_RATE = 40;
    private byte tick = 0;
    private int audioTick = 0;
    private byte obsidianConversion = 0;
    private byte growthSpeed = (byte)2;
    private static final String TICK_KEY = "tick";
    private static final String OBSIDIAN_CONVERSION_KEY = "obsidian_conversion";
    private static final String GROWTH_SPEED_KEY = "growth_speed";

    public NetherReactorBlockEntity(BlockPos pos, BlockState state) {
        super(RediscoveredBlockEntityTypes.NETHER_REACTOR, pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tick = tag.m_128445_(TICK_KEY);
        this.obsidianConversion = tag.m_128445_(OBSIDIAN_CONVERSION_KEY);
        if (tag.m_128441_(GROWTH_SPEED_KEY)) {
            this.growthSpeed = tag.m_128445_(GROWTH_SPEED_KEY);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_(TICK_KEY, this.tick);
        tag.m_128344_(OBSIDIAN_CONVERSION_KEY, this.obsidianConversion);
        tag.m_128344_(GROWTH_SPEED_KEY, this.growthSpeed);
    }

    public void onPlace() {
        this.tick = (byte)30;
        this.m_6596_();
    }

    public void m_7651_() {
        this.f_58857_.m_5594_((Player)null, this.f_58858_, RediscoveredSounds.BLOCK_NETHER_REACTOR_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        super.m_7651_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NetherReactorBlockEntity netherReactor) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean active = (Boolean)state.m_61143_((Property)NetherReactorBlock.ACTIVE);
        if (netherReactor.tick % 40 == 0) {
            boolean isFullPower;
            boolean patternValid = PATTERN.isValid((LevelReader)level, pos, state);
            boolean bl = isFullPower = patternValid && STRONG_POWER_PATTERN.isValid((LevelReader)serverLevel, pos, state);
            if (patternValid != (Boolean)state.m_61143_((Property)NetherReactorBlock.ACTIVE)) {
                active = patternValid;
                level.m_5594_(null, pos, patternValid ? RediscoveredSounds.BLOCK_NETHER_REACTOR_ACTIVATE : RediscoveredSounds.BLOCK_NETHER_REACTOR_DEACTIVATE, SoundSource.BLOCKS, 3.5f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)NetherReactorBlock.ACTIVE, (Comparable)Boolean.valueOf(patternValid)), 3);
                if (patternValid) {
                    Vec3 center = pos.m_252807_();
                    for (ServerPlayer player : serverLevel.m_6907_()) {
                        serverLevel.m_8624_(player, (ParticleOptions)new NetherReactorPulseData(0, 50, 35.0f), true, center.m_7096_(), center.m_7098_(), center.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    for (ServerPlayer player : serverLevel.m_45976_(ServerPlayer.class, AABB.m_82333_((Vec3)center).m_82377_(10.0, 5.0, 10.0))) {
                        RediscoveredTriggers.ACTIVATE_NETHER_REACTOR.trigger(player, isFullPower);
                    }
                } else {
                    netherReactor.tick = 0;
                }
            }
            if (patternValid) {
                int z;
                int y;
                int radius = 45;
                int x = pos.m_123341_();
                List entities = level.m_45976_(LivingEntity.class, new AABB((double)x, (double)(y = pos.m_123342_()), (double)(z = pos.m_123343_()), (double)(x + 1), (double)(y + 1), (double)(z + 1)).m_82400_(45.0));
                if (!entities.isEmpty()) {
                    for (LivingEntity entity : entities) {
                        if (!pos.m_123314_((Vec3i)entity.m_20183_(), 45.0)) continue;
                        entity.m_7292_(new MobEffectInstance((MobEffect)RediscoveredEffects.CRIMSON_VEIL.get(), 100, isFullPower ? 1 : 0, true, true));
                    }
                }
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos offsetPos = pos.m_7918_(dx, netherReactor.obsidianConversion - 1, dz);
                        BlockState offsetState = level.m_8055_(offsetPos);
                        if (offsetState.m_60713_(RediscoveredBlocks.glowing_obsidian) || !offsetState.m_204336_(RediscoveredTags.Blocks.NETHER_REACTOR_BASE_BLOCK)) continue;
                        level.m_46961_(offsetPos, false);
                        level.m_7731_(offsetPos, RediscoveredBlocks.glowing_obsidian.m_49966_(), 3);
                        Vec3 p2 = offsetPos.m_252807_();
                        double d = 0.4;
                        serverLevel.m_8767_((ParticleOptions)RediscoveredParticles.NETHER_REACTOR_GROWTH, p2.f_82479_, p2.f_82480_, p2.f_82481_, 20, d, d, d, 0.001);
                    }
                }
                netherReactor.obsidianConversion = (byte)(netherReactor.obsidianConversion + 1);
                if (netherReactor.obsidianConversion > 2) {
                    netherReactor.obsidianConversion = 0;
                }
            } else if (netherReactor.obsidianConversion != 0) {
                netherReactor.obsidianConversion = 0;
            }
        }
        RandomSource rand = serverLevel.m_213780_();
        int growthRadius = 16;
        int horizontalRadius = 8;
        int growthSpeed = netherReactor.growthSpeed;
        for (int i = 0; i < growthSpeed; ++i) {
            BlockPos growthPos = pos.m_7918_(rand.m_216332_(-16, 16), rand.m_216332_(-8, 8), rand.m_216332_(-16, 16));
            BlockState growthTarget = serverLevel.m_8055_(growthPos);
            INetherReactorGrowable nrg = INetherReactorGrowable.get(growthTarget);
            nrg.onNetherReactorGrow(growthTarget, serverLevel, growthPos, rand, netherReactor).ifPresent(p -> nrg.displayNetherReactorGrowth(growthTarget, serverLevel, (BlockPos)p, rand, netherReactor));
        }
        if ((double)netherReactor.audioTick % 102.0 == 0.0 && active) {
            level.m_5594_(null, pos, RediscoveredSounds.BLOCK_NETHER_REACTOR_IDLE, SoundSource.BLOCKS, 6.0f, 1.0f);
            netherReactor.audioTick = 0;
        }
        if ((double)(netherReactor.audioTick - 5) % 51.0 == 0.0 && active) {
            Vec3 center = pos.m_252807_();
            for (ServerPlayer player : serverLevel.m_6907_()) {
                serverLevel.m_8624_(player, (ParticleOptions)new NetherReactorPulseData(2, 20, 5.0f), true, center.m_7096_(), center.m_7098_(), center.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (active) {
            ++netherReactor.audioTick;
        }
        netherReactor.tick = (byte)(netherReactor.tick + 1);
        if (netherReactor.tick >= 40) {
            netherReactor.tick = 0;
        }
        netherReactor.m_6596_();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, NetherReactorBlockEntity netherReactor) {
        if (((Boolean)state.m_61143_((Property)NetherReactorBlock.ACTIVE)).booleanValue()) {
            RandomSource rand = level.m_213780_();
            Vec3 center = pos.m_252807_();
            double x = center.f_82479_;
            double y = center.f_82480_;
            double z = center.f_82481_;
            int range = 10;
            for (int i = rand.m_188503_(3); i > 0; --i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123784_, x + (double)rand.m_188503_(range) - (double)rand.m_188503_(range), y + (double)rand.m_188503_(range) - (double)rand.m_188503_(range), z + (double)rand.m_188503_(range) - (double)rand.m_188503_(range), 0.0, 0.0, 0.0);
            }
            double d = 1.4;
            double dy = 0.5;
            for (int i = 5; i > 0; --i) {
                level.m_7106_((ParticleOptions)RediscoveredParticles.NETHER_REACTOR_GROWTH, x + ((double)rand.m_188501_() - 0.5) * d, y + ((double)rand.m_188501_() - 0.5) * dy, z + ((double)rand.m_188501_() - 0.5) * d, 1.0E-4, 1.0E-4, 1.0E-4);
            }
        }
    }
}

