/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block_entities;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockPattern {
    private final int size;
    private final Char2ObjectOpenHashMap<BiPredicate<BlockState, BlockState>>[] validators;
    private final StateTest[][] stateTests;

    private MultiBlockPattern(MultiBlockPatternBuilder builder) {
        this.size = builder.patterns.size();
        this.validators = new Char2ObjectOpenHashMap[this.size];
        this.stateTests = new StateTest[this.size][];
        for (int i = 0; i < this.size; ++i) {
            PatternBuilder pattern = builder.patterns.get(i);
            this.stateTests[i] = (StateTest[])pattern.stateTests.toArray(StateTest[]::new);
            this.validators[i] = new Char2ObjectOpenHashMap(pattern.validators);
            this.validators[i].defaultReturnValue((self, test) -> false);
        }
    }

    public static MultiBlockPatternBuilder builder() {
        return new MultiBlockPatternBuilder();
    }

    public boolean isValid(LevelReader level, BlockPos origin, BlockState self) {
        boolean anyPassed = false;
        block0: for (int i = 0; i < this.size && !anyPassed; ++i) {
            Char2ObjectOpenHashMap<BiPredicate<BlockState, BlockState>> vals = this.validators[i];
            for (StateTest s : this.stateTests[i]) {
                if (!((BiPredicate)vals.get(s.validatorKey)).test(self, level.m_8055_(origin.m_7918_((int)s.x, (int)s.y, (int)s.z)))) continue block0;
            }
            anyPassed = true;
        }
        return anyPassed;
    }

    public static class MultiBlockPatternBuilder {
        private final List<PatternBuilder> patterns = new ArrayList<PatternBuilder>(1);

        private MultiBlockPatternBuilder() {
        }

        public PatternBuilder pattern() {
            PatternBuilder pattern = new PatternBuilder(this);
            this.patterns.add(pattern);
            return pattern;
        }

        public MultiBlockPattern build() {
            if (this.patterns.isEmpty()) {
                throw new IllegalStateException("Cannot create MultiBlockPattern because it has no patterns");
            }
            for (PatternBuilder pattern : this.patterns) {
                for (StateTest s : pattern.stateTests) {
                    if (pattern.validators.containsKey(Character.valueOf(s.validatorKey))) continue;
                    throw new IllegalStateException("Cannot create MultiBlockPattern because validator '" + s.validatorKey + "' has not been defined.");
                }
            }
            return new MultiBlockPattern(this);
        }
    }

    private record StateTest(byte x, byte y, byte z, char validatorKey) {
    }

    public static class PatternBuilder {
        private final MultiBlockPatternBuilder parent;
        private Map<Character, BiPredicate<BlockState, BlockState>> validators = new HashMap<Character, BiPredicate<BlockState, BlockState>>();
        private List<StateTest> stateTests = new ArrayList<StateTest>();

        private PatternBuilder(MultiBlockPatternBuilder parent) {
            this.parent = parent;
        }

        public PatternBuilder validator(char key, TagKey<Block> tag) {
            return this.validator(key, (BlockState self, BlockState test) -> test.m_204336_(tag));
        }

        public PatternBuilder validator(char key, Predicate<BlockState> validator) {
            return this.validator(key, (BlockState self, BlockState test) -> validator.test((BlockState)test));
        }

        public PatternBuilder validator(char key, BiPredicate<BlockState, BlockState> validator) {
            this.validators.put(Character.valueOf(key), validator);
            return this;
        }

        public PatternBuilder state(Vec3i offset, char validatorKey) {
            return this.state(offset.m_123341_(), offset.m_123342_(), offset.m_123343_(), validatorKey);
        }

        public PatternBuilder state(int x, int y, int z, char validatorKey) {
            this.stateTests.add(new StateTest((byte)x, (byte)y, (byte)z, validatorKey));
            return this;
        }

        public PatternBuilder or() {
            return this.parent.pattern();
        }

        public MultiBlockPatternBuilder end() {
            return this.parent;
        }

        public MultiBlockPattern build() {
            return this.end().build();
        }
    }
}

