/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block_entities;

import com.legacy.rediscovered.block.DragonAltarBlock;
import com.legacy.rediscovered.block_entities.ModBlockEntity;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.particles.PylonShieldBlastData;
import com.legacy.rediscovered.entity.dragon.DragonPylonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredPoiTypes;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MiniDragonPylonBlockEntity
extends ModBlockEntity {
    public UUID mainPylonUUID = null;
    private Optional<BlockPos> beamPos = Optional.empty();
    private int respawnTimer = 0;
    private Optional<BlockPos> respawnMasterPos = Optional.empty();
    public int ticks;
    private static final String PYLON_UUID = "pylon_uuid";
    private static final String BEAM_POS = "beam_pos";
    private static final String RESPAWN_TIMER = "respawn_timer";
    private static final String RESPAWN_MASTER = "respawn_master";

    public MiniDragonPylonBlockEntity(BlockPos pos, BlockState state) {
        super(RediscoveredBlockEntityTypes.MIN_DRAGON_PYLON, pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.mainPylonUUID != null) {
            tag.m_128362_(PYLON_UUID, this.mainPylonUUID);
        }
        if (this.beamPos.isPresent()) {
            tag.m_128356_(BEAM_POS, this.beamPos.get().m_121878_());
        }
        if (this.respawnMasterPos.isPresent()) {
            tag.m_128356_(RESPAWN_MASTER, this.respawnMasterPos.get().m_121878_());
        }
        tag.m_128405_(RESPAWN_TIMER, this.respawnTimer);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mainPylonUUID = tag.m_128403_(PYLON_UUID) ? tag.m_128342_(PYLON_UUID) : null;
        this.beamPos = tag.m_128425_(BEAM_POS, 4) ? Optional.of(BlockPos.m_122022_((long)tag.m_128454_(BEAM_POS))) : Optional.empty();
        this.respawnMasterPos = tag.m_128425_(RESPAWN_MASTER, 4) ? Optional.of(BlockPos.m_122022_((long)tag.m_128454_(RESPAWN_MASTER))) : Optional.empty();
        this.respawnTimer = tag.m_128451_(RESPAWN_TIMER);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MiniDragonPylonBlockEntity pylon) {
        if (level instanceof ServerLevel) {
            int groundOffset;
            BlockPos ground;
            ServerLevel sl = (ServerLevel)level;
            if ((level.m_46467_() % 20L == 0L || pylon.respawnTimer > 0) && MiniDragonPylonBlockEntity.isRespawnBlock(level.m_8055_(ground = pos.m_6625_(groundOffset = 2))) && level.m_6443_(DragonPylonEntity.class, new AABB(pos).m_82400_(4.0), e -> true).isEmpty()) {
                if (pylon.respawnTimer >= pylon.timeUntilRespawn()) {
                    level.m_46961_(pos, false);
                    if (pylon.isRespawnMaster()) {
                        BlockPos actionPos = pylon.beamPos.orElse(pylon.f_58858_);
                        BlockPos spawnPos = actionPos.m_6630_(pylon.getRespawnHeight());
                        RedDragonBossEntity dragon = (RedDragonBossEntity)RediscoveredEntityTypes.RED_DRAGON_BOSS.m_20615_(level);
                        dragon.m_146884_(spawnPos.m_252807_());
                        dragon.homePos = pylon.beamPos.isPresent() ? pylon.beamPos.get().m_6625_(4) : pylon.f_58858_;
                        level.m_7967_((Entity)dragon);
                        pylon.spawnBlastParticle(sl, spawnPos);
                        level.m_5594_(null, spawnPos, RediscoveredSounds.ENTITY_RED_DRAGON_SHIELD_DOWN, SoundSource.HOSTILE, 7.0f, 1.0f);
                        int advancementRadius = 32;
                        List players = sl.m_8795_(player -> player.m_20182_().m_82557_(actionPos.m_252807_()) < (double)(advancementRadius * advancementRadius));
                        for (ServerPlayer player2 : players) {
                            CriteriaTriggers.f_10580_.m_68256_(player2, (Entity)dragon);
                        }
                    }
                    return;
                }
                List<BlockPos> pylons = MiniDragonPylonBlockEntity.findNearbyPylons(sl, pos);
                int requiredForRespawn = 4;
                if (pylons.size() >= requiredForRespawn) {
                    boolean respawnInProgress;
                    ++pylon.respawnTimer;
                    pylon.markUpdated();
                    if ((pylon.respawnMasterPos.isEmpty() || pylon.getRespawnMaster() == null) && !(respawnInProgress = pylons.stream().map(pylonPos -> level.m_141902_(pylonPos, RediscoveredBlockEntityTypes.MIN_DRAGON_PYLON)).filter(Optional::isPresent).map(Optional::get).anyMatch(p -> p.getRespawnMaster() != null))) {
                        BlockPos master = pylons.get(0);
                        for (int i = 0; i < requiredForRespawn; ++i) {
                            BlockPos child = pylons.get(i);
                            level.m_141902_(child, RediscoveredBlockEntityTypes.MIN_DRAGON_PYLON).ifPresent(p -> {
                                p.setRespawnMasterPos(master);
                                if (p.beamPos.isEmpty()) {
                                    p.computeBeamPos(groundOffset);
                                }
                            });
                        }
                    }
                }
                if (pylons.size() < requiredForRespawn || pylon.getRespawnMaster() == null) {
                    pylon.stopRespawnSequence();
                }
            }
        }
    }

    public static List<BlockPos> findNearbyPylons(ServerLevel level, BlockPos pos) {
        return level.m_8904_().m_27181_(h -> h.m_203565_(RediscoveredPoiTypes.MINI_DRAGON_PYLON.getKey()), pos, 5, PoiManager.Occupancy.ANY).filter(poi -> MiniDragonPylonBlockEntity.isRespawnBlock(level.m_8055_(poi.m_27257_().m_6625_(2)))).map(poi -> poi.m_27257_()).toList();
    }

    private static boolean isRespawnBlock(BlockState state) {
        return state.m_60713_(RediscoveredBlocks.dragon_altar);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, MiniDragonPylonBlockEntity pylon) {
        ++pylon.ticks;
    }

    @Nullable
    public BlockPos getBeamPos() {
        return this.beamPos.orElse(null);
    }

    public void setBeamPos(@Nullable BlockPos pos) {
        this.beamPos = Optional.ofNullable(pos);
        this.markUpdated();
    }

    private void computeBeamPos(int groundOffset) {
        BlockPos pos = this.m_58899_();
        int minX = pos.m_123341_();
        int minZ = pos.m_123343_();
        int maxX = pos.m_123341_();
        int maxZ = pos.m_123343_();
        int verticalOffset = 3;
        int r = 2;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos checkPos = pos.m_7918_(dx, -groundOffset, dz);
                BlockState state = this.f_58857_.m_8055_(checkPos);
                if (!MiniDragonPylonBlockEntity.isRespawnBlock(state)) continue;
                if (state.m_61143_(DragonAltarBlock.SHAPE) == DragonAltarBlock.Shape.CENTER) {
                    this.setBeamPos(new BlockPos(checkPos.m_123341_(), pos.m_123342_() + verticalOffset, checkPos.m_123343_()));
                    return;
                }
                minX = Math.min(minX, checkPos.m_123341_());
                minZ = Math.min(minZ, checkPos.m_123343_());
                maxX = Math.max(maxX, checkPos.m_123341_());
                maxZ = Math.max(maxZ, checkPos.m_123343_());
            }
        }
        this.setBeamPos(new BlockPos((minX + maxX) / 2, pos.m_123342_() + verticalOffset, (minZ + maxZ) / 2));
    }

    public int getRespawnHeight() {
        return 45;
    }

    public int timeUntilRespawn() {
        return 100;
    }

    public float getRespawnProgress(float partialTick) {
        return Mth.m_14036_((float)(((float)this.respawnTimer + partialTick) / (float)this.timeUntilRespawn()), (float)0.0f, (float)1.0f);
    }

    public void stopRespawnSequence() {
        this.respawnTimer = 0;
        this.markUpdated();
        if (this.beamPos.isPresent()) {
            this.setBeamPos(null);
        }
        if (this.respawnMasterPos.isPresent()) {
            this.setRespawnMasterPos(null);
        }
    }

    @Nullable
    public BlockPos getRespawnMasterPos() {
        return this.respawnMasterPos.orElse(null);
    }

    public void setRespawnMasterPos(@Nullable BlockPos pos) {
        this.respawnMasterPos = Optional.ofNullable(pos);
        this.markUpdated();
    }

    public boolean isRespawnMaster() {
        return this.respawnMasterPos.isPresent() && this.respawnMasterPos.get().equals((Object)this.m_58899_());
    }

    @Nullable
    public BlockState getRespawnMaster() {
        return this.respawnMasterPos.map(pos -> this.f_58857_.m_8055_(pos)).orElse(null);
    }

    public void onPylonDestroyed(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.spawnBlastParticle(sl, pos);
            if (this.respawnTimer > 0) {
                for (BlockPos pylonPos : MiniDragonPylonBlockEntity.findNearbyPylons(sl, pos)) {
                    if (pylonPos.equals((Object)pos)) continue;
                    level.m_141902_(pylonPos, RediscoveredBlockEntityTypes.MIN_DRAGON_PYLON).ifPresent(pylon -> {
                        if (pylon.respawnTimer < pylon.timeUntilRespawn()) {
                            pylon.stopRespawnSequence();
                        }
                    });
                }
            }
        }
    }

    private void spawnBlastParticle(ServerLevel level, BlockPos pos) {
        level.m_45976_(DragonPylonEntity.class, new AABB(pos).m_82400_(80.0)).forEach(pylon -> {
            pylon.forceLayerUpdate = true;
        });
        Vec3 position = pos.m_252807_();
        for (ServerPlayer player : level.m_6907_()) {
            level.m_8624_(player, (ParticleOptions)new PylonShieldBlastData(), true, position.f_82479_, position.f_82480_, position.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.beamPos.isEmpty()) {
            return new AABB(this.f_58858_).m_82400_(2.0);
        }
        return INFINITE_EXTENT_AABB;
    }
}

