/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block_entities;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.block.GearBlock;
import com.legacy.rediscovered.block_entities.ModBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.block_entity.IRotatable;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class GearBlockEntity
extends ModBlockEntity
implements IRotatable {
    private EnumMap<GearBlock.GearFace, GearPower> gearPowers = (EnumMap)Util.m_137537_(() -> {
        EnumMap<GearBlock.GearFace, GearPower> map = new EnumMap<GearBlock.GearFace, GearPower>(GearBlock.GearFace.class);
        for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
            map.put(face, new GearPower());
        }
        return map;
    });
    private int[] angles = new int[]{0, 0, 0, 0, 0, 0};
    private int[] oldAngles = new int[]{0, 0, 0, 0, 0, 0};
    private static final String GEAR_POWERS = "powers";

    public GearBlockEntity(BlockPos pos, BlockState state) {
        super(RediscoveredBlockEntityTypes.GEAR, pos, state);
    }

    public void mirror(Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            GearPower e = this.getPower(GearBlock.GearFace.EAST);
            GearPower w = this.getPower(GearBlock.GearFace.WEST);
            this.gearPowers.put(GearBlock.GearFace.EAST, w);
            this.gearPowers.put(GearBlock.GearFace.WEST, e);
        } else if (mirror == Mirror.LEFT_RIGHT) {
            GearPower n = this.getPower(GearBlock.GearFace.NORTH);
            GearPower s = this.getPower(GearBlock.GearFace.SOUTH);
            this.gearPowers.put(GearBlock.GearFace.NORTH, s);
            this.gearPowers.put(GearBlock.GearFace.SOUTH, n);
        }
    }

    public void rotate(Rotation rotation) {
        if (rotation != Rotation.NONE) {
            HashMap<Direction, GearPower> gears = new HashMap<Direction, GearPower>();
            for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
                gears.put(dir, this.getPower(GearBlock.GearFace.get(dir)));
            }
            for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
                Direction rotatedDir = rotation.m_55954_(dir);
                this.gearPowers.put(GearBlock.GearFace.get(rotatedDir), (GearPower)gears.get(dir));
            }
        }
    }

    public void startSpinning(ServerLevel level, BlockPos source, BlockPos gearPos, GearBlock.GearFace face, int power, int distFromSource) {
        if (power != 0 && ((GearBlock.GearState)((Object)this.m_58900_().m_61143_(face.stateProperty))).exists() && (distFromSource < RediscoveredConfig.WORLD.maxGearDistance() || RediscoveredConfig.WORLD.maxGearDistance() == -1) && this.addSource(face, new Source(source, distFromSource, power))) {
            this.markDirty();
            this.spinNeighbors(level, source, gearPos, face, power, distFromSource + 1);
        }
    }

    public void spinNeighbors(ServerLevel level, BlockPos source, BlockPos gearPos, GearBlock.GearFace face, int power, int distFromSource) {
        if (power == 0) {
            return;
        }
        List<Pair<BlockPos, GearBlock.GearFace>> possibleConnections = face.getPossibleConnections(gearPos);
        for (Pair<BlockPos, GearBlock.GearFace> possibleCon : possibleConnections) {
            GearBlockEntity connectedGear;
            GearPower connectedGearPower;
            Source connectedSource;
            BlockEntity blockEntity;
            BlockPos connectionPos = (BlockPos)possibleCon.getKey();
            BlockState connectionState = level.m_8055_(connectionPos);
            GearBlock.GearFace connectionFace = (GearBlock.GearFace)((Object)possibleCon.getValue());
            if (!connectionState.m_61138_(connectionFace.stateProperty) || !((GearBlock.GearState)((Object)connectionState.m_61143_(connectionFace.stateProperty))).exists() || !((blockEntity = level.m_7702_(connectionPos)) instanceof GearBlockEntity) || (connectedSource = (connectedGearPower = (connectedGear = (GearBlockEntity)blockEntity).getPower(connectionFace)).getSource(source)) != null && (connectedSource.getPower() == -power || connectedSource.distFromSource <= distFromSource)) continue;
            connectedGear.startSpinning(level, source, connectionPos, connectionFace, -power, distFromSource);
        }
    }

    public void stopSpinning(ServerLevel level, BlockPos source, BlockPos gearPos, GearBlock.GearFace face) {
        if (((GearBlock.GearState)((Object)this.m_58900_().m_61143_(face.stateProperty))).exists() && this.removeSource(face, source)) {
            this.stopNeighbors(level, source, gearPos, face);
            this.markDirty();
        }
        for (GearBlock.GearFace f : GearBlock.GearFace.values()) {
            GearPower power = this.getPower(f);
            if (power.getSources().isEmpty()) continue;
            for (Source s : List.copyOf(power.getSources())) {
                BlockPos sPos;
                if (s.distFromSource != 0 || (sPos = s.pos).m_123333_((Vec3i)gearPos) <= 1) continue;
                System.out.println("too far! " + gearPos);
                this.stopSpinning(level, sPos, gearPos, f);
            }
        }
    }

    public void stopNeighbors(ServerLevel level, BlockPos source, BlockPos gearPos, GearBlock.GearFace face) {
        List<Pair<BlockPos, GearBlock.GearFace>> possibleConnections = face.getPossibleConnections(gearPos);
        for (Pair<BlockPos, GearBlock.GearFace> possibleCon : possibleConnections) {
            GearBlockEntity connectedGear;
            GearPower connectedGearPower;
            BlockEntity blockEntity;
            BlockPos connectionPos = (BlockPos)possibleCon.getKey();
            BlockState connectionState = level.m_8055_(connectionPos);
            GearBlock.GearFace connectionFace = (GearBlock.GearFace)((Object)possibleCon.getValue());
            if (!connectionState.m_61138_(connectionFace.stateProperty) || !((GearBlock.GearState)((Object)connectionState.m_61143_(connectionFace.stateProperty))).exists() || !((blockEntity = level.m_7702_(connectionPos)) instanceof GearBlockEntity) || !(connectedGearPower = (connectedGear = (GearBlockEntity)blockEntity).getPower(connectionFace)).hasSource(source)) continue;
            connectedGear.stopSpinning(level, source, connectionPos, connectionFace);
        }
    }

    public void onNeighborUpdated(ServerLevel level, BlockState gearState, BlockPos gearPos) {
        for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
            if (!((GearBlock.GearState)((Object)gearState.m_61143_(face.stateProperty))).exists()) continue;
            List<Source> sources = List.copyOf(this.getPower(face).getSources());
            for (Source source : sources) {
                if (this.locateSource(level, source, gearPos, face)) {
                    this.startSpinning(level, source.pos, gearPos, face, source.getPower(), source.distFromSource);
                    continue;
                }
                this.stopSpinning(level, source.pos, gearPos, face);
            }
        }
    }

    public boolean locateSource(ServerLevel level, Source source, BlockPos gearPos, GearBlock.GearFace face) {
        if (source.distFromSource == 0) {
            return true;
        }
        List<Pair<BlockPos, GearBlock.GearFace>> possibleConnections = face.getPossibleConnections(gearPos);
        for (Pair<BlockPos, GearBlock.GearFace> possibleCon : possibleConnections) {
            GearBlockEntity connectedGear;
            Source connectionSource;
            BlockEntity blockEntity;
            BlockPos connectionPos = (BlockPos)possibleCon.getKey();
            BlockState connectionState = level.m_8055_(connectionPos);
            GearBlock.GearFace connectionFace = (GearBlock.GearFace)((Object)possibleCon.getValue());
            if (!connectionState.m_61138_(connectionFace.stateProperty) || !((GearBlock.GearState)((Object)connectionState.m_61143_(connectionFace.stateProperty))).exists() || !((blockEntity = level.m_7702_(connectionPos)) instanceof GearBlockEntity) || (connectionSource = (connectedGear = (GearBlockEntity)blockEntity).getPower(connectionFace).getSource(source.pos)) == null || connectionSource.distFromSource >= source.distFromSource) continue;
            return this.locateSource(level, connectionSource, connectionPos, connectionFace);
        }
        return false;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, GearBlockEntity gear) {
        for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
            int i = face.ordinal();
            gear.oldAngles[i] = gear.angles[i];
            int power = gear.getPower(face).getPower();
            if (power == 0) continue;
            gear.addAngle(i, power / 2 + (power > 0 ? 1 : -1));
        }
    }

    public void updateConverter(GearBlock.GearFace face) {
        BlockPos pos;
        BlockState state;
        if (!this.f_58857_.f_46443_ && (state = this.f_58857_.m_8055_(pos = this.f_58858_.m_121945_(face.direction))).m_60713_(RediscoveredBlocks.rotational_converter)) {
            this.f_58857_.m_186460_(pos, state.m_60734_(), 2);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag powersTag = tag.m_128469_(GEAR_POWERS);
        for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
            GearPower power = GearPower.read(powersTag.m_128469_(face.direction.m_7912_()));
            this.gearPowers.put(face, power);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag powersTag = new CompoundTag();
        for (Map.Entry<GearBlock.GearFace, GearPower> entry : this.gearPowers.entrySet()) {
            String key = entry.getKey().direction.m_7912_();
            CompoundTag value = entry.getValue().write();
            powersTag.m_128365_(key, (Tag)value);
        }
        tag.m_128365_(GEAR_POWERS, (Tag)powersTag);
    }

    public GearPower getPower(GearBlock.GearFace face) {
        return this.gearPowers.get((Object)face);
    }

    public boolean isPowered(GearBlock.GearFace face) {
        return this.getPower(face).getPower() != 0;
    }

    public boolean addSource(GearBlock.GearFace face, Source source) {
        GearPower gearPower = this.getPower(face);
        int oldPower = gearPower.getPower();
        if (!gearPower.addSource(source)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(face.stateProperty, (Comparable)((Object)GearBlock.GearState.NONE)), 3);
            BlockState fakeState = (BlockState)this.m_58900_().m_60734_().m_49966_().m_61124_(face.stateProperty, (Comparable)((Object)GearBlock.GearState.GEAR));
            this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)fakeState));
            Block.m_49881_((BlockState)fakeState, (Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockEntity)this, null, (ItemStack)ItemStack.f_41583_);
            this.getPower((GearBlock.GearFace)face).sources.clear();
            this.markDirty();
            return false;
        }
        if (Math.abs(oldPower) != Math.abs(gearPower.getPower())) {
            this.updateConverter(face);
        }
        return true;
    }

    public boolean removeSource(GearBlock.GearFace face, BlockPos source) {
        GearPower gearPower = this.getPower(face);
        int oldPower = gearPower.getPower();
        if (gearPower.removeSource(source)) {
            if (Math.abs(oldPower) != Math.abs(gearPower.getPower())) {
                this.updateConverter(face);
            }
            return true;
        }
        return false;
    }

    public float getAngle(Direction direction, float partialTick) {
        int i = direction.m_122411_();
        return Mth.m_14189_((float)partialTick, (float)this.oldAngles[i], (float)this.angles[i]);
    }

    public void addAngle(int direction, int amount) {
        int angle = this.angles[direction];
        this.angles[direction] = Mth.m_14098_((int)(angle + amount));
    }

    private void markDirty() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static class GearPower {
        @Deprecated
        private final Map<BlockPos, Source> sources = new HashMap<BlockPos, Source>();
        @Deprecated
        int rotation = 0;
        private static final String ROTATION_KEY = "rotation";
        private static final String SOURCES_KEY = "sources";

        private GearPower() {
        }

        public boolean hasSource(BlockPos pos) {
            return this.sources.containsKey(pos);
        }

        public boolean addSource(Source source) {
            this.sources.put(source.pos, source);
            int oldRotation = this.rotation;
            this.rotation = source.getRotation();
            return oldRotation == 0 || oldRotation == this.rotation;
        }

        public boolean removeSource(BlockPos pos) {
            Source prev = this.sources.remove(pos);
            if (this.sources.isEmpty()) {
                this.rotation = 0;
            }
            return prev != null;
        }

        @Nullable
        public Source getSource(BlockPos pos) {
            return this.sources.get(pos);
        }

        public Collection<Source> getSources() {
            return this.sources.values();
        }

        public int getPower() {
            if (this.sources.isEmpty()) {
                this.rotation = 0;
            }
            int power = 0;
            for (Source source : this.sources.values()) {
                if (this.rotation > 0) {
                    power = Math.max(power, source.getPower());
                }
                if (this.rotation >= 0) continue;
                power = Math.min(power, source.getPower());
            }
            return power;
        }

        public static GearPower read(CompoundTag tag) {
            GearPower gearPower = new GearPower();
            gearPower.sources.clear();
            ListTag sourcesTag = tag.m_128437_(SOURCES_KEY, 10);
            for (Tag t : sourcesTag) {
                Source source = Source.read((CompoundTag)t);
                gearPower.sources.put(source.pos, source);
            }
            gearPower.rotation = tag.m_128451_(ROTATION_KEY);
            return gearPower;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            ListTag sourcesTag = new ListTag();
            for (Source source : this.sources.values()) {
                sourcesTag.add((Object)source.write());
            }
            tag.m_128365_(SOURCES_KEY, (Tag)sourcesTag);
            tag.m_128405_(ROTATION_KEY, this.rotation);
            return tag;
        }
    }

    public static class Source {
        private final BlockPos pos;
        private final int distFromSource;
        private int power = 0;
        private static final String POS_KEY = "pos";
        private static final String DIST_KEY = "distance";
        private static final String POWER_KEY = "power";

        public Source(BlockPos pos, int distFromSource, int power) {
            this.pos = pos.m_7949_();
            this.distFromSource = distFromSource;
            this.power = power;
        }

        public static Source read(CompoundTag tag) {
            return new Source(NbtUtils.m_129239_((CompoundTag)tag.m_128469_(POS_KEY)), tag.m_128451_(DIST_KEY), tag.m_128451_(POWER_KEY));
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(POS_KEY, (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
            tag.m_128405_(DIST_KEY, this.distFromSource);
            tag.m_128405_(POWER_KEY, this.power);
            return tag;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int distFromSource() {
            return this.distFromSource;
        }

        public int getPower() {
            return this.power;
        }

        public int getRotation() {
            return this.power > 0 ? 1 : (this.power < 0 ? -1 : 0);
        }
    }
}

