/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.block_entities.TableBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty NW = BooleanProperty.m_61465_((String)"north_west");
    public static final BooleanProperty NE = BooleanProperty.m_61465_((String)"north_east");
    public static final BooleanProperty SW = BooleanProperty.m_61465_((String)"south_west");
    public static final BooleanProperty SE = BooleanProperty.m_61465_((String)"south_east");
    public static final BooleanProperty SINGLE = BooleanProperty.m_61465_((String)"single");
    private static final VoxelShape TABLE_TOP = Block.m_49796_((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    private static final VoxelShape TABLE_LEG = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)9.0, (double)4.0);
    private static final VoxelShape TABLE_EDGE = Block.m_49796_((double)2.0, (double)9.0, (double)0.0, (double)14.0, (double)11.0, (double)2.0);
    private static final VoxelShape TABLE_CORNER = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)2.0, (double)11.0, (double)2.0);
    private static final Function<BlockState, VoxelShape> SHAPE_FUNC = Util.m_143827_(state -> {
        boolean n = (Boolean)state.m_61143_((Property)NORTH);
        boolean s = (Boolean)state.m_61143_((Property)SOUTH);
        boolean e = (Boolean)state.m_61143_((Property)EAST);
        boolean w = (Boolean)state.m_61143_((Property)WEST);
        boolean ne = (Boolean)state.m_61143_((Property)NE);
        boolean nw = (Boolean)state.m_61143_((Property)NW);
        boolean se = (Boolean)state.m_61143_((Property)SE);
        boolean sw = (Boolean)state.m_61143_((Property)SW);
        VoxelShape shape = TABLE_TOP;
        if (!n && !w) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TABLE_LEG);
        }
        if (nw) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TABLE_CORNER);
        }
        if (n) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)TABLE_EDGE);
        }
        if (!e && !n) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_LEG, (Direction)Direction.EAST));
        }
        if (ne) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_CORNER, (Direction)Direction.EAST));
        }
        if (e) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_EDGE, (Direction)Direction.EAST));
        }
        if (!s && !e) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_LEG, (Direction)Direction.SOUTH));
        }
        if (se) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_CORNER, (Direction)Direction.SOUTH));
        }
        if (s) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_EDGE, (Direction)Direction.SOUTH));
        }
        if (!w && !s) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_LEG, (Direction)Direction.WEST));
        }
        if (sw) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_CORNER, (Direction)Direction.WEST));
        }
        if (w) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)VoxelShapeUtil.rotate((VoxelShape)TABLE_EDGE, (Direction)Direction.WEST));
        }
        return shape;
    });

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SINGLE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_FUNC.apply(state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TableBlockEntity table;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TableBlockEntity && (table = (TableBlockEntity)blockEntity).setShape(TableBlockEntity.TableShape.compute((Level)level, pos, state))) {
            for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
                BlockPos neighborPos = pos.m_121945_(dir);
                BlockState neighbor = level.m_8055_(neighborPos);
                if (!neighbor.m_60713_(state.m_60734_())) continue;
                level.m_186460_(neighborPos, neighbor.m_60734_(), 0);
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction neighbor, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        level.m_186460_(pos, state.m_60734_(), 0);
        return this.computeState(level, pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean placeAgainstTable;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        BlockPos neighborPos = pos.m_121945_(context.m_43719_().m_122424_());
        BlockState neighborState = level.m_8055_(neighborPos);
        boolean bl = placeAgainstTable = context.m_43719_().m_122434_().m_122479_() && neighborState.m_60713_((Block)this);
        if (placeAgainstTable) {
            level.m_7731_(neighborPos, (BlockState)neighborState.m_61124_((Property)SINGLE, (Comparable)Boolean.valueOf(false)), 3);
        }
        return (BlockState)this.computeState((LevelAccessor)level, pos, (BlockState)state.m_61124_((Property)SINGLE, (Comparable)Boolean.valueOf(context.m_7078_() && !placeAgainstTable))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)));
    }

    public BlockState computeState(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)SINGLE)).booleanValue()) {
            return state;
        }
        boolean n = this.canConnect(level.m_8055_(pos.m_121945_(Direction.NORTH)));
        boolean s = this.canConnect(level.m_8055_(pos.m_121945_(Direction.SOUTH)));
        boolean e = this.canConnect(level.m_8055_(pos.m_121945_(Direction.EAST)));
        boolean w = this.canConnect(level.m_8055_(pos.m_121945_(Direction.WEST)));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(n))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(s))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(e))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(w))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(n && w && this.canConnect(level.m_8055_(pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST)))))).m_61124_((Property)NE, (Comparable)Boolean.valueOf(n && e && this.canConnect(level.m_8055_(pos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST)))))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(s && w && this.canConnect(level.m_8055_(pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST)))))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(s && e && this.canConnect(level.m_8055_(pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST)))));
    }

    private boolean canConnect(BlockState state) {
        return state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)SINGLE) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, NORTH, SOUTH, EAST, WEST, NW, NE, SW, SE, SINGLE});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TableBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : TableBlock.m_152132_(type, RediscoveredBlockEntityTypes.TABLE, TableBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TableBlockEntity) {
            TableBlockEntity table = (TableBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && table.getItem().m_41619_()) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_ && table.interact(player, hand, player.m_150110_().f_35937_ ? stack.m_41777_() : stack, player.m_6350_())) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TableBlockEntity) {
                TableBlockEntity table = (TableBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)table);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return state;
        }
        Map<Direction, BooleanProperty> cardinals = Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST);
        Map<Direction, BooleanProperty> diagonals = Map.of(Direction.NORTH, NW, Direction.EAST, NE, Direction.SOUTH, SE, Direction.WEST, SW);
        BlockState newState = this.m_49966_();
        for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
            BooleanProperty cardinal = cardinals.get(dir);
            BooleanProperty diagonal = diagonals.get(dir);
            Direction rotatedDir = rotation.m_55954_(dir);
            BooleanProperty rotatedCardinal = cardinals.get(rotatedDir);
            BooleanProperty rotatedDiagonal = diagonals.get(rotatedDir);
            newState = (BlockState)((BlockState)newState.m_61124_((Property)rotatedCardinal, (Comparable)((Boolean)state.m_61143_((Property)cardinal)))).m_61124_((Property)rotatedDiagonal, (Comparable)((Boolean)state.m_61143_((Property)diagonal)));
        }
        return newState;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            boolean e = (Boolean)state.m_61143_((Property)EAST);
            boolean w = (Boolean)state.m_61143_((Property)WEST);
            boolean ne = (Boolean)state.m_61143_((Property)NE);
            boolean nw = (Boolean)state.m_61143_((Property)NW);
            boolean se = (Boolean)state.m_61143_((Property)SE);
            boolean sw = (Boolean)state.m_61143_((Property)SW);
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(w))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(e))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(ne))).m_61124_((Property)NE, (Comparable)Boolean.valueOf(nw))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(se))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(sw));
        }
        if (mirror == Mirror.LEFT_RIGHT) {
            boolean n = (Boolean)state.m_61143_((Property)NORTH);
            boolean s = (Boolean)state.m_61143_((Property)SOUTH);
            boolean ne = (Boolean)state.m_61143_((Property)NE);
            boolean nw = (Boolean)state.m_61143_((Property)NW);
            boolean se = (Boolean)state.m_61143_((Property)SE);
            boolean sw = (Boolean)state.m_61143_((Property)SW);
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(s))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(n))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(sw))).m_61124_((Property)NE, (Comparable)Boolean.valueOf(se))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(nw))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(ne));
        }
        return state;
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return RediscoveredBlocks.FURNITURE_PATH_TYPE;
    }
}

