/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.block_entities.MultiBlockPattern;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import com.legacy.rediscovered.registry.RediscoveredPoiTypes;
import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.api.dimension.portal.GelTeleporter;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkylandsPortalBlock
extends GelPortalBlock {
    public static final int INNER_RADIUS = 1;
    public static final MultiBlockPattern PORTAL_PATTERN = SkylandsPortalBlock.createPortalPattern(false);
    public static final MultiBlockPattern FULL_PORTAL_PATTERN = SkylandsPortalBlock.createPortalPattern(true);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public SkylandsPortalBlock(BlockBehaviour.Properties properties) {
        super(properties, (sl, portal) -> new Teleporter((ServerLevel)sl, (GelPortalBlock)portal));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return pState;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState;
    }

    private static MultiBlockPattern createPortalPattern(boolean full) {
        MultiBlockPattern.MultiBlockPatternBuilder builder = MultiBlockPattern.builder();
        for (int i : new int[]{-1, 1}) {
            int z;
            int x;
            MultiBlockPattern.PatternBuilder pattern = builder.pattern();
            pattern.validator('f', RediscoveredTags.Blocks.SKYLANDS_PORTAL_FRAME);
            pattern.validator('b', RediscoveredTags.Blocks.SKYLANDS_PORTAL_BASE);
            if (full) {
                pattern.validator('a', (self, state) -> state.m_60713_(RediscoveredBlocks.skylands_portal));
            } else {
                pattern.validator('a', (self, state) -> state.m_60795_() || state.m_60713_(RediscoveredBlocks.skylands_portal) || state.m_60713_(RediscoveredBlocks.ruby_eye));
            }
            int r = 1;
            for (x = -r; x <= r; ++x) {
                for (z = -r; z <= r; ++z) {
                    pattern.state(x, 0, z, 'a');
                }
            }
            for (x = -r; x <= r; ++x) {
                for (z = -r; z <= r; ++z) {
                    pattern.state(x, i, z, 'b');
                }
            }
            int f = r + 1;
            for (int x2 = -f; x2 <= f; ++x2) {
                for (int z2 = -f; z2 <= f; ++z2) {
                    int ax = Math.abs(x2);
                    int az = Math.abs(z2);
                    if (ax != f && az != f || ax == az) continue;
                    pattern.state(x2, 0, z2, 'f');
                }
            }
            pattern.end();
        }
        return builder.build();
    }

    protected static boolean inPortalFrame(BlockState state, LevelReader level, BlockPos pos) {
        return SkylandsPortalBlock.inPortalFrame(state, level, pos, PORTAL_PATTERN);
    }

    @Nullable
    protected static Vec3i getPortalOffset(BlockState state, LevelReader level, BlockPos pos) {
        return SkylandsPortalBlock.getPortalOffset(state, level, pos, PORTAL_PATTERN);
    }

    protected static boolean inPortalFrame(BlockState state, LevelReader level, BlockPos pos, MultiBlockPattern pattern) {
        return SkylandsPortalBlock.getPortalOffset(state, level, pos, pattern) != null;
    }

    @Nullable
    protected static Vec3i getPortalOffset(BlockState state, LevelReader level, BlockPos pos, MultiBlockPattern pattern) {
        int r = 1;
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                if (!pattern.isValid(level, pos.m_7918_(x, 0, z), state)) continue;
                return new Vec3i(x, 0, z);
            }
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (SkylandsPortalBlock.inPortalFrame(state, (LevelReader)level, currentPos, FULL_PORTAL_PATTERN)) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(100) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, rand.m_188501_() * 0.4f + 0.8f, false);
        }
        int verticalInversion = level.m_8055_(pos.m_7495_()).m_204336_(RediscoveredTags.Blocks.SKYLANDS_PORTAL_BASE) ? 1 : -1;
        for (int i = 0; i < 1; ++i) {
            double x = rand.m_188501_() * 0.9f + 0.05f;
            double y = 0.5 + 0.127 * (double)verticalInversion;
            double z = rand.m_188501_() * 0.9f + 0.05f;
            double horizontalSpeed = 0.001;
            double dx = ((double)rand.m_188501_() - 0.5) * horizontalSpeed;
            double dy = ((double)rand.m_188501_() - 0.5) * 2.0E-4 + 1.0E-4;
            double dz = ((double)rand.m_188501_() - 0.5) * horizontalSpeed;
            level.m_7106_((ParticleOptions)RediscoveredParticles.SKYLANDS_PORTAL, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, dx, dy * (double)verticalInversion, dz);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTriggerSound() {
        return SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12288_, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTravelSound() {
        return SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12287_, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    public static class Teleporter
    extends GelTeleporter {
        public Teleporter(ServerLevel serverLevel, GelPortalBlock portal) {
            super(serverLevel, () -> RediscoveredDimensions.skylandsKey(), () -> Level.f_46428_, () -> (PoiType)RediscoveredPoiTypes.SKYLANDS_PORTAL.get(), () -> portal, () -> RediscoveredBlocks.large_bricks.m_49966_(), GelTeleporter.CreatePortalBehavior.NETHER);
        }

        public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            BlockPos scaledPos = this.scalePosition(entity, destLevel);
            BlockPos portalPos = this.getPortalEntrancePos(entity);
            BlockState portalState = entity.m_9236_().m_8055_(portalPos);
            Vec3 offset = this.getPositionInPortal(entity, portalPos, portalState);
            Optional<BlockPos> result = this.findPortalAround(scaledPos, portalState, entity);
            if (entity instanceof ServerPlayer && !result.isPresent()) {
                result = this.createPortal(scaledPos);
            }
            if (!result.isPresent()) {
                return null;
            }
            PortalInfo portalInfo = new PortalInfo(Vec3.m_82539_((Vec3i)((Vec3i)result.get())).m_82549_(offset), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
            return portalInfo;
        }

        protected Vec3 getPositionInPortal(Entity entity, BlockPos portalPos, BlockState portalState) {
            Level currentLevel = entity.m_9236_();
            Vec3i portalOffset = SkylandsPortalBlock.getPortalOffset(portalState, (LevelReader)currentLevel, portalPos);
            if (portalOffset != null) {
                Vec3 entityOffset = entity.m_20182_().m_82546_(portalPos.m_252807_());
                return new Vec3(entityOffset.m_7096_() - (double)portalOffset.m_123341_(), 0.0, entityOffset.m_7094_() - (double)portalOffset.m_123343_());
            }
            return Vec3.f_82478_;
        }

        protected Optional<BlockPos> findPortalAround(BlockPos startPos, BlockState portalState, Entity entity) {
            PoiManager poiManager = this.getLevel().m_8904_();
            int dist = (int)Math.max(DimensionType.m_63908_((DimensionType)this.getLevel().m_7654_().m_129880_(this.getOpposite()).m_6042_(), (DimensionType)this.getLevel().m_6042_()) * 16.0, 16.0);
            poiManager.m_27056_((LevelReader)this.getLevel(), startPos, dist);
            Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType.m_203334_() == this.getPortalPOI().get(), startPos, dist, PoiManager.Occupancy.ANY).filter(poi -> poiManager.m_27177_(poi.m_27257_().m_7495_()).orElse(null) != poi.m_218018_()).min(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)startPos)).thenComparingInt(poi -> poi.m_27257_().m_123342_()));
            return optional.map(poi -> {
                BlockPos teleportTo;
                BlockPos poiPos = poi.m_27257_();
                this.getLevel().m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(poiPos), 3, (Object)poiPos);
                BlockState poiState = this.getLevel().m_8055_(poiPos);
                Vec3i portalOffset = SkylandsPortalBlock.getPortalOffset(poiState, (LevelReader)this.getLevel(), poiPos);
                BlockPos blockPos = teleportTo = portalOffset != null ? poiPos.m_121955_(portalOffset) : poiPos;
                if (!this.getLevel().m_8055_(teleportTo.m_7494_()).m_60795_() && this.getLevel().m_8055_(teleportTo.m_7495_()).m_60795_()) {
                    double entityHeight = Math.ceil(entity.m_20191_().m_82376_()) - 1.0;
                    teleportTo = BlockPos.m_274446_((Position)Vec3.m_82539_((Vec3i)teleportTo).m_82520_(0.0, -entityHeight, 0.0));
                }
                return teleportTo;
            });
        }

        protected Optional<BlockPos> createPortal(BlockPos startPos) {
            ServerLevel destLevel = this.getLevel();
            BlockPos portalPos = this.findPortalPosition(destLevel, startPos);
            this.makePortal(this.getLevel(), portalPos);
            return Optional.of(portalPos);
        }

        protected BlockPos findPortalPosition(ServerLevel destLevel, BlockPos origin) {
            int i;
            int x = origin.m_123341_();
            int y = destLevel.m_141928_();
            int z = origin.m_123343_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
            int minHeight = destLevel.m_141937_();
            BlockState state = destLevel.m_8055_((BlockPos)mutablePos);
            for (i = y; i > minHeight && this.shouldIgnoreBlock(state, (BlockPos)mutablePos); --i) {
                state = destLevel.m_8055_((BlockPos)mutablePos.m_122173_(Direction.DOWN));
            }
            y = i <= minHeight ? this.getDefaultHeight() : i + 1;
            return new BlockPos(x, y, z);
        }

        protected void makePortal(ServerLevel destLevel, BlockPos origin) {
            int z;
            int x;
            int r = 1;
            for (int x2 = -r; x2 <= r; ++x2) {
                for (int z2 = -r; z2 <= r; ++z2) {
                    destLevel.m_7731_(origin.m_7918_(x2, -1, z2), RediscoveredBlocks.glowing_obsidian.m_49966_(), 3);
                }
            }
            int f = r + 1;
            for (x = -f; x <= f; ++x) {
                for (z = -f; z <= f; ++z) {
                    int ax = Math.abs(x);
                    int az = Math.abs(z);
                    if (ax != f && az != f) continue;
                    destLevel.m_7731_(origin.m_7918_(x, 0, z), RediscoveredBlocks.large_bricks.m_49966_(), 3);
                }
            }
            for (x = -r; x <= r; ++x) {
                for (z = -r; z <= r; ++z) {
                    destLevel.m_7731_(origin.m_7918_(x, 0, z), RediscoveredBlocks.skylands_portal.m_49966_(), 18);
                }
            }
            for (x = -f; x <= f; ++x) {
                for (z = -f; z <= f; ++z) {
                    for (int y = 1; y <= 2; ++y) {
                        destLevel.m_7731_(origin.m_7918_(x, y, z), Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
    }
}

