/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShallowDirtSlabBlock
extends SlabBlock {
    protected static final VoxelShape BOTTOM_AABB_SHALLOW = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape TOP_AABB_SHALLOW = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private final Block parent;

    public ShallowDirtSlabBlock(Block parent, BlockBehaviour.Properties properties) {
        super(properties);
        this.parent = parent;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((SlabType)state.m_61143_((Property)f_56353_)) {
            case DOUBLE: {
                return Blocks.f_152481_.m_49966_().m_60651_(level, pos, context);
            }
            case TOP: {
                return TOP_AABB_SHALLOW;
            }
        }
        return BOTTOM_AABB_SHALLOW;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (!this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            state = Block.m_49897_((BlockState)this.m_49966_(), (BlockState)IModifyState.mergeStates((BlockState)RediscoveredBlocks.dirt_slab.m_49966_(), (BlockState)state), (LevelAccessor)context.m_43725_(), (BlockPos)context.m_8083_());
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.UP && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.BOTTOM) {
            return this.parent.m_49966_().m_60710_(level, pos);
        }
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        ShallowDirtSlabBlock.turnToDirt(null, state, (Level)level, pos);
    }

    public static void turnToDirt(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState blockstate = ShallowDirtSlabBlock.m_49897_((BlockState)state, (BlockState)IModifyState.mergeStates((BlockState)RediscoveredBlocks.dirt_slab.m_49966_(), (BlockState)state), (LevelAccessor)level, (BlockPos)pos);
        level.m_46597_(pos, blockstate);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
    }
}

