/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.block.GearBlock;
import com.legacy.rediscovered.block_entities.GearBlockEntity;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RotationalConverterBlock
extends DirectionalBlock {
    public static final EnumProperty<Mode> MODE = EnumProperty.m_61587_((String)"mode", Mode.class);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public RotationalConverterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)((Object)Mode.GEAR_TO_REDSTONE))).m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.NORTH));
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return this.m_6843_(state, mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        if (state.m_61143_(MODE) == Mode.GEAR_TO_REDSTONE) {
            BlockEntity blockEntity = level.m_7702_(pos.m_121945_(facing));
            if (blockEntity instanceof GearBlockEntity) {
                GearBlockEntity gear = (GearBlockEntity)blockEntity;
                Direction redstoneSide = facing.m_122424_();
                GearBlock.GearFace gearFace = GearBlock.GearFace.get(redstoneSide);
                gear.stopSpinning(level, pos, pos.m_121945_(facing), gearFace);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(gear.isPowered(gearFace))), 3);
            } else if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            }
            this.updateNeighborsOnFaces((Level)level, pos, state);
        } else {
            GearBlockEntity gear;
            BlockPos gearPos;
            BlockEntity blockEntity;
            Direction redstoneSide = facing.m_122424_();
            GearBlock.GearFace gearFace = GearBlock.GearFace.get(redstoneSide);
            int redstoneStrength = level.m_277185_(pos.m_121945_(redstoneSide), redstoneSide);
            boolean powered = level.m_276987_(pos.m_121945_(facing.m_122424_()), facing.m_122424_());
            if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
            }
            if ((blockEntity = level.m_7702_(gearPos = pos.m_121945_(facing))) instanceof GearBlockEntity && (gear = (GearBlockEntity)blockEntity).getPower(gearFace).getPower() != redstoneStrength) {
                gear.stopSpinning(level, pos, pos.m_121945_(facing), gearFace);
                if (powered) {
                    gear.startSpinning(level, pos, pos.m_121945_(facing), gearFace, redstoneStrength, 0);
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.m_5776_()) {
            level.m_186460_(pos, (Block)this, 2);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return state;
    }

    public boolean m_7899_(BlockState state) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return state.m_61143_((Property)f_52588_) == direction ? true : super.canConnectRedstone(state, level, pos, direction);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return state.m_60746_(level, pos, side);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (state.m_61143_(MODE) == Mode.GEAR_TO_REDSTONE && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && state.m_61143_((Property)f_52588_) == side) {
            BlockEntity blockEntity = level.m_7702_(pos.m_121945_(side));
            if (blockEntity instanceof GearBlockEntity) {
                GearBlockEntity gear = (GearBlockEntity)blockEntity;
                return Math.abs(gear.getPower(GearBlock.GearFace.get(side.m_122424_())).getPower());
            }
            return 0;
        }
        return 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return side == ((Direction)state.m_61143_((Property)f_52588_)).m_122424_() && state.m_61143_(MODE) == Mode.REDSTONE_TO_GEAR;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_() && !level.m_5776_() && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !level.m_183326_().m_183582_(pos, (Object)this)) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
            level.m_7731_(pos, blockstate, 18);
            this.updateNeighborsOnFaces(level, pos, blockstate);
        }
        state.m_60701_((LevelAccessor)level, pos, 3);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && !level.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && level.m_183326_().m_183582_(pos, (Object)this)) {
            this.updateNeighborsOnFaces(level, pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
        state.m_60701_((LevelAccessor)level, pos, 3);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41720_() == RediscoveredBlocks.gear.m_5456_() && state.m_61143_((Property)f_52588_) == hit.m_82434_()) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_()) {
            BlockState newState = (BlockState)state.m_61122_(MODE);
            level.m_46597_(pos, newState);
            float f = (Boolean)newState.m_61143_((Property)POWERED) != false ? 0.6f : 0.5f;
            level.m_5594_((Player)null, pos, RediscoveredSounds.BLOCK_ROTATIONAL_CONVERTER_CLICK, SoundSource.BLOCKS, 0.3f, f);
            this.updateNeighbors(newState, level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void updateNeighborsOnFaces(Level level, BlockPos pos, BlockState state) {
        for (Direction direction : new Direction[]{(Direction)state.m_61143_((Property)f_52588_), ((Direction)state.m_61143_((Property)f_52588_)).m_122424_()}) {
            BlockPos blockpos = pos.m_121945_(direction.m_122424_());
            level.m_46586_(blockpos, (Block)this, pos);
            level.m_46590_(blockpos, (Block)this, direction);
        }
    }

    private void updateNeighbors(BlockState state, Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
        Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        level.m_46672_(pos.m_121945_(facing), (Block)this);
        level.m_46672_(pos.m_121945_(facing.m_122424_()), (Block)this);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_7820_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODE, POWERED, DirectionalBlock.f_52588_});
    }

    public static enum Mode implements StringRepresentable
    {
        GEAR_TO_REDSTONE,
        REDSTONE_TO_GEAR;


        public String m_7912_() {
            return this.toString().toLowerCase();
        }
    }
}

