/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.block_entities.RedDragonEggBlockEntity;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.registry.RediscoveredBlockEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredParticles;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedDragonEggBlock
extends FallingBlock
implements EntityBlock {
    public static final BooleanProperty FALLING = BooleanProperty.m_61465_((String)"falling");
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)});
    public static final String HATCH_DISABLED_KEY = "rediscovered.message.dragon_hatch_disabled";

    public RedDragonEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FALLING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)FALLING) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)this);
        level.m_141902_(pos, RediscoveredBlockEntityTypes.RED_DRAGON_EGG).ifPresent(egg -> {
            if (egg.m_8077_()) {
                stack.m_41714_(egg.m_7755_());
            }
        });
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!RediscoveredConfig.WORLD.hatchableRedDragon()) {
            player.m_5661_((Component)Component.m_237115_((String)HATCH_DISABLED_KEY), true);
            return InteractionResult.SUCCESS;
        }
        RedDragonEggBlockEntity egg = level.m_141902_(pos, RediscoveredBlockEntityTypes.RED_DRAGON_EGG).orElse(null);
        if (egg != null) {
            ItemStack heldItem = player.m_21120_(hand);
            if (heldItem.m_150930_(Items.f_42735_) && egg.startHatching(player)) {
                if (!player.m_7500_()) {
                    ItemStack container = heldItem.getCraftingRemainingItem();
                    heldItem.m_41774_(1);
                    if (heldItem.m_41619_()) {
                        player.m_21008_(hand, container);
                    } else {
                        player.m_36356_(container);
                    }
                }
                level.m_247517_(null, pos, RediscoveredSounds.BLOCK_RED_DRAGON_EGG_FERTILIZE, SoundSource.PLAYERS);
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    Vec3 p = Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.3, 0.0);
                    float offset = 0.3f;
                    sl.m_8767_((ParticleOptions)RediscoveredParticles.DRAGON_BREATH_POUR, p.f_82479_, p.f_82480_, p.f_82481_, 60, (double)offset, (double)0.15f, (double)offset, (double)0.01f);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_7500_() && egg.canHatch() && egg.hatchDragon(level, state, pos, true)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_141902_(pos, RediscoveredBlockEntityTypes.RED_DRAGON_EGG).ifPresent(egg -> egg.setPlacedBy(stack, placer));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (RedDragonEggBlock.m_53241_((BlockState)pLevel.m_8055_(pPos.m_7495_())) && pPos.m_123342_() >= pLevel.m_141937_()) {
            CompoundTag tag = pLevel.m_141902_(pPos, RediscoveredBlockEntityTypes.RED_DRAGON_EGG).map(egg -> egg.m_187482_()).orElse(null);
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)pPos, (BlockState)((BlockState)pState.m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(true))));
            if (tag != null) {
                fallingblockentity.f_31944_ = tag;
            }
            this.m_6788_(fallingblockentity);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (((Boolean)state.m_61143_((Property)FALLING)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public int m_7198_() {
        return 5;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return RediscoveredBlockEntityTypes.RED_DRAGON_EGG.m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RedDragonEggBlock.createTickerHelper(type, RediscoveredBlockEntityTypes.RED_DRAGON_EGG, level.f_46443_ ? RedDragonEggBlockEntity::clientTick : RedDragonEggBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> pServerType, BlockEntityType<E> pClientType, BlockEntityTicker<? super E> pTicker) {
        return pClientType == pServerType ? pTicker : null;
    }
}

