/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ObsidianBulbBlock
extends Block {
    public static final IntegerProperty LIGHT_LEVEL = BlockStateProperties.f_61422_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final String BLOCK_STATE_TAG = "BlockStateTag";

    public ObsidianBulbBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (state.m_60734_() != oldState.m_60734_() && level instanceof ServerLevel) {
            this.placeUpdated(state, level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        this.placeUpdated(state, (Level)level, pos);
    }

    public void placeUpdated(BlockState state, Level level, BlockPos pos) {
        int signal;
        int lightLevel = (Integer)state.m_61143_((Property)LIGHT_LEVEL);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        if (powered != (signal = level.m_277086_(pos)) > 0) {
            BlockState newState = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal > 0));
            if (signal > 0) {
                newState = (BlockState)newState.m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel == 0 ? signal : 0));
            }
            if (newState != state) {
                level.m_7731_(pos, newState, 3);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHT_LEVEL, POWERED});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ObsidianBulbBlock.setLightOnStack(new ItemStack((ItemLike)this), (Integer)state.m_61143_((Property)LIGHT_LEVEL));
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int light = ObsidianBulbBlock.getLightFromStack(stack);
        if (light > 0) {
            tooltip.add((Component)Component.m_237113_((String)("Light: " + light)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static ItemStack setLightOnStack(ItemStack stack, int light) {
        if (light != 0) {
            CompoundTag blockStateTag = new CompoundTag();
            blockStateTag.m_128359_(LIGHT_LEVEL.m_61708_(), String.valueOf(light));
            stack.m_41700_(BLOCK_STATE_TAG, (Tag)blockStateTag);
        }
        return stack;
    }

    public static int getLightFromStack(ItemStack stack) {
        CompoundTag bsTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(BLOCK_STATE_TAG, 10) && (bsTag = tag.m_128469_(BLOCK_STATE_TAG)).m_128425_(LIGHT_LEVEL.m_61708_(), 8)) {
            try {
                return Integer.parseInt(bsTag.m_128461_(LIGHT_LEVEL.m_61708_()));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }
}

